/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.build.Project;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectBundle
implements IAdaptable {
    private final Project project;
    private final String bsn;

    ProjectBundle(Project project, String bsn) {
        this.project = project;
        this.bsn = bsn;
    }

    public Project getProject() {
        return this.project;
    }

    public String getBsn() {
        return this.bsn;
    }

    public String toString() {
        return "ProjectBundle [project=" + String.valueOf(this.project) + ", bsn=" + this.bsn + "]";
    }

    public <T> T getAdapter(Class<T> adapter) {
        IFile result = null;
        if (IFile.class.equals(adapter) || IResource.class.equals(adapter)) {
            try {
                File targetDir = this.project.getTarget();
                File bundleFile = new File(targetDir, this.bsn + ".jar");
                if (bundleFile.isFile()) {
                    Path path = new Path(bundleFile.getAbsolutePath());
                    result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                }
            }
            catch (Exception e) {
                ILog.get().error(MessageFormat.format("Error retrieving bundle {0} from project {1}.", this.bsn, this.project.getName()), (Throwable)e);
            }
        }
        return (T)result;
    }

    public boolean isSub() {
        return !this.project.getName().equals(this.bsn);
    }
}

