/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ua.ui.editor.toc.HelpEditorUtil;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocMessages;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TocFileValidator
implements ISelectionStatusValidator {
    IBaseModel fModel;

    public TocFileValidator(IBaseModel model) {
        this.fModel = model;
    }

    public IStatus validate(Object[] selection) {
        if (selection.length == 0) {
            return Status.error((String)"");
        }
        if (!(selection[0] instanceof IFile)) {
            return Status.error((String)"");
        }
        IFile file = (IFile)selection[0];
        if (!HelpEditorUtil.isTOCFile(file.getFullPath())) {
            return Status.error((String)TocMessages.TocFileValidator_errorMessage1);
        }
        if (HelpEditorUtil.isCurrentResource(file.getFullPath(), this.fModel)) {
            return Status.error((String)TocMessages.TocFileValidator_errorMessage2);
        }
        return Status.OK_STATUS;
    }
}

