/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.contentassist;

import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xcore.XReference;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;

public class OppositeReplacementTextApplier
extends ReplacementTextApplier {
    protected XReference xReference;
    protected ITextViewer viewer;
    protected IScope scope;
    protected XcoreMapper mapper;
    protected IQualifiedNameConverter qualifiedNameConverter;
    protected IValueConverter<String> qualifiedNameValueConverter;

    public OppositeReplacementTextApplier(XReference xReference, ITextViewer viewer, IScope scope, XcoreMapper mapper, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> qualifiedNameValueConverter) {
        this.xReference = xReference;
        this.viewer = viewer;
        this.scope = scope;
        this.mapper = mapper;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.qualifiedNameValueConverter = qualifiedNameValueConverter;
    }

    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        List nodes;
        XReference oppositeXReference;
        String replacementString = this.getActualReplacementString(proposal);
        proposal.setCursorPosition(replacementString.length());
        int replacementOffset = proposal.getReplacementOffset();
        IEObjectDescription oppositeDescription = this.scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName((String)this.qualifiedNameValueConverter.toValue(replacementString, null)));
        EObject opposite = oppositeDescription.getEObjectOrProxy();
        if (opposite instanceof GenFeature && opposite.eResource() == this.xReference.eResource() && (oppositeXReference = (XReference)this.mapper.getToXcoreMapping(opposite).getXcoreElement()).getOpposite() == null && !(nodes = NodeModelUtils.findNodesForFeature((EObject)oppositeXReference, (EStructuralFeature)XcorePackage.Literals.XNAMED_ELEMENT__NAME)).isEmpty()) {
            INode node = (INode)nodes.get(nodes.size() - 1);
            int offset = node.getOffset();
            String oppositeReplacement = " opposite " + this.qualifiedNameValueConverter.toString((Object)this.xReference.getName());
            if (replacementOffset > offset) {
                document.replace(replacementOffset, proposal.getReplacementLength(), replacementString);
                document.replace(offset + node.getLength(), 0, oppositeReplacement);
            } else {
                document.replace(offset + node.getLength(), 0, oppositeReplacement);
                document.replace(replacementOffset, proposal.getReplacementLength(), replacementString);
            }
            return;
        }
        document.replace(replacementOffset, proposal.getReplacementLength(), replacementString);
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        return proposal.getReplacementString();
    }
}

