/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesTree;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NonDeletedFilesDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private static final int RETRY = 98;
    private final Repository repository;
    private final List<String> filePaths;
    private NonDeletedFilesTree tree;
    private Button retry;

    public NonDeletedFilesDialog(Shell shell, Repository repository, List<String> filePaths) {
        super(shell, UIText.NonDeletedFilesDialog_NonDeletedFilesTitle, INFO, UIText.NonDeletedFilesDialog_NonDeletedFilesMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.filePaths = filePaths;
    }

    protected Control createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        this.tree = new NonDeletedFilesTree(main, this.repository, this.filePaths);
        NonDeletedFilesDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 98) {
            boolean refresh = false;
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String filePath : this.filePaths) {
                File file = new File(this.repository.getWorkTree(), filePath);
                try {
                    FileUtils.delete((File)file, (int)5);
                    refresh = true;
                }
                catch (IOException e) {
                    newPaths.add(filePath);
                }
            }
            this.filePaths.clear();
            this.filePaths.addAll(newPaths);
            this.tree.setInput(this.filePaths);
            UIUtils.expandAll((AbstractTreeViewer)this.tree);
            if (refresh) {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Activator.handleError(e.getMessage(), e, false);
                }
            }
            this.retry.setEnabled(!this.filePaths.isEmpty());
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.retry = this.createButton(parent, 98, UIText.NonDeletedFilesDialog_RetryDeleteButton, false);
        super.createButtonsForButtonBar(parent);
    }
}

