/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.navigation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.common.types.ui.navigation.LinkToOrigin;
import org.eclipse.xtext.common.types.ui.navigation.LinkToOriginProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.internal.IPlatformSpecificTrace;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;

public class LinkToOriginDetector
extends AbstractHyperlinkDetector {
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        try {
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (textEditor == null) {
                return null;
            }
            IEditorInput editorInput = textEditor.getEditorInput();
            if (editorInput == null) {
                return null;
            }
            IJavaElement adaptedJavaElement = (IJavaElement)Platform.getAdapterManager().getAdapter((Object)editorInput, IJavaElement.class);
            if (adaptedJavaElement == null) {
                return null;
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)adaptedJavaElement.getAncestor(5);
            if (compilationUnit == null) {
                return null;
            }
            try {
                IJavaElement[] javaElements;
                IRegion selectedWord = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
                IJavaElement[] iJavaElementArray = javaElements = compilationUnit.codeSelect(selectedWord.getOffset(), selectedWord.getLength());
                int n = javaElements.length;
                int n2 = 0;
                while (true) {
                    IMember selectedMember;
                    IResource resource;
                    boolean provideHyperlinkOnReferences;
                    if (n2 >= n) {
                        return null;
                    }
                    IJavaElement javaElement = iJavaElementArray[n2];
                    boolean bl = provideHyperlinkOnReferences = !this.is_ORG_ECLIPSE_UI_IDE_3_8_Enabled() || compilationUnit.equals(((IMember)javaElement).getCompilationUnit());
                    if (javaElement instanceof IMember && provideHyperlinkOnReferences && (resource = (selectedMember = (IMember)javaElement).getResource()) instanceof IFile) {
                        IPlatformSpecificTrace traceToSource = this.traceInformation.getTraceToSource((Object)((IStorage)resource));
                        if (traceToSource == null) {
                            return null;
                        }
                        ILocationInResource sourceInformation = (ILocationInResource)Iterables.getFirst((Iterable)traceToSource.getAllAssociatedLocations(), null);
                        if (sourceInformation == null) return null;
                        try {
                            URI resourceURI = sourceInformation.getAbsoluteResourceURI().getURI();
                            if (resourceURI == null) return null;
                            IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceURI);
                            if (serviceProvider == null) {
                                return null;
                            }
                            LinkToOriginProvider provider = (LinkToOriginProvider)serviceProvider.get(LinkToOriginProvider.class);
                            LinkToOrigin hyperlink = provider.createLinkToOrigin(sourceInformation, selectedWord, selectedMember, compilationUnit, Collections.emptyList());
                            if (hyperlink == null) return null;
                            return new IHyperlink[]{hyperlink};
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        return null;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean is_ORG_ECLIPSE_UI_IDE_3_8_Enabled() {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.eclipse.ui.ide.IDE");
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

