/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

public class MavenWorkspaceRuntime
extends AbstractMavenRuntime {
    private static final ArtifactKey MAVEN_DISTRIBUTION = new ArtifactKey("org.apache.maven", "apache-maven", "[3.0,)", null);
    private static final ArtifactKey PLEXUS_CLASSWORLDS = new ArtifactKey("org.codehaus.plexus", "plexus-classworlds", null, null);
    private static final String MAVEN_EXECUTOR_CLASS = "org.apache.maven.cli.MavenCli";
    private static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";

    public MavenWorkspaceRuntime(String name) {
        super(name);
    }

    protected ArtifactKey getDistributionArtifactKey() {
        return MAVEN_DISTRIBUTION;
    }

    protected String getMainClass() {
        return MAVEN_EXECUTOR_CLASS;
    }

    @Override
    public String getLocation() {
        return "WORKSPACE";
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return this.getMavenDistribution() != null && this.isSupportedVersion();
    }

    protected IMavenProjectFacade getMavenDistribution() {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)this.getDistributionArtifactKey().version());
            for (IMavenProjectFacade facade : MavenPlugin.getMavenProjectRegistry().getProjects()) {
                ArtifactKey artifactKey = facade.getArtifactKey();
                if (!this.getDistributionArtifactKey().groupId().equals(artifactKey.groupId()) || !this.getDistributionArtifactKey().artifactId().equals(artifactKey.artifactId()) || !range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifactKey.version()))) continue;
                return facade;
            }
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void createLauncherConfiguration(AbstractMavenRuntime.IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            MavenProject mavenProject = maven.getMavenProject(monitor);
            collector.setMainType(this.getMainClass(), PLEXUS_CLASSWORLD_NAME);
            collector.addRealm(PLEXUS_CLASSWORLD_NAME);
            this.collectExtensions(collector, monitor);
            for (IMavenProjectFacade facade : MavenPlugin.getMavenProjectRegistry().getProjects()) {
                File loggingConfigurationDirectory;
                ArtifactKey artifactKey = facade.getArtifactKey();
                if (!this.getDistributionArtifactKey().groupId().equals(artifactKey.groupId()) || !this.getDistributionArtifactKey().artifactId().equals(artifactKey.artifactId()) || !(loggingConfigurationDirectory = new File(facade.getPomFile().getParentFile(), "src/conf/logging")).exists()) continue;
                collector.addArchiveEntry(loggingConfigurationDirectory.getAbsolutePath());
            }
            Set artifacts = mavenProject.getArtifacts();
            Artifact launcherArtifact = null;
            IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
            for (Artifact artifact : artifacts) {
                if ("test".equals(artifact.getScope())) continue;
                if (PLEXUS_CLASSWORLDS.groupId().equals(artifact.getGroupId()) && PLEXUS_CLASSWORLDS.artifactId().equals(artifact.getArtifactId())) {
                    launcherArtifact = artifact;
                    continue;
                }
                this.addArtifact(collector, artifact, projectRegistry);
            }
            if (launcherArtifact != null) {
                collector.addRealm("]launcher");
                this.addArtifact(collector, launcherArtifact, projectRegistry);
            }
        }
    }

    private void addArtifact(AbstractMavenRuntime.IMavenLauncherConfiguration collector, Artifact artifact, IMavenProjectRegistry registry) throws CoreException {
        IMavenProjectFacade facade = registry.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (facade != null) {
            collector.addProjectEntry(facade);
        } else {
            File file = artifact.getFile();
            if (file != null) {
                collector.addArchiveEntry(file.getAbsolutePath());
            }
        }
    }

    public String toString() {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            return maven.getProject().getName() + " " + maven.getArtifactKey().version();
        }
        return this.getDistributionArtifactKey().version();
    }

    @Override
    public String getVersion() {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            return maven.getArtifactKey().version();
        }
        return this.getDistributionArtifactKey().version();
    }
}

