/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.content.PomHandler;
import org.eclipse.m2e.core.internal.content.XMLContentDescriber;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PomFileContentDescriber
extends XMLContentDescriber {
    private int checkCriteria(InputSource contents) throws IOException {
        PomHandler pomHandler = new PomHandler();
        try {
            if (!pomHandler.parseContents(contents)) {
                return 1;
            }
        }
        catch (SAXException e) {
            return 1;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(Messages.PomFileContentDescriber_error);
        }
        if (pomHandler.hasRootProjectElement()) {
            if (pomHandler.hasArtifactIdElement()) {
                return 2;
            }
            return 1;
        }
        return 1;
    }

    @Override
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    @Override
    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }
}

