/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.bundle.internal;

import jakarta.inject.Inject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.pde.spy.bundle.internal.BundleDataFilter;
import org.eclipse.pde.spy.bundle.internal.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class BundleDataProvider
extends ColumnLabelProvider {
    public static final int COL_NAME = 0;
    public static final int COL_VERSION = 1;
    public static final int COL_STATE = 2;
    private static final Color COLOR_IF_FOUND = Display.getCurrent().getSystemColor(9);
    @Inject
    private ImageRegistry imgReg;
    @Inject
    private BundleDataFilter bundleFilter;
    private int column;

    @Inject
    public BundleDataProvider() {
    }

    public String getText(Object element) {
        Bundle b = (Bundle)element;
        String result = BundleDataProvider.getText(b, this.column);
        return result == null ? super.getText(element) : result;
    }

    public static String getText(Bundle b, int col) {
        switch (col) {
            case 0: {
                return b.getSymbolicName();
            }
            case 1: {
                return b.getVersion().toString();
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        String s = this.getText(element);
        return this.bundleFilter != null && this.bundleFilter.matchText(s) ? COLOR_IF_FOUND : null;
    }

    public Image getImage(Object element) {
        Bundle b = (Bundle)element;
        if (this.column == 2) {
            switch (b.getState()) {
                case 32: {
                    return this.imgReg.get("icons/state_active.svg");
                }
                case 2: {
                    return this.imgReg.get("icons/state_installed.svg");
                }
                case 4: {
                    return this.imgReg.get("icons/state_resolved.svg");
                }
                case 8: {
                    return this.imgReg.get("icons/state_starting.svg");
                }
                case 16: {
                    return this.imgReg.get("icons/state_stopping.svg");
                }
                case 1: {
                    return this.imgReg.get("icons/state_uninstalled.svg");
                }
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        Bundle b = (Bundle)element;
        switch (b.getState()) {
            case 32: {
                return Messages.BundleDataProvider_1;
            }
            case 2: {
                return Messages.BundleDataProvider_2;
            }
            case 4: {
                return Messages.BundleDataProvider_3;
            }
            case 8: {
                return Messages.BundleDataProvider_4;
            }
            case 16: {
                return Messages.BundleDataProvider_5;
            }
            case 1: {
                return Messages.BundleDataProvider_6;
            }
        }
        return Messages.BundleDataProvider_7 + b.getState();
    }

    public Image getToolTipImage(Object object) {
        return this.getImage(object);
    }

    public int getToolTipStyle(Object object) {
        return 8;
    }

    public void setColumn(int col) {
        this.column = col;
    }
}

