/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.java;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ModelImporterApplication;
import org.eclipse.emf.importer.java.JavaImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;

public class JavaImporterApplication
extends ModelImporterApplication {
    protected Map<String, PackageInfo> nameToPackageInfo;
    protected IPath genModelLocation;

    public JavaImporter getJavaImporter() {
        return (JavaImporter)this.getModelImporter();
    }

    protected ModelImporter createModelImporter() {
        return new JavaImporter();
    }

    protected StringBuffer getUsage() {
        StringBuffer result = new StringBuffer();
        this.appendLine(result, "Usage: <workspace absolute path of model.genmodel> [ -reload ] <OPTION>");
        this.appendLine(result, "<OPTION>            ::= [ <PROJECT-OPTION> ]  [ <PATHMAP> ]");
        this.appendLine(result, "                        { <PACKAGE> }+  { <REF-PACKAGE> }* { <REF-GEN-MODEL> }*");
        this.appendLine(result, "                        [ <TEMPLATE-PATH> ] [ <MODEL-PLUGIN-ID> ] [ <COPYRIGHT> ]");
        this.appendLine(result, "                        [ <SDO> ] [ <QUIET> ]");
        this.appendLine(result, "<PROJECT-OPTION>    ::= <MODEL-PROJECT> [ <EDIT-PROJECT> ] [ <EDITOR-PROJECT> ]");
        this.appendLine(result, "                        [ <TESTS-PROJECT> ]");
        this.appendLine(result, "<MODEL-PROJECT>     ::= -modelProject <model-directory>");
        this.appendLine(result, "<EDIT-PROJECT>      ::= -editProject <edit-directory> <fragment-path>");
        this.appendLine(result, "<EDITOR-PROJECT>    ::= -editorProject <editor-directory> <fragment-path>");
        this.appendLine(result, "<TESTS-PROJECT>     ::= -testsProject <tests-directory> <fragment-path>");
        this.appendLine(result, "<PACKAGE>           ::= -package <nsURI> [ <base> <prefix> ]");
        this.appendLine(result, "<REF-GEN-MODEL>     ::= -refGenModel <model.genmodel> { <nsURI> }+");
        this.appendLine(result, "<TEMPLATE-PATH>     ::= -templatePath <template-directory>");
        this.appendLine(result, "<MODEL-PLUGIN-ID>   ::= -modelPluginID <plugin-ID>");
        this.appendLine(result, "<COPYRIGHT>         ::= -copyright <copyright-string>");
        this.appendLine(result, "<JDK-LEVEL>         ::= -jdkLevel <jdk level: 1.4 5.0 6.0>");
        this.appendLine(result, "<IMPORT-ORGANIZING> ::= -importOrganizing");
        this.appendLine(result, "<VALIDATE-MODEL>    ::= -validateModel <true|false>");
        this.appendLine(result, "<SDO>               ::= -sdo");
        this.appendLine(result, "<QUIET>             ::= -quiet");
        this.appendLine(result, "");
        this.appendLine(result, "For example:");
        this.appendLine(result, "");
        this.appendLine(result, "");
        this.appendLine(result, "  java2genmodel");
        this.appendLine(result, "    /library/model/lib.genmodel");
        this.appendLine(result, "    -modelProject result");
        this.appendLine(result, "    -editProject result.edit src");
        this.appendLine(result, "    -editorProject result.editor src");
        return result;
    }

    protected int processModelAndGenModelLocationArguments(String[] arguments, int index) {
        String arg;
        if (arguments.length > 0 && (arg = arguments[index++]).endsWith(".genmodel")) {
            this.genModelFullPath = new Path(arg);
            return index;
        }
        throw new IllegalArgumentException("Invalid arguments.  Run this application without arguments for the usage help.");
    }

    protected int processModelProjectArguments(String[] arguments, int index) {
        this.modelProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
        return index;
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-package")) {
            if (this.nameToPackageInfo == null) {
                this.nameToPackageInfo = new HashMap<String, PackageInfo>();
            }
        } else {
            return super.processArgument(arguments, index);
        }
        index = this.processPackageInformation(arguments, index, this.nameToPackageInfo);
        return index + 1;
    }

    protected int processPackageInformation(String[] arguments, int index, Map<String, PackageInfo> nsURIToPackageInfo) {
        int start = index;
        PackageInfo packageInfo = new PackageInfo();
        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
            packageInfo.nsURI = arguments[++index];
            if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                packageInfo.base = arguments[++index];
                if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                    packageInfo.prefix = arguments[++index];
                }
            }
            if (index - start != 1 && index - start != 3) {
                throw new IllegalArgumentException("Error: Expecting either 1 or 3 arguments for " + arguments[start]);
            }
            nsURIToPackageInfo.put(packageInfo.nsURI, packageInfo);
            nsURIToPackageInfo.put(packageInfo.nsURI.toLowerCase(), packageInfo);
            return index;
        }
        throw new IllegalArgumentException("Error: No package name was specified for " + arguments[start]);
    }

    protected boolean usePlatformURI() {
        return true;
    }

    protected void adjustModelImporter(Monitor monitor) {
        super.adjustModelImporter(monitor);
        IFile genModelFile = this.getJavaImporter().getGenModelFile();
        if (!genModelFile.getProject().exists()) {
            try {
                IProject project = genModelFile.getProject();
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                projectDescription.setLocation(this.modelProjectLocationPath);
                project.create(projectDescription, BasicMonitor.toIProgressMonitor((Monitor)monitor));
            }
            catch (CoreException e) {
                JavaImporterPlugin.INSTANCE.log((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void adjustModelImporterAfterPrepare() {
        super.adjustModelImporterAfterPrepare();
    }

    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            List ePackages = this.getJavaImporter().getEPackages();
            this.traverseEPackages(ePackages);
            this.getJavaImporter().adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void traverseEPackages(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            PackageInfo packageInfo;
            if (this.nameToPackageInfo != null && (packageInfo = this.nameToPackageInfo.get(ePackage.getNsURI())) != null) {
                this.handleEPackage(ePackage, true);
                ModelImporter.EPackageImportInfo ePackageInfo = this.getJavaImporter().getEPackageImportInfo(ePackage);
                if (ePackageInfo.getBasePackage() == null) {
                    ePackageInfo.setBasePackage(packageInfo.base);
                }
                if (ePackageInfo.getPrefix() == null) {
                    ePackageInfo.setPrefix(packageInfo.prefix);
                }
            }
            this.handleQualifiedEPackageName(ePackage);
            this.traverseEPackages((List<EPackage>)ePackage.getESubpackages());
        }
    }

    public static class PackageInfo {
        public String nsURI;
        public String base;
        public String prefix;
    }
}

