/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StringListEditor {
    private final Table table;
    private final TableEditor editor;
    private final List<StringListChangeListener> listeners = new ArrayList<StringListChangeListener>();
    private final Button addButton;
    private final Button variablesButton;

    public StringListEditor(Composite parent, boolean variableSelector, String newEntryName) {
        this.table = new Table(parent, 98306);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).hint(-1, 65).applyTo((Control)this.table);
        this.table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.pack();
        column.setWidth(this.table.getClientArea().width);
        this.autoResizeColumnToTableWidth(column);
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.hookEditoToTable();
        Composite buttonRoot = new Composite(parent, 0);
        GridDataFactory.swtDefaults().span(2, 1).align(131072, 1).applyTo((Control)buttonRoot);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(buttonRoot);
        this.addButton = this.createButton(buttonRoot, "Add", () -> this.addEntries(Arrays.asList(newEntryName)));
        this.variablesButton = variableSelector ? this.createButton(buttonRoot, LaunchMessages.Button_Label_SelectVariables, () -> {
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(buttonRoot.getShell());
            dialog.open();
            String variable = dialog.getVariableExpression();
            if (variable != null) {
                this.addEntries(Arrays.asList(variable));
            }
        }) : null;
    }

    private void autoResizeColumnToTableWidth(final TableColumn column) {
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                column.setWidth(StringListEditor.this.table.getClientArea().width);
            }
        });
    }

    private void hookEditoToTable() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = StringListEditor.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                final Text newEditor = new Text((Composite)StringListEditor.this.table, 0);
                newEditor.setText(item.getText(0));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text text = (Text)StringListEditor.this.editor.getEditor();
                        StringListEditor.this.editor.getItem().setText(0, text.getText());
                        StringListEditor.this.notifyListeners();
                    }
                });
                newEditor.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        int index;
                        String text = newEditor.getText();
                        if (text.isEmpty() && (index = StringListEditor.this.table.indexOf(StringListEditor.this.editor.getItem())) >= 0) {
                            StringListEditor.this.table.remove(index);
                            StringListEditor.this.notifyListeners();
                        }
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                StringListEditor.this.editor.setEditor((Control)newEditor, item, 0);
            }
        });
    }

    private Button createButton(Composite root, String label, final Runnable onSelection) {
        Button button = new Button(root, 8);
        button.setText(label);
        GridDataFactory.swtDefaults().align(16384, 1).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                onSelection.run();
            }
        });
        return button;
    }

    public void setEntries(List<String> items) {
        this.table.removeAll();
        this.addEntries(items);
    }

    public void addEntries(List<String> items) {
        for (String item : items) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(new String[]{item});
        }
        this.notifyListeners();
    }

    public List<String> getEntries() {
        return Arrays.stream(this.table.getItems()).map(ti -> ti.getText()).collect(Collectors.toList());
    }

    public void removeSelected() {
        List indexes = Ints.asList((int[])this.table.getSelectionIndices());
        Collections.sort(indexes, Collections.reverseOrder());
        for (Integer index : indexes) {
            this.table.remove(index.intValue());
            Control cellEditor = this.editor.getEditor();
            if (cellEditor == null || cellEditor.isDisposed()) continue;
            this.editor.getEditor().setVisible(false);
        }
        this.notifyListeners();
    }

    public void setLayoutData(Object layoutData) {
        this.table.setLayoutData(layoutData);
    }

    public Composite getComposite() {
        return this.table;
    }

    private void notifyListeners() {
        this.listeners.forEach(l -> l.onChange());
    }

    public void addChangeListener(StringListChangeListener listener) {
        this.listeners.add(listener);
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        if (this.variablesButton != null) {
            this.variablesButton.setEnabled(enabled);
        }
    }

    @FunctionalInterface
    public static interface StringListChangeListener {
        public void onChange();
    }
}

