/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class PluginsLabelProvider
extends LabelProvider {
    private final PDELabelProvider sharedProvider = PDEPlugin.getDefault().getLabelProvider();
    private final Image projectImage;
    private final Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");

    public PluginsLabelProvider() {
        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.sharedProvider.connect((Object)this);
    }

    public void dispose() {
        this.sharedProvider.disconnect((Object)this);
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof IPluginModelBase) {
            return this.getText((IPluginModelBase)obj);
        }
        if (obj instanceof FileAdapter) {
            return this.getText((FileAdapter)obj);
        }
        if (obj instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)obj).getPath().lastSegment();
        }
        if (obj instanceof IJavaElement) {
            return ((IJavaElement)obj).getElementName();
        }
        if (obj instanceof IStorage) {
            return ((IStorage)obj).getName();
        }
        if (obj instanceof IDeferredWorkbenchAdapter) {
            return ((IDeferredWorkbenchAdapter)obj).getLabel(obj);
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof IPluginModelBase) {
            return this.getImage((IPluginModelBase)obj);
        }
        if (obj instanceof FileAdapter) {
            return this.getImage((FileAdapter)obj);
        }
        if (obj instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)obj;
            boolean hasSource = false;
            try {
                hasSource = root.getSourceAttachmentPath() != null;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return JavaUI.getSharedImages().getImage(hasSource ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif");
        }
        if (obj instanceof IPackageFragment) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
        if (obj instanceof ICompilationUnit) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
        }
        if (obj instanceof IClassFile) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.classf_obj.gif");
        }
        if (obj instanceof IStorage) {
            if (obj instanceof IJarEntryResource && !((IJarEntryResource)obj).isFile()) {
                return this.folderImage;
            }
            return this.getFileImage(((IStorage)obj).getName());
        }
        return null;
    }

    private String getText(IPluginModelBase model) {
        String text = this.sharedProvider.getText(model);
        if (!model.isEnabled()) {
            text = NLS.bind((String)PDEUIMessages.PluginsView_disabled, (Object)text);
        }
        return text;
    }

    private String getText(FileAdapter file) {
        return file.getFile().getName();
    }

    private Image getImage(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            return this.projectImage;
        }
        if (model instanceof IPluginModel) {
            return this.sharedProvider.getObjectImage((IPlugin)model.getPluginBase(), true, this.isInJavaSearch(model));
        }
        return this.sharedProvider.getObjectImage((IFragment)model.getPluginBase(), true, this.isInJavaSearch(model));
    }

    private boolean isInJavaSearch(IPluginModelBase model) {
        String id = model.getPluginBase().getId();
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        return manager.isInJavaSearch(id);
    }

    private Image getImage(FileAdapter fileAdapter) {
        if (fileAdapter.isDirectory()) {
            return this.folderImage;
        }
        return this.getFileImage(fileAdapter.getFile().getName());
    }

    private Image getFileImage(String fileName) {
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
        return this.sharedProvider.get(desc);
    }
}

