/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.AggregateMappingLabelProvider;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.ILifecycleMappingLabelProvider;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingDiscoveryHelper;
import org.eclipse.m2e.core.ui.internal.wizards.MavenDiscoveryProposalWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.layout.BorderLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingPage
extends WizardPage {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleMappingPage.class);
    private static final String EMPTY_STRING = "";
    private static final int MAVEN_INFO_IDX = 0;
    private static final int ACTION_INFO_IDX = 1;
    private static final int NO_ACTION_IDX = 0;
    private static final int IGNORE_IDX = 1;
    private static final int IGNORE_PARENT_IDX = 2;
    private static final int IGNORE_WSPACE_IDX = 3;
    private LifecycleMappingDiscoveryRequest mappingConfiguration;
    private TreeViewer treeViewer;
    private Button autoSelectButton;
    private boolean loading;
    private Text details;
    private Text license;
    private final Set<ILifecycleMappingLabelProvider> ignore = new HashSet<ILifecycleMappingLabelProvider>();
    private final Set<ILifecycleMappingLabelProvider> ignoreAtDefinition = new HashSet<ILifecycleMappingLabelProvider>();
    private final Set<ILifecycleMappingLabelProvider> ignoreWorkspace = new HashSet<ILifecycleMappingLabelProvider>();

    public LifecycleMappingPage() {
        super("LifecycleMappingPage");
        this.setTitle(Messages.LifecycleMappingPage_title);
        this.setDescription(Messages.LifecycleMappingPage_description);
        this.setPageComplete(true);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)LifecycleMappingPage.class.getResource("/icons/banner_lifecycleMappingPage.png")));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new BorderLayout());
        BorderData tableBorderData = new BorderData(0x1000000);
        tableBorderData.hHint = 300;
        tableBorderData.wHint = 800;
        this.createMappingTree(container).setLayoutData((Object)tableBorderData);
        this.createDescription(container).setLayoutData((Object)new BorderData(1024));
    }

    private Control createDescription(Composite parent) {
        final ExpandBar bar = new ExpandBar(parent, 0);
        Composite container = new Composite((Composite)bar, 0);
        container.setLayout((Layout)new BorderLayout());
        this.details = new Text(container, 584);
        this.details.setLayoutData((Object)new BorderData(0x1000000));
        Composite licenseContainer = new Composite(container, 0);
        new Label(licenseContainer, 0).setText(Messages.LifecycleMappingPage_licenseLabel);
        this.license = new Text(licenseContainer, 8);
        this.license.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        licenseContainer.setLayout((Layout)new GridLayout(2, false));
        licenseContainer.setLayoutData((Object)new BorderData(1024));
        ExpandItem expandItem = new ExpandItem(bar, 0, 0);
        expandItem.setText(Messages.LifecycleMappingPage_descriptionLabel);
        expandItem.setHeight(120);
        expandItem.setControl((Control)container);
        expandItem.setExpanded(true);
        bar.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                this.itemCollapsed(e);
            }

            public void itemCollapsed(ExpandEvent e) {
                bar.requestLayout();
            }
        });
        return bar;
    }

    private Composite createMappingTree(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new BorderLayout());
        Composite treeViewerContainer = new Composite(container, 0);
        treeViewerContainer.setLayoutData((Object)new BorderData(0x1000000));
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        treeViewerContainer.setLayout((Layout)treeColumnLayout);
        this.treeViewer = new TreeViewer(treeViewerContainer, 67584);
        Tree tree = this.treeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn.getColumn();
        trclmnNewColumn.setText(Messages.LifecycleMappingPage_mavenBuildColumnTitle);
        treeColumnLayout.setColumnData((Widget)trclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(65, 150, true));
        TreeViewerColumn columnViewerAction = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn columnAction = columnViewerAction.getColumn();
        treeColumnLayout.setColumnData((Widget)columnAction, (ColumnLayoutData)new ColumnWeightData(35, true));
        columnAction.setText(Messages.LifecycleMappingPage_actionColumnTitle);
        columnViewerAction.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof ILifecycleMappingLabelProvider) {
                    ILifecycleMappingLabelProvider prov = (ILifecycleMappingLabelProvider)element;
                    int intVal = (Integer)value;
                    List all = LifecycleMappingPage.this.mappingConfiguration.getProposals(prov.getKey());
                    if (LifecycleMappingPage.this.ignore.contains(element)) {
                        LifecycleMappingPage.this.ignore.remove(element);
                    } else if (LifecycleMappingPage.this.ignoreAtDefinition.contains(element)) {
                        LifecycleMappingPage.this.ignoreAtDefinition.remove(element);
                    } else if (LifecycleMappingPage.this.ignoreWorkspace.contains(element)) {
                        LifecycleMappingPage.this.ignoreWorkspace.remove(element);
                    } else if (intVal >= all.size() + 0 || LifecycleMappingPage.this.shouldDeslectProposal(prov)) {
                        IMavenDiscoveryProposal prop = LifecycleMappingPage.this.mappingConfiguration.getSelectedProposal(prov.getKey());
                        LifecycleMappingPage.this.mappingConfiguration.removeSelectedProposal(prop);
                    }
                    if (intVal < all.size()) {
                        IMavenDiscoveryProposal sel = (IMavenDiscoveryProposal)all.get(intVal);
                        if (sel != null) {
                            LifecycleMappingPage.this.mappingConfiguration.addSelectedProposal(sel);
                        }
                    } else {
                        switch (intVal - all.size()) {
                            case 1: {
                                LifecycleMappingPage.this.ignore.add(prov);
                                break;
                            }
                            case 2: {
                                LifecycleMappingPage.this.ignoreAtDefinition.add(prov);
                                break;
                            }
                            case 3: {
                                LifecycleMappingPage.this.ignoreWorkspace.add(prov);
                            }
                        }
                    }
                    this.getViewer().refresh(true);
                    LifecycleMappingPage.this.getContainer().updateButtons();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ILifecycleMappingLabelProvider) {
                    ILifecycleMappingLabelProvider prov = (ILifecycleMappingLabelProvider)element;
                    IMavenDiscoveryProposal prop = LifecycleMappingPage.this.mappingConfiguration.getSelectedProposal(prov.getKey());
                    List all = LifecycleMappingPage.this.mappingConfiguration.getProposals(prov.getKey());
                    if (LifecycleMappingPage.this.ignore.contains(element)) {
                        return all.size() + 1;
                    }
                    if (LifecycleMappingPage.this.ignoreAtDefinition.contains(element)) {
                        return all.size() + 2;
                    }
                    if (LifecycleMappingPage.this.ignoreWorkspace.contains(element)) {
                        return all.size() + 3;
                    }
                    int index = all.indexOf(prop);
                    return index >= 0 ? Integer.valueOf(index) : Integer.valueOf(all.size() + 0);
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof ILifecycleMappingLabelProvider) {
                    ILifecycleMappingLabelProvider prov = (ILifecycleMappingLabelProvider)element;
                    List all = LifecycleMappingPage.this.mappingConfiguration.getProposals(prov.getKey());
                    ArrayList<String> values = new ArrayList<String>();
                    for (IMavenDiscoveryProposal prop : all) {
                        values.add(NLS.bind((String)Messages.LifecycleMappingPage_installDescription, (Object)prop.toString()));
                    }
                    values.add(Messages.LifecycleMappingPage_useDefaultMapping);
                    LifecycleMappingPage.this.addIgnoreProposals(values, prov);
                    ComboBoxCellEditor edit = new ComboBoxCellEditor((Composite)LifecycleMappingPage.this.treeViewer.getTree(), values.toArray(new String[values.size()]));
                    edit.setActivationStyle(3);
                    Control cont = edit.getControl();
                    if (cont instanceof CCombo) {
                        CCombo combo = (CCombo)cont;
                        combo.setEditable(false);
                    }
                    return edit;
                }
                throw new IllegalStateException();
            }

            protected boolean canEdit(Object element) {
                if (element instanceof AggregateMappingLabelProvider) {
                    AggregateMappingLabelProvider prov = (AggregateMappingLabelProvider)element;
                    List all = LifecycleMappingPage.this.mappingConfiguration.getProposals(prov.getKey());
                    return all != null && !all.isEmpty() || prov.getKey() instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement;
                }
                return false;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof LifecycleMappingDiscoveryRequest) {
                    LifecycleMappingDiscoveryRequest request = (LifecycleMappingDiscoveryRequest)inputElement;
                    HashMap<ILifecycleMappingRequirement, List> packagings = new HashMap<ILifecycleMappingRequirement, List>();
                    HashMap<ILifecycleMappingRequirement, List> mojos = new HashMap<ILifecycleMappingRequirement, List>();
                    request.getProjects().forEach((facade, requirements) -> {
                        final String relPath = facade.getProject().getFile("pom.xml").getFullPath().toPortableString();
                        for (final ILifecycleMappingRequirement requirement : requirements) {
                            if (requirement == null) continue;
                            List val = mojos.computeIfAbsent(requirement, r -> new ArrayList());
                            val.add(new ILifecycleMappingLabelProvider((IMavenProjectFacade)facade){
                                private final /* synthetic */ IMavenProjectFacade val$facade;
                                {
                                    this.val$facade = iMavenProjectFacade;
                                }

                                @Override
                                public String getMavenText() {
                                    String executionId = null;
                                    if (requirement instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) {
                                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement mojo = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)requirement;
                                        executionId = mojo.getExecutionId();
                                    } else if (requirement instanceof MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement) {
                                        MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement conf = (MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement)requirement;
                                        executionId = conf.execution().executionId();
                                    }
                                    if (executionId != null) {
                                        if ("default".equals(executionId)) {
                                            return NLS.bind((String)"{0}", (Object)relPath);
                                        }
                                        return NLS.bind((String)"Execution {0}, in {1}", (Object)executionId, (Object)relPath);
                                    }
                                    return null;
                                }

                                @Override
                                public boolean isError(LifecycleMappingDiscoveryRequest mappingConfiguration) {
                                    return !mappingConfiguration.isRequirementSatisfied(this.getKey());
                                }

                                @Override
                                public ILifecycleMappingRequirement getKey() {
                                    return requirement;
                                }

                                @Override
                                public Collection<MavenProject> getProjects() {
                                    try {
                                        MavenProject mavenProject = this.val$facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                                        return Collections.singleton(mavenProject);
                                    }
                                    catch (CoreException e) {
                                        LOG.error(e.getMessage(), (Throwable)e);
                                        throw new RuntimeException(e.getMessage(), e);
                                    }
                                }
                            });
                        }
                    });
                    ArrayList toRet = new ArrayList();
                    packagings.forEach((req, providers) -> {
                        boolean bl = toRet.add(new AggregateMappingLabelProvider((ILifecycleMappingRequirement)req, (List<ILifecycleMappingLabelProvider>)providers));
                    });
                    mojos.forEach((req, providers) -> {
                        boolean bl = toRet.add(new AggregateMappingLabelProvider((ILifecycleMappingRequirement)req, (List<ILifecycleMappingLabelProvider>)providers));
                    });
                    return toRet.toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AggregateMappingLabelProvider) {
                    AggregateMappingLabelProvider prov = (AggregateMappingLabelProvider)parentElement;
                    return prov.getChildren();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                Object[] children = this.getChildren(element);
                return children != null && children.length > 0;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ILifecycleMappingLabelProvider) {
                    ILifecycleMappingLabelProvider prov = (ILifecycleMappingLabelProvider)element;
                    if (columnIndex == 0) {
                        return prov.getMavenText();
                    }
                    if (columnIndex == 1 && element instanceof AggregateMappingLabelProvider) {
                        IMavenDiscoveryProposal proposal = LifecycleMappingPage.this.mappingConfiguration.getSelectedProposal(prov.getKey());
                        if (LifecycleMappingPage.this.ignore.contains(element)) {
                            return Messages.LifecycleMappingPage_doNotExecutePom;
                        }
                        if (LifecycleMappingPage.this.ignoreAtDefinition.contains(element)) {
                            return Messages.LifecycleMappingPage_doNotExecuteParent;
                        }
                        if (LifecycleMappingPage.this.ignoreWorkspace.contains(element)) {
                            return Messages.LifecycleMappingPage_doNotExecuteWorkspace;
                        }
                        if (proposal != null) {
                            return NLS.bind((String)Messages.LifecycleMappingPage_installDescription, (Object)proposal.toString());
                        }
                        if (LifecycleMappingPage.this.loading || !prov.isError(LifecycleMappingPage.this.mappingConfiguration)) {
                            return LifecycleMappingPage.EMPTY_STRING;
                        }
                        return Messages.LifecycleMappingPage_useDefaultMapping;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex != 0) {
                    return null;
                }
                if (element instanceof AggregateMappingLabelProvider) {
                    AggregateMappingLabelProvider prov = (AggregateMappingLabelProvider)element;
                    if (prov.isError(LifecycleMappingPage.this.mappingConfiguration) && !LifecycleMappingPage.this.isHandled(prov)) {
                        return MavenImages.IMG_INFO_AUTO;
                    }
                    return MavenImages.IMG_PASSED;
                }
                return MavenImages.IMG_POM;
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            IStructuredSelection structuredSelection;
            ISelection iSelection = event.getSelection();
            if (iSelection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)iSelection).size() == 1) {
                ILifecycleMappingLabelProvider prov = (ILifecycleMappingLabelProvider)structuredSelection.getFirstElement();
                if (this.ignore.contains(prov)) {
                    this.details.setText(Messages.LifecycleMappingPage_doNotExecutePomDescription);
                    this.license.setText(EMPTY_STRING);
                } else if (this.ignoreAtDefinition.contains(prov)) {
                    this.details.setText(Messages.LifecycleMappingPage_doNotExecuteParentDescription);
                    this.license.setText(EMPTY_STRING);
                } else if (this.ignoreWorkspace.contains(prov)) {
                    this.details.setText(Messages.LifecycleMappingPage_doNotExecuteWorkspaceDescription);
                    this.license.setText(EMPTY_STRING);
                } else {
                    IMavenDiscoveryProposal proposal = this.mappingConfiguration.getSelectedProposal(prov.getKey());
                    this.details.setText(proposal != null ? proposal.getDescription() : (this.mappingConfiguration.getProposals(prov.getKey()).isEmpty() ? NLS.bind((String)Messages.LifecycleMappingPage_noMarketplaceEntryDescription, (Object)prov.getMavenText()) : EMPTY_STRING));
                    this.license.setText(proposal == null ? EMPTY_STRING : proposal.getLicense());
                }
            } else {
                this.resetDetails();
            }
        });
        this.treeViewer.setComparator(new ViewerComparator(){
            Comparator<ILifecycleMappingLabelProvider> providerComparator = Comparator.comparing(ILifecycleMappingLabelProvider::getMavenText);

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ILifecycleMappingLabelProvider) {
                    ILifecycleMappingLabelProvider p1 = (ILifecycleMappingLabelProvider)e1;
                    if (e2 instanceof ILifecycleMappingLabelProvider) {
                        ILifecycleMappingLabelProvider p2 = (ILifecycleMappingLabelProvider)e2;
                        return this.providerComparator.compare(p1, p2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new BorderData(1024));
        buttons.setLayout((Layout)new GridLayout(3, false));
        new Label(buttons, 0).setLayoutData((Object)new GridData(768));
        Button btnNewButton_1 = new Button(buttons, 0);
        btnNewButton_1.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.mappingConfiguration.clearSelectedProposals();
            this.ignore.clear();
            this.ignoreAtDefinition.clear();
            this.ignoreWorkspace.clear();
            this.treeViewer.refresh();
            this.getWizard().getContainer().updateButtons();
        }));
        btnNewButton_1.setText(Messages.LifecycleMappingPage_deselectAllButton);
        this.autoSelectButton = new Button(buttons, 0);
        this.autoSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.resetDetails();
            this.ignore.clear();
            this.ignoreAtDefinition.clear();
            this.ignoreWorkspace.clear();
            this.discoverProposals();
        }));
        this.autoSelectButton.setText(Messages.LifecycleMappingPage_autoSelectButton);
        return container;
    }

    protected boolean shouldDeslectProposal(ILifecycleMappingLabelProvider prov) {
        IMavenDiscoveryProposal proposal = this.mappingConfiguration.getSelectedProposal(prov.getKey());
        if (proposal != null) {
            return Arrays.stream(this.treeViewer.getTree().getItems()).noneMatch(item -> {
                Object object = item.getData();
                if (!(object instanceof ILifecycleMappingLabelProvider)) return false;
                ILifecycleMappingLabelProvider itemProvider = (ILifecycleMappingLabelProvider)object;
                if (item.getData() == prov) return false;
                if (!proposal.equals(this.mappingConfiguration.getSelectedProposal(itemProvider.getKey()))) return false;
                return true;
            });
        }
        return true;
    }

    protected void discoverProposals() {
        this.loading = true;
        this.treeViewer.refresh();
        try {
            this.getContainer().run(true, true, monitor -> {
                this.mappingConfiguration.clearSelectedProposals();
                try {
                    LifecycleMappingDiscoveryHelper.discoverProposals(this.mappingConfiguration, monitor);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
                this.mappingConfiguration.autoCompleteMapping();
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
        }
        this.loading = false;
        this.treeViewer.refresh();
        this.getWizard().getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getWizard().getContainer().getShell(), "org.eclipse.m2e.core.ui.LifecycleMappingPage");
            this.mappingConfiguration = ((MavenDiscoveryProposalWizard)this.getWizard()).getLifecycleMappingDiscoveryRequest();
            if (!this.mappingConfiguration.isMappingComplete()) {
                this.mappingConfiguration.autoCompleteMapping();
            }
            this.treeViewer.setInput((Object)this.mappingConfiguration);
        }
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public List<IMavenDiscoveryProposal> getSelectedDiscoveryProposals() {
        if (this.mappingConfiguration == null) {
            return Collections.emptyList();
        }
        return this.mappingConfiguration.getSelectedProposals();
    }

    private void addIgnoreProposals(List<String> values, ILifecycleMappingLabelProvider provider) {
        if (provider.getKey() instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) {
            values.add(Messages.LifecycleMappingPage_doNotExecutePom);
            values.add(Messages.LifecycleMappingPage_doNotExecuteParent);
            values.add(Messages.LifecycleMappingPage_doNotExecuteWorkspace);
        }
    }

    public Collection<ILifecycleMappingLabelProvider> getIgnore() {
        return this.ignore;
    }

    public Collection<ILifecycleMappingLabelProvider> getIgnoreParent() {
        return this.ignoreAtDefinition;
    }

    public Collection<ILifecycleMappingLabelProvider> getIgnoreWorkspace() {
        return this.ignoreWorkspace;
    }

    private boolean isHandled(ILifecycleMappingLabelProvider prov) {
        return this.ignore.contains(prov) || this.ignoreAtDefinition.contains(prov) || this.ignoreWorkspace.contains(prov) || this.mappingConfiguration.getSelectedProposal(prov.getKey()) != null || !prov.isError(this.mappingConfiguration);
    }

    private void resetDetails() {
        if (this.details != null) {
            this.details.setText(EMPTY_STRING);
        }
        if (this.license != null) {
            this.license.setText(EMPTY_STRING);
        }
    }
}

