/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceTimestampMappings {
    private static final IPath COMPONENT_MANIFEST_PATH = new Path(".settings/org.eclipse.wst.common.component");
    private static final IPath FACET_CONFIG_PATH = new Path(".settings/org.eclipse.wst.common.project.facet.core.xml");
    private static final Object NO_DATA = new Object();
    private static final Object ERROR = new Object();
    private final Map timestamps = new HashMap();
    private final Map data = new HashMap();

    public synchronized boolean mark(IResource resource) {
        return this.mark(resource, NO_DATA);
    }

    public synchronized boolean mark(IResource resource, Object cachedData) {
        if (resource.getModificationStamp() != -1L) {
            if (this.timestamps.containsKey(resource)) {
                TimestampSignature signature = (TimestampSignature)this.timestamps.get(resource);
                signature.update(resource);
            } else {
                this.timestamps.put(resource, this.createTimestampSignature(resource));
            }
            this.data.put(resource, cachedData);
            return true;
        }
        return false;
    }

    public synchronized boolean markError(IResource resource) {
        if (resource.getModificationStamp() != -1L) {
            if (this.timestamps.containsKey(resource)) {
                TimestampSignature signature = (TimestampSignature)this.timestamps.get(resource);
                signature.update(resource);
            } else {
                this.timestamps.put(resource, this.createTimestampSignature(resource));
            }
            this.data.put(resource, ERROR);
            return true;
        }
        return false;
    }

    public boolean hasChanged(IResource resource) {
        TimestampSignature signature = (TimestampSignature)this.timestamps.get(resource);
        return signature == null || signature.hasChanged(resource);
    }

    public boolean hasCacheData(IResource resource) {
        Object datum = this.data.get(resource);
        return datum != null && datum != NO_DATA;
    }

    public boolean hasCacheError(IResource resource) {
        return this.data.get(resource) == ERROR;
    }

    public Object getData(IResource resource) {
        Object datum = this.data.get(resource);
        if (datum != NO_DATA) {
            return datum;
        }
        return null;
    }

    private TimestampSignature createTimestampSignature(IResource resource) {
        switch (resource.getType()) {
            case 4: {
                return new ProjectTimestamp((IProject)resource);
            }
        }
        return new SimpleResourceTimestamp(resource);
    }

    public class ProjectTimestamp
    implements TimestampSignature {
        private long projectTimestamp = 0L;
        private long componentManifestTimestamp = 0L;
        private long facetConfigTimestamp = 0L;

        public ProjectTimestamp(IProject project) {
            this.update((IResource)project);
        }

        @Override
        public boolean hasChanged(IResource resource) {
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                if (this.projectTimestamp != project.getModificationStamp()) {
                    return true;
                }
                IFile file = project.getFile(COMPONENT_MANIFEST_PATH);
                if (!file.exists() || this.componentManifestTimestamp != file.getModificationStamp()) {
                    return true;
                }
                file = project.getFile(FACET_CONFIG_PATH);
                return !file.exists() || this.facetConfigTimestamp != file.getModificationStamp();
            }
            return true;
        }

        @Override
        public void update(IResource resource) {
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                this.projectTimestamp = project.getModificationStamp();
                IFile file = project.getFile(COMPONENT_MANIFEST_PATH);
                this.componentManifestTimestamp = file.getModificationStamp();
                file = project.getFile(FACET_CONFIG_PATH);
                this.facetConfigTimestamp = file.getModificationStamp();
            } else {
                this.facetConfigTimestamp = -1L;
                this.componentManifestTimestamp = -1L;
                this.projectTimestamp = -1L;
            }
        }
    }

    public class SimpleResourceTimestamp
    implements TimestampSignature {
        private long timestamp = 0L;

        public SimpleResourceTimestamp(IResource resource) {
            this.update(resource);
        }

        @Override
        public boolean hasChanged(IResource resource) {
            return this.timestamp != resource.getModificationStamp();
        }

        @Override
        public void update(IResource resource) {
            this.timestamp = resource.getModificationStamp();
        }
    }

    public static interface TimestampSignature {
        public boolean hasChanged(IResource var1);

        public void update(IResource var1);
    }
}

