/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class ResourceURIConverter {
    @Inject(optional=true)
    private IWorkspace workspace;

    public URI toURI(IResource file) {
        return this.toURI(file.getFullPath());
    }

    public URI toURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public IFile toFile(URI uri) {
        IWorkspaceRoot root = this.workspace.getRoot();
        return root.getFile((IPath)new Path(uri.toPlatformString(true)));
    }

    public IFolder toFolder(URI uri) {
        IWorkspaceRoot root = this.workspace.getRoot();
        return root.getFolder((IPath)new Path(uri.toPlatformString(true)));
    }
}

