/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.mylyn.wikitext.confluence.internal.util.Colors;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.AbstractMarkupDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.EntityReferences;

public class ConfluenceDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final String NEWLINE_REGEX = "(?:\r\n|\r|\n)";
    private static final Pattern PATTERN_MULTIPLE_NEWLINES = Pattern.compile("((?:\r\n|\r|\n)(?:\\s+(?:\r\n|\r|\n)|(?:\r\n|\r|\n))+)");
    private static final CharMatcher SPAN_MARKUP_CHARACTERS = CharMatcher.anyOf((CharSequence)"*_+-^~{}[]?%@");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();

    public ConfluenceDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("nbsp", " ");
        this.entityToLiteral.put("#160", " ");
        this.entityToLiteral.put("quot", "\"");
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.entityToLiteral.put("copy", "(c)");
        this.entityToLiteral.put("reg", "(r)");
        this.entityToLiteral.put("#8482", "(t)");
        this.entityToLiteral.put("euro", "\u20ac");
        this.entityToLiteral.put("#36", "$");
        this.entityToLiteral.put("#37", "%");
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case NUMERIC_LIST: 
            case BULLETED_LIST: 
            case DEFINITION_LIST: {
                return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, this.doubleNewlineDelimiterCount(), 1);
            }
            case CODE: {
                return new ContentBlock(type, "{code}", "{code}\n\n", false, false, 2, 2, false, false, false);
            }
            case LIST_ITEM: 
            case DEFINITION_TERM: 
            case DEFINITION_ITEM: {
                char prefixChar = this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST ? (char)'#' : '*';
                return new ContentBlock(type, this.computePrefix(prefixChar, this.computeListLevel()) + " ", "", false, true, 1, 1, true, true, true);
            }
            case DIV: {
                if (this.currentBlock == null) {
                    return new ContentBlock(type, "", "", false, false, 2, 2);
                }
                return new ContentBlock(type, "", "", true, false, 0, 0);
            }
            case FOOTNOTE: {
                return new ContentBlock(type, "fn1. ", "", false, false, 2, 2);
            }
            case TIP: 
            case WARNING: 
            case INFORMATION: 
            case NOTE: 
            case PANEL: {
                attributes.appendCssClass(type.name().toLowerCase());
            }
            case PARAGRAPH: {
                return new ContentBlock(type, "", "", false, false, this.doubleNewlineDelimiterCount(), this.doubleNewlineDelimiterCount());
            }
            case PREFORMATTED: {
                return new ContentBlock(type, "{noformat}", "{noformat}", false, false, this.doubleNewlineDelimiterCount(), this.doubleNewlineDelimiterCount(), false, false, false);
            }
            case QUOTE: {
                return new ContentBlock(type, "{quote}", "{quote}", false, false, this.doubleNewlineDelimiterCount(), this.doubleNewlineDelimiterCount());
            }
            case TABLE: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new TableCellBlock(type);
            }
            case TABLE_ROW: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "|\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + String.valueOf(type));
        return new ContentBlock(type, "", "", false, false, 0, 0);
    }

    private int doubleNewlineDelimiterCount() {
        DocumentBuilder.BlockType currentBlockType;
        if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_TERM || currentBlockType == DocumentBuilder.BlockType.BULLETED_LIST || currentBlockType == DocumentBuilder.BlockType.NUMERIC_LIST || currentBlockType == DocumentBuilder.BlockType.DEFINITION_LIST)) {
            return 1;
        }
        return 2;
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        ContentBlock block;
        switch (type) {
            case BOLD: {
                block = new ContentBlock("*", "*", true, false, 0, 0);
                break;
            }
            case CITATION: {
                block = new ContentBlock("??", "??", true, false, 0, 0);
                break;
            }
            case DELETED: {
                block = new ContentBlock("-", "-", true, false, 0, 0);
                break;
            }
            case EMPHASIS: 
            case ITALIC: 
            case MARK: {
                block = new ContentBlock("_", "_", true, false, 0, 0);
                break;
            }
            case INSERTED: {
                block = new ContentBlock("+", "+", true, false, 0, 0);
                break;
            }
            case CODE: {
                block = new ContentBlock("@", "@", true, false, 0, 0);
                break;
            }
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    block = new LinkBlock((LinkAttributes)attributes);
                    break;
                }
                block = new ContentBlock("%", "%", true, true, 0, 0);
                break;
            }
            case MONOSPACE: {
                block = new ContentBlock("{{", "}}", true, false, 0, 0);
                break;
            }
            case STRONG: {
                block = new ContentBlock("*", "*", true, false, 0, 0);
                break;
            }
            case SUPERSCRIPT: {
                block = new ContentBlock("^", "^", true, false, 0, 0);
                break;
            }
            case SUBSCRIPT: {
                block = new ContentBlock("~", "~", true, false, 0, 0);
                break;
            }
            case UNDERLINED: {
                block = new ContentBlock("+", "+", true, false, 0, 0);
                break;
            }
            default: {
                Matcher colorMatcher;
                block = null;
                if (attributes.getCssStyle() != null && (colorMatcher = Pattern.compile("color:\\s*([^;\\t]+)").matcher(attributes.getCssStyle())).find()) {
                    String color = Colors.asHex(colorMatcher.group(1));
                    if (color.equalsIgnoreCase("black") || color.equals("#010101")) {
                        color = null;
                    }
                    if (color != null) {
                        block = new ContentBlock("{color:" + color + "}", "{color}", true, false, 0, 0);
                    }
                }
                if (block != null) break;
                block = new ContentBlock("", "", false, false, 0, 0);
            }
        }
        return block;
    }

    protected boolean isSeparator(int i) {
        return !this.isSpanMarkup((char)i) && (super.isSeparator(i) || this.isEscapeCharacter(i));
    }

    private boolean isEscapeCharacter(int i) {
        return (char)i == '\\';
    }

    private boolean isSpanMarkup(char character) {
        return SPAN_MARKUP_CHARACTERS.matches(character);
    }

    protected ContentBlock computeHeading(int level, Attributes attributes) {
        return new ContentBlock("h" + level + ". ", "", false, false, 2, 2);
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            int x = 0;
            while (x < text.length()) {
                char c = text.charAt(x);
                switch (c) {
                    case '\u00a0': {
                        this.currentBlock.write(32);
                        break;
                    }
                    case '\u00a9': {
                        this.currentBlock.write("(c)");
                        break;
                    }
                    case '\u00ae': {
                        this.currentBlock.write("(r)");
                        break;
                    }
                    default: {
                        this.currentBlock.write((int)c);
                    }
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        Object literal = this.entityToLiteral.get(entity);
        if (literal == null && (literal = EntityReferences.instance().equivalentString(entity)) == null) {
            literal = "&" + entity + ";";
        }
        try {
            super.emitContent((String)literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        if (url != null) {
            this.assertOpenBlock();
            try {
                super.emitContent(33);
                this.currentBlock.write(url);
                this.writeImageAttributes(attributes);
                super.emitContent(33);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttributes = new LinkAttributes();
        linkAttributes.setTitle(attributes.getTitle());
        linkAttributes.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttributes);
        this.characters(text);
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.assertOpenBlock();
        try {
            super.emitContent(33);
            this.currentBlock.write(imageUrl);
            this.writeImageAttributes(imageAttributes);
            super.emitContent(33);
            super.emitContent(58);
            this.currentBlock.write(href);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
            this.currentBlock.write(40);
            this.currentBlock.write(definition);
            this.currentBlock.write(41);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof ConfluenceBlock) {
                ((ConfluenceBlock)this.currentBlock).writeLineBreak();
            } else {
                this.currentBlock.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void emitEscapedContent(String s) throws IOException {
        int x = 0;
        while (x < s.length()) {
            this.emitEscapedContent(s.charAt(x));
            ++x;
        }
    }

    void emitEscapedContent(int c) throws IOException {
        if (c == 92) {
            super.emitContent("&#92;");
        } else {
            this.emitEscapeCharacter(c);
            super.emitContent(c);
        }
    }

    void emitEscapeCharacter(int c) throws IOException {
        if (c == 35 && this.getLastChar() == '&' || c == 123 || c == 92 || c == 91 || c == 93 || c == 33 || c == 124) {
            if (this.getLastChar() == '\\') {
                super.emitContent(32);
            }
            super.emitContent(92);
        }
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private void writeImageAttributes(Attributes attributes) throws IOException {
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            Object attributeMarkup = "";
            if (StringUtils.isNotEmpty((CharSequence)imageAttributes.getAlt())) {
                attributeMarkup = "alt=\"" + imageAttributes.getAlt() + "\"";
            }
            if (StringUtils.isNotEmpty((CharSequence)imageAttributes.getTitle())) {
                if (!((String)attributeMarkup).isEmpty()) {
                    attributeMarkup = (String)attributeMarkup + ",";
                }
                attributeMarkup = (String)attributeMarkup + "title=\"" + imageAttributes.getTitle() + "\"";
            }
            if (!((String)attributeMarkup).isEmpty()) {
                super.emitContent(124);
                this.currentBlock.write((String)attributeMarkup);
            }
        }
    }

    private static interface ConfluenceBlock {
        public void writeLineBreak() throws IOException;
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements ConfluenceBlock {
        private final String prefix;
        private final String suffix;
        private final boolean requireAdjacentSeparator;
        private final boolean emitWhenEmpty;
        private int consecutiveLineBreakCount;
        private final boolean escaping;
        private final boolean trimmingNewlinesAndWhitespace;
        private final boolean collapsingConsecutiveNewlines;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, boolean requireAdjacentSeparator, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines) {
            this(blockType, prefix, suffix, requireAdjacentSeparator, emitWhenEmpty, leadingNewlines, trailingNewlines, true, false, false);
        }

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, boolean requireAdjacentSeparator, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines, boolean escaping, boolean trimmingNewlinesAndWhitespace, boolean collapsingConsecutiveNewlines) {
            super((AbstractMarkupDocumentBuilder)ConfluenceDocumentBuilder.this, blockType, leadingNewlines, trailingNewlines);
            this.consecutiveLineBreakCount = 0;
            this.prefix = prefix;
            this.suffix = suffix;
            this.requireAdjacentSeparator = requireAdjacentSeparator;
            this.emitWhenEmpty = emitWhenEmpty;
            this.escaping = escaping;
            this.trimmingNewlinesAndWhitespace = trimmingNewlinesAndWhitespace;
            this.collapsingConsecutiveNewlines = collapsingConsecutiveNewlines;
        }

        ContentBlock(String prefix, String suffix, boolean requireAdjacentWhitespace, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines) {
            this(null, prefix, suffix, requireAdjacentWhitespace, emitWhenEmpty, leadingNewlines, trailingNewlines, true, false, false);
        }

        public void write(int c) throws IOException {
            this.consecutiveLineBreakCount = 0;
            if (!this.isBlockTypePreservingWhitespace()) {
                c = ConfluenceDocumentBuilder.this.normalizeWhitespace(c);
            }
            if (this.escaping) {
                ConfluenceDocumentBuilder.this.emitEscapedContent(c);
            } else {
                ConfluenceDocumentBuilder.this.emitContent(c);
            }
        }

        public void write(String s) throws IOException {
            this.consecutiveLineBreakCount = 0;
            if (!this.isBlockTypePreservingWhitespace()) {
                s = ConfluenceDocumentBuilder.this.normalizeWhitespace(s);
            }
            if (this.escaping) {
                ConfluenceDocumentBuilder.this.emitEscapedContent(s);
            } else {
                ConfluenceDocumentBuilder.this.emitContent(s);
            }
        }

        @Override
        public void writeLineBreak() throws IOException {
            ++this.consecutiveLineBreakCount;
            if (this.isTableCellBlock()) {
                if (this.consecutiveLineBreakCount == 1) {
                    ConfluenceDocumentBuilder.this.emitContent(10);
                } else {
                    ConfluenceDocumentBuilder.this.emitContent("\u00a0\n");
                }
            } else if (this.consecutiveLineBreakCount == 1 || this.isBlockTypePreservingWhitespace()) {
                if (this.isPrefixedBlockTerminatedByNewlines()) {
                    ConfluenceDocumentBuilder.this.emitContent("\\\\");
                } else {
                    ConfluenceDocumentBuilder.this.emitContent(10);
                }
            } else {
                if (ConfluenceDocumentBuilder.this.getLastChar() != '\n') {
                    ConfluenceDocumentBuilder.this.emitContent(32);
                }
                ConfluenceDocumentBuilder.this.emitContent("\\\\");
            }
        }

        public void open() throws IOException {
            super.open();
            ConfluenceDocumentBuilder.this.pushWriter(new StringWriter());
            if (this.requireAdjacentSeparator) {
                ConfluenceDocumentBuilder.this.clearRequireAdjacentSeparator();
            }
            this.emitPrefix();
        }

        public final void close() throws IOException {
            Writer thisContent = ConfluenceDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            boolean contentIsEmpty = content.equals(this.prefix);
            if (!contentIsEmpty || this.emitWhenEmpty) {
                Validate.isTrue((boolean)content.startsWith(this.prefix), (String)"Expected content to start with prefix \"%s\"", (Object[])new Object[]{content, this.prefix});
                content = content.substring(this.prefix.length());
                if (this.requireAdjacentSeparator && !this.isSpanSuffixAdjacentToSpanPrefix()) {
                    ConfluenceDocumentBuilder.this.requireAdjacentSeparator();
                } else {
                    ConfluenceDocumentBuilder.this.clearRequireAdjacentSeparator();
                }
                this.emitPrefix();
                if (this.trimmingNewlinesAndWhitespace) {
                    content = CharMatcher.whitespace().trimFrom((CharSequence)content);
                }
                if (this.collapsingConsecutiveNewlines) {
                    content = PATTERN_MULTIPLE_NEWLINES.matcher(content).replaceAll("\n");
                }
                this.emitContent(content);
                this.emitSuffix(content);
                if (this.requireAdjacentSeparator) {
                    ConfluenceDocumentBuilder.this.requireAdjacentSeparator();
                }
            }
            super.close();
            this.consecutiveLineBreakCount = 0;
        }

        private boolean isSpanSuffixAdjacentToSpanPrefix() {
            return StringUtils.isNotEmpty((CharSequence)this.prefix) && ConfluenceDocumentBuilder.this.isSpanMarkup(ConfluenceDocumentBuilder.this.getLastChar()) && ConfluenceDocumentBuilder.this.isSpanMarkup(this.prefix.charAt(0));
        }

        protected void emitPrefix() throws IOException {
            ConfluenceDocumentBuilder.this.emitContent(this.prefix);
        }

        protected void emitContent(String content) throws IOException {
            ConfluenceDocumentBuilder.this.emitContent(content);
        }

        private void emitSuffix(String content) throws IOException {
            Object suffix = this.isExtended(content) ? this.suffix + "\n" : this.suffix;
            ConfluenceDocumentBuilder.this.emitContent((String)suffix);
        }

        private boolean isExtended(String content) {
            if (this.getBlockType() != null) {
                switch (this.getBlockType()) {
                    case QUOTE: 
                    case CODE: 
                    case PREFORMATTED: {
                        return PATTERN_MULTIPLE_NEWLINES.matcher(content).find();
                    }
                }
            }
            return false;
        }

        private boolean isPrefixedBlockTerminatedByNewlines() {
            return this.suffix.isEmpty() && !this.prefix.isEmpty();
        }

        private boolean isBlockTypePreservingWhitespace() {
            return this.getBlockType() == DocumentBuilder.BlockType.CODE || this.getBlockType() == DocumentBuilder.BlockType.PREFORMATTED;
        }

        private boolean isTableCellBlock() {
            return ConfluenceDocumentBuilder.this.currentBlock instanceof TableCellBlock;
        }
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "", false, false, 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        private LinkBlock(LinkAttributes attributes) {
            super(null, "[", "]", true, true, 0, 0);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (StringUtils.isNotEmpty((CharSequence)content)) {
                super.emitContent(content);
                super.emitContent(" | ");
            }
            if (this.attributes.getHref() != null) {
                super.emitContent(this.attributes.getHref());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.attributes.getTitle())) {
                super.emitContent(" | ");
                super.emitContent(this.attributes.getTitle());
            }
        }
    }

    private class TableCellBlock
    extends ContentBlock {
        public TableCellBlock(DocumentBuilder.BlockType blockType) {
            super(blockType, blockType == DocumentBuilder.BlockType.TABLE_CELL_NORMAL ? "|" : "||", "", false, true, 0, 0, true, true, true);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (StringUtils.isEmpty((CharSequence)content) || content.trim().isEmpty()) {
                content = " ";
            }
            super.emitContent(content);
        }
    }
}

