/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.diagram.elk.ApplyLayoutRequest;
import org.eclipse.sirius.diagram.elk.DiagramElkPlugin;
import org.eclipse.sirius.diagram.elk.IEditPartFilter;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusDescriptionCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusTextEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class ElkDiagramLayoutConnector
implements IDiagramLayoutConnector {
    protected CustomLayoutConfiguration layoutConfiguration;
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("gmf.coordinateOffset");
    public static final IProperty<ElkEdge> SECOND_PART_OF_SPLIT_EDGE = new Property("org.eclipse.sirius.diagram.elk.edge.split");
    public static final String EDGE_ON_EDGE_ID_NODE = "virtualNodeForEdgeToEdgeCase";
    public static final String PREF_EXEC_TIME_MEASUREMENT = "elk.exectime.measure";
    public static final IProperty<Boolean> NODE_SIZE_FIXED_SIZE = new Property("org.eclipse.sirius.diagram.elk.fixedNodeSize", (Object)false, null, null);
    private static final int PRIORITY_SPLIT_EDGE_VALUE = 10;
    private static final int PRIORITY_STRAIGHTNESS_SPLIT_EDGE_VALUE = 10;
    private static final int PRIORITY_DIRECTION_SPLIT_EDGE_VALUE = 10;
    private static final EdgeEditPartComparator CONNECTION_COMPARATOR = new EdgeEditPartComparator();
    @Inject
    private IEditPartFilter editPartFilter;
    @Inject
    private IGraphLayoutEngine graphLayoutEngine;

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public void setLayoutConfiguration(CustomLayoutConfiguration layoutConfiguration) {
        this.layoutConfiguration = layoutConfiguration;
    }

    public static double getShadowBorderSize(EditPart editPart) {
        double shadowBorderSize = 0.0;
        if (editPart instanceof AbstractDiagramElementContainerEditPart && ((AbstractDiagramElementContainerEditPart)editPart).isShadowBorderNeeded()) {
            shadowBorderSize = AlphaDropShadowBorder.getDefaultShadowSize();
        }
        return shadowBorderSize;
    }

    public static KVector getDefaultDimension(AbstractDiagramElementContainerEditPart editPart) {
        Dimension defaultDimension = editPart.getDefaultDimension();
        KVector result = new KVector(defaultDimension.preciseWidth(), defaultDimension.preciseHeight());
        double shadowBorderSize = ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)editPart);
        return result.sub(shadowBorderSize, shadowBorderSize);
    }

    protected DiagramEditor getDiagramEditor(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof DiagramEditor) {
            return (DiagramEditor)workbenchPart;
        }
        return null;
    }

    public LayoutMapping buildLayoutGraph(DiagramEditPart diagramEditPart, Object layoutedPart, boolean isArrangeAll, boolean isArrangeAtOpening) {
        IGraphicalEditPart layoutRootPart = null;
        ArrayList<ShapeNodeEditPart> selectedParts = null;
        if (layoutedPart instanceof ShapeNodeEditPart || layoutedPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)layoutedPart;
        } else if (layoutedPart instanceof IGraphicalEditPart) {
            TopGraphicEditPart tgEditPart = ((IGraphicalEditPart)layoutedPart).getTopGraphicEditPart();
            if (tgEditPart instanceof ShapeNodeEditPart) {
                layoutRootPart = (IGraphicalEditPart)tgEditPart;
            }
        } else if (layoutedPart instanceof Collection) {
            Collection selection = (Collection)layoutedPart;
            for (Object object : selection) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                if (layoutRootPart != null) {
                    EditPart parent = ElkDiagramLayoutConnector.commonParent(layoutRootPart, (IGraphicalEditPart)object);
                    if (parent == null || parent instanceof RootEditPart) continue;
                    layoutRootPart = (IGraphicalEditPart)parent;
                    continue;
                }
                if (object instanceof ConnectionEditPart) continue;
                layoutRootPart = selection.size() == 1 && isArrangeAll ? ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent((IGraphicalEditPart)object) : (IGraphicalEditPart)object;
            }
            if (layoutRootPart != null) {
                selectedParts = new ArrayList<ShapeNodeEditPart>(selection.size());
                for (Object object : selection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart editPart = (IGraphicalEditPart)object;
                    while (editPart != null && ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(editPart) != layoutRootPart) {
                        editPart = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(editPart);
                    }
                    if (!(editPart instanceof ShapeNodeEditPart) || !this.editPartFilter.filter((EditPart)editPart) || selectedParts.contains(editPart)) continue;
                    if (editPart instanceof SiriusNoteEditPart) {
                        if (!new EditPartQuery(editPart).isMovableByAutomaticLayout(Collections.EMPTY_LIST)) continue;
                        selectedParts.add((ShapeNodeEditPart)editPart);
                        continue;
                    }
                    selectedParts.add((ShapeNodeEditPart)editPart);
                }
            }
        }
        if (layoutRootPart == null) {
            layoutRootPart = diagramEditPart;
        }
        LayoutMapping mapping = this.buildLayoutGraph(layoutRootPart, selectedParts, diagramEditPart, isArrangeAll, isArrangeAtOpening);
        return mapping;
    }

    protected static EditPart commonParent(IGraphicalEditPart editPart1, IGraphicalEditPart editPart2) {
        IGraphicalEditPart ep1 = editPart1;
        IGraphicalEditPart ep2 = editPart2;
        do {
            if (ElkDiagramLayoutConnector.isParent((EditPart)ep1, (EditPart)ep2)) {
                return ep1;
            }
            if (ElkDiagramLayoutConnector.isParent((EditPart)ep2, (EditPart)ep1)) {
                return ep2;
            }
            ep1 = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(ep1);
            ep2 = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(ep2);
        } while (ep1 != null && ep2 != null);
        return null;
    }

    private static IGraphicalEditPart getTopGraphicParentEditPartIfPresent(IGraphicalEditPart node) {
        EditPart parentEditPart = node.getParent();
        if (parentEditPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalParentEditPart = (IGraphicalEditPart)parentEditPart;
            TopGraphicEditPart topGraphicEditPart = graphicalParentEditPart.getTopGraphicEditPart();
            return topGraphicEditPart != null ? topGraphicEditPart : graphicalParentEditPart;
        }
        return null;
    }

    protected static boolean isParent(EditPart parent, EditPart child) {
        EditPart editPart = child;
        do {
            if (editPart != parent) continue;
            return true;
        } while ((editPart = editPart.getParent()) != null);
        return false;
    }

    public <E extends Enum<E>> EnumSet<E> of(E e, EnumSet<E> enumSet) {
        enumSet.add(e);
        return enumSet;
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, DiagramEditPart diagramEditPart, boolean isArrangeAll, boolean isArrangeAtOpening) {
        ElkNode topNode;
        LayoutMapping mapping = new LayoutMapping(null);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)diagramEditPart);
        Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOevrrideMap = this.constructElkOptionTargetToOptionsMap();
        ElkNode parentNode = topNode = ElkGraphUtil.createGraph();
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)topNode, elkTargetToOptionsOevrrideMap);
        Point parentLocation = new Point(0, 0);
        if (layoutRootPart instanceof ShapeNodeEditPart) {
            Rectangle childAbsoluteBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)layoutRootPart, (boolean)true);
            IGraphicalEditPart parentEditPart = ElkDiagramLayoutConnector.getTopGraphicParentEditPartIfPresent(layoutRootPart);
            if (parentEditPart != null && !(parentEditPart instanceof DiagramEditPart)) {
                parentLocation = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)parentEditPart).getTopLeft();
            }
            topNode.setLocation(0.0, 0.0);
            topNode.setDimensions(childAbsoluteBounds.preciseX() + childAbsoluteBounds.preciseWidth(), childAbsoluteBounds.preciseY() + childAbsoluteBounds.preciseHeight());
            if (selection.isEmpty()) {
                selection.add((ShapeNodeEditPart)layoutRootPart);
            } else if (isArrangeAtOpening) {
                parentNode = this.createNode(mapping, layoutRootPart, topNode, elkTargetToOptionsOevrrideMap);
                parentNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector(parentNode.getHeight(), parentNode.getWidth()));
            } else {
                if (layoutRootPart == diagramEditPart) {
                    String labelText = diagramEditPart.getDiagramView().getName();
                    if (labelText.length() > 0) {
                        ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                        label.setText(labelText);
                    }
                } else {
                    topNode.setLocation((double)childAbsoluteBounds.x, (double)childAbsoluteBounds.y);
                }
                topNode.setDimensions((double)childAbsoluteBounds.width, (double)childAbsoluteBounds.height);
                mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
                parentNode.setProperty(NODE_SIZE_FIXED_SIZE, (Object)true);
            }
        } else {
            Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
            if (layoutRootPart == diagramEditPart) {
                String labelText = diagramEditPart.getDiagramView().getName();
                if (labelText.length() > 0) {
                    ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                    label.setText(labelText);
                }
            } else {
                topNode.setLocation((double)rootBounds.x, (double)rootBounds.y);
            }
            topNode.setDimensions((double)rootBounds.width, (double)rootBounds.height);
            mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        }
        topNode.setProperty(CoreOptions.ALGORITHM, (Object)this.layoutConfiguration.getId().trim());
        if (((View)diagramEditPart.getModel()).getElement() instanceof DSemanticDiagram) {
            topNode.setIdentifier(((DSemanticDiagram)((View)diagramEditPart.getModel()).getElement()).getName() + "_graph");
        }
        mapping.setLayoutGraph(topNode);
        if (selection != null && !selection.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            for (ShapeNodeEditPart editPart : selection) {
                ElkNode node = this.createNode(mapping, (IGraphicalEditPart)editPart, parentNode, elkTargetToOptionsOevrrideMap);
                minx = Math.min(minx, node.getX());
                miny = Math.min(miny, node.getY());
                boolean childrenLayouted = this.buildLayoutGraphRecursively(mapping, node, (IGraphicalEditPart)editPart, elkTargetToOptionsOevrrideMap);
                if (childrenLayouted || !(editPart instanceof AbstractDiagramElementContainerEditPart)) continue;
                node.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)ElkDiagramLayoutConnector.getDefaultDimension((AbstractDiagramElementContainerEditPart)editPart));
            }
            if (layoutRootPart instanceof ShapeNodeEditPart) {
                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsetsAfterLabel((Node)((Node)layoutRootPart.getNotationView()), (boolean)true);
                if (selection.size() == 1 && selection.get(0).equals(layoutRootPart)) {
                    if (isArrangeAtOpening) {
                        mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x() + (double)topLeftInsets.width, miny - (double)parentLocation.y() + (double)topLeftInsets.height));
                    } else {
                        mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x(), miny - (double)parentLocation.y()));
                    }
                } else if (!isArrangeAtOpening) {
                    mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
                } else {
                    mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(parentNode.getX() - (double)parentLocation.x() - (double)topLeftInsets.width, parentNode.getY() - (double)parentLocation.y() - (double)topLeftInsets.height));
                }
            } else if (isArrangeAll || isArrangeAtOpening) {
                mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(20.0, 20.0));
            } else {
                mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx - (double)parentLocation.x(), miny - (double)parentLocation.y()));
            }
        } else {
            this.buildLayoutGraphRecursively(mapping, topNode, layoutRootPart, elkTargetToOptionsOevrrideMap);
        }
        this.processConnections(mapping, elkTargetToOptionsOevrrideMap);
        return mapping;
    }

    private Map<LayoutOptionTarget, Set<LayoutOption>> constructElkOptionTargetToOptionsMap() {
        HashMap<LayoutOptionTarget, Set<LayoutOption>> resultMap = new HashMap<LayoutOptionTarget, Set<LayoutOption>>();
        resultMap.put(LayoutOptionTarget.EDGE, new HashSet());
        resultMap.put(LayoutOptionTarget.LABEL, new HashSet());
        resultMap.put(LayoutOptionTarget.NODE, new HashSet());
        resultMap.put(LayoutOptionTarget.PARENT, new HashSet());
        resultMap.put(LayoutOptionTarget.PORTS, new HashSet());
        if (this.layoutConfiguration != null) {
            EList layoutOptions = this.layoutConfiguration.getLayoutOptions();
            for (LayoutOption layoutOption : layoutOptions) {
                EList targets = layoutOption.getTargets();
                for (LayoutOptionTarget layoutOptionTarget : targets) {
                    Set optionsSet = (Set)resultMap.get(layoutOptionTarget);
                    optionsSet.add(layoutOption);
                }
            }
        }
        return resultMap;
    }

    private void applyOptionsRelatedToElementTarget(ElkGraphElement elkElement, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        if (this.layoutConfiguration != null) {
            if (elkElement instanceof ElkNode) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.NODE);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkLabel) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.LABEL);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkPort) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.PORTS);
                this.applyOptions(elkElement, layoutOptionsSet);
            } else if (elkElement instanceof ElkEdge) {
                Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.EDGE);
                this.applyOptions(elkElement, layoutOptionsSet);
            }
        }
    }

    private void applyParentNodeOption(ElkGraphElement elkElement, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        Set<LayoutOption> layoutOptionsSet = elkTargetToOptionsOverrideMap.get(LayoutOptionTarget.PARENT);
        this.applyOptions(elkElement, layoutOptionsSet);
    }

    private void applyOptions(ElkGraphElement elkElement, Set<LayoutOption> layoutOptionsSet) {
        for (LayoutOption layoutOption : layoutOptionsSet) {
            LayoutOptionData layoutProperty = LayoutMetaDataService.getInstance().getOptionData(layoutOption.getId());
            switch (layoutOption.eClass().getClassifierID()) {
                case 24: {
                    EnumLayoutOption enumOption = (EnumLayoutOption)layoutOption;
                    int enumValueCount = layoutProperty.getEnumValueCount();
                    Enum elkEnum = null;
                    int i = 0;
                    while (i < enumValueCount && elkEnum == null) {
                        layoutProperty.getEnumValue(i);
                        Enum enumValue = layoutProperty.getEnumValue(i);
                        if (enumOption.getValue().getName().equals(enumValue.name())) {
                            elkEnum = enumValue;
                        }
                        ++i;
                    }
                    elkElement.setProperty((IProperty)layoutProperty, elkEnum);
                    break;
                }
                case 25: {
                    int i;
                    EnumSetLayoutOption enumSetOption = (EnumSetLayoutOption)layoutOption;
                    int enumValueCount = layoutProperty.getEnumValueCount();
                    if (enumValueCount <= 0) break;
                    EnumSet<Object> enumSet = EnumSet.noneOf(layoutProperty.getEnumValue(0).getDeclaringClass());
                    EList values = enumSetOption.getValues();
                    block10: for (EnumLayoutValue enumLayoutValue : values) {
                        i = 0;
                        while (i < enumValueCount) {
                            Enum enumValue = layoutProperty.getEnumValue(i);
                            if (enumLayoutValue.getName().equals(enumValue.name())) {
                                enumSet = this.of(enumValue, enumSet);
                                continue block10;
                            }
                            ++i;
                        }
                    }
                    elkElement.setProperty((IProperty)layoutProperty, enumSet);
                    break;
                }
                case 20: {
                    BooleanLayoutOption booleanOption = (BooleanLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)booleanOption.isValue());
                    break;
                }
                case 22: {
                    IntegerLayoutOption integerOption = (IntegerLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)integerOption.getValue());
                    break;
                }
                case 23: {
                    DoubleLayoutOption doubleOption = (DoubleLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)doubleOption.getValue());
                    break;
                }
                case 21: {
                    StringLayoutOption stringOption = (StringLayoutOption)layoutOption;
                    elkElement.setProperty((IProperty)layoutProperty, (Object)stringOption.getValue().trim());
                    break;
                }
            }
        }
    }

    public void transferLayout(LayoutMapping mapping, boolean isArrangeAllOrArrangeAtOpeningOnDiagram) {
        DiagramEditPart diagramEditPart;
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            ElkGraphElement graphElement = (ElkGraphElement)entry.getKey();
            IGraphicalEditPart part = (IGraphicalEditPart)entry.getValue();
            if (part instanceof AbstractDNodeListCompartmentEditPart || part instanceof AbstractDNodeContainerCompartmentEditPart || ((Boolean)graphElement.getProperty(NODE_SIZE_FIXED_SIZE)).booleanValue()) continue;
            applyLayoutRequest.addElement(graphElement, part);
        }
        ElkNode layoutGraph = mapping.getLayoutGraph();
        applyLayoutRequest.setUpperBound(layoutGraph.getWidth(), layoutGraph.getHeight());
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            ElkDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
        DiagramElkPlugin.getPlugin().traceForDebug(mapping.getLayoutGraph(), "5_afterAddingOffset");
        if (isArrangeAllOrArrangeAtOpeningOnDiagram) {
            ElkDiagramLayoutConnector.resetOrigin(mapping.getLayoutGraph());
            DiagramElkPlugin.getPlugin().traceForDebug(mapping.getLayoutGraph(), "6_afterResetOrigin");
        }
        if (((InternalTransactionalEditingDomain)(diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART)).getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    public static void resetOrigin(ElkNode parentNode) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
            for (ElkPort port : child.getPorts()) {
                KVector absolutePortLocation = ElkUtil.absolutePosition((ElkGraphElement)port);
                minx = Math.min(minx, absolutePortLocation.x);
                miny = Math.min(miny, absolutePortLocation.y);
                for (ElkLabel label : port.getLabels()) {
                    KVector absoluteLabelLocation = ElkUtil.absolutePosition((ElkGraphElement)label);
                    minx = Math.min(minx, absoluteLabelLocation.x);
                    miny = Math.min(miny, absoluteLabelLocation.y);
                }
            }
        }
        for (ElkEdge edge : parentNode.getContainedEdges()) {
            for (ElkEdgeSection section : edge.getSections()) {
                minx = Math.min(minx, section.getStartX());
                miny = Math.min(miny, section.getStartY());
                for (ElkBendPoint bendPoint : section.getBendPoints()) {
                    minx = Math.min(minx, bendPoint.getX());
                    miny = Math.min(miny, bendPoint.getY());
                }
                minx = Math.min(minx, section.getEndX());
                miny = Math.min(miny, section.getEndY());
            }
            for (ElkLabel label : edge.getLabels()) {
                KVector absoluteLabelLocation = ElkUtil.absolutePosition((ElkGraphElement)label);
                minx = Math.min(minx, absoluteLabelLocation.x);
                miny = Math.min(miny, absoluteLabelLocation.y);
            }
        }
        ElkUtil.translate((ElkNode)parentNode, (double)(20.0 - minx), (double)(20.0 - miny));
    }

    protected static void addOffset(ElkNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((ElkNode)parentNode, (double)offset.x, (double)offset.y);
    }

    public Command getApplyCommand(LayoutMapping mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        return applyLayoutCommand;
    }

    protected boolean buildLayoutGraphRecursively(LayoutMapping mapping, ElkNode parentLayoutNode, IGraphicalEditPart currentEditPart, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        boolean childrenLayouted = false;
        double maxChildShadowBorderSize = -1.0;
        for (Object obj : currentEditPart.getChildren()) {
            ElkLabel newNodeLabel;
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                AbstractBorderItemEditPart borderItem = (AbstractBorderItemEditPart)obj;
                if (this.editPartFilter.filter((EditPart)borderItem)) {
                    this.createPort(mapping, borderItem, currentEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap);
                }
            } else if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (this.editPartFilter.filter((EditPart)compartment)) {
                    boolean compExp = true;
                    IFigure compartmentFigure = compartment.getFigure();
                    if (compartmentFigure instanceof ResizableCompartmentFigure) {
                        ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                        compExp = resizCompFigure.isExpanded();
                    }
                    if (compExp) {
                        ElkNode intermediateNode = parentLayoutNode;
                        if (currentEditPart instanceof IDiagramElementEditPart) {
                            DNodeContainerExperimentalQuery query;
                            IDiagramElementEditPart ideep = (IDiagramElementEditPart)currentEditPart;
                            DDiagramElement dde = ideep.resolveDiagramElement();
                            if (dde instanceof DNodeList || dde instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)dde).isHorizontaltackContainer() || new DNodeContainerExperimentalQuery((DNodeContainer)dde).isVerticalStackContainer()) {
                                childrenLayouted = true;
                                intermediateNode = this.createNode(mapping, (IGraphicalEditPart)compartment, parentLayoutNode, elkTargetToOptionsOverrideMap);
                                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsetsAfterLabel((Node)((Node)compartment.getNotationView()), (boolean)true);
                                Dimension borderSize = GMFHelper.getBorderSize((DDiagramElementContainer)((DDiagramElementContainer)dde));
                                boolean separatorLineHeight = true;
                                ElkPadding padding = dde instanceof DNodeList ? new ElkPadding(topLeftInsets.preciseHeight() + (double)separatorLineHeight, topLeftInsets.preciseWidth(), (double)borderSize.height(), topLeftInsets.preciseWidth()) : new ElkPadding(topLeftInsets.preciseHeight(), borderSize.preciseWidth(), borderSize.preciseHeight(), borderSize.preciseWidth());
                                parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)padding);
                                parentLayoutNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                parentLayoutNode.setProperty(CoreOptions.NODE_LABELS_PADDING, (Object)new ElkPadding());
                                parentLayoutNode.setProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY, (Object)OrderingStrategy.NODES_AND_EDGES);
                                if (dde instanceof DNodeContainer) {
                                    intermediateNode.setProperty(CoreOptions.PADDING, (Object)new ElkPadding(0.0, 0.0, 0.0, 0.0));
                                    intermediateNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                    intermediateNode.setProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY, (Object)OrderingStrategy.NODES_AND_EDGES);
                                }
                                intermediateNode.setProperty(CoreOptions.NODE_LABELS_PADDING, (Object)new ElkPadding());
                            } else if (dde instanceof DNodeContainer && !(query = new DNodeContainerExperimentalQuery((DNodeContainer)dde)).isHorizontaltackContainer() && query.isVerticalStackContainer()) {
                                Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsets((Node)((Node)compartment.getNotationView()), (boolean)true);
                                ElkPadding padding = new ElkPadding(topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth(), topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth());
                                parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)padding);
                                parentLayoutNode.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)0.0);
                                parentLayoutNode.setProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY, (Object)OrderingStrategy.NODES_AND_EDGES);
                            }
                        }
                        childrenLayouted = this.buildLayoutGraphRecursively(mapping, intermediateNode, (IGraphicalEditPart)compartment, elkTargetToOptionsOverrideMap) || childrenLayouted;
                    }
                }
            } else if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (this.editPartFilter.filter((EditPart)childNodeEditPart)) {
                    childrenLayouted = true;
                    ElkNode node = this.createNode(mapping, (IGraphicalEditPart)childNodeEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap);
                    maxChildShadowBorderSize = Math.max(maxChildShadowBorderSize, ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)childNodeEditPart));
                    boolean currentChildrenLayouted = this.buildLayoutGraphRecursively(mapping, node, (IGraphicalEditPart)childNodeEditPart, elkTargetToOptionsOverrideMap);
                    if (!currentChildrenLayouted && childNodeEditPart instanceof AbstractDiagramElementContainerEditPart) {
                        Dimension defaultDimension = ((AbstractDiagramElementContainerEditPart)childNodeEditPart).getDefaultDimension();
                        node.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)defaultDimension.width(), (double)defaultDimension.height()));
                    }
                }
            } else if (obj instanceof IGraphicalEditPart && (newNodeLabel = this.createNodeLabel(mapping, (IGraphicalEditPart)obj, currentEditPart, parentLayoutNode, elkTargetToOptionsOverrideMap)) != null) {
                parentLayoutNode.getLabels().add((Object)newNodeLabel);
            }
            if (!(maxChildShadowBorderSize >= 0.0) || !(currentEditPart.getNotationView() instanceof Node) || currentEditPart instanceof ResizableCompartmentEditPart) continue;
            Dimension topLeftInsets = GMFHelper.getContainerTopLeftInsets((Node)((Node)currentEditPart.getNotationView()), (boolean)true);
            ElkPadding ei = new ElkPadding(topLeftInsets.preciseHeight(), topLeftInsets.preciseWidth() + maxChildShadowBorderSize, topLeftInsets.preciseWidth() + maxChildShadowBorderSize, topLeftInsets.preciseWidth());
            parentLayoutNode.setProperty(CoreOptions.PADDING, (Object)ei);
        }
        return childrenLayouted;
    }

    protected ElkNode createNode(LayoutMapping mapping, IGraphicalEditPart nodeEditPart, ElkNode parentElkNode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        ElkLabel newNodeLabel;
        IFigure nodeFigure = nodeEditPart.getFigure();
        ElkNode newNode = ElkGraphUtil.createNode((ElkNode)parentElkNode);
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)newNode, elkTargetToOptionsOverrideMap);
        Rectangle childAbsoluteBounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)nodeEditPart, (boolean)true);
        KVector containerAbsoluteLocation = new KVector();
        ElkUtil.toAbsolute((KVector)containerAbsoluteLocation, (ElkNode)parentElkNode);
        newNode.setX((double)childAbsoluteBounds.x - containerAbsoluteLocation.x);
        newNode.setY((double)childAbsoluteBounds.y - containerAbsoluteLocation.y);
        double shadowBorderSize = ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)nodeEditPart);
        newNode.setDimensions((double)childAbsoluteBounds.width - shadowBorderSize, (double)childAbsoluteBounds.height - shadowBorderSize);
        if (nodeEditPart instanceof AbstractDNodeListCompartmentEditPart || nodeEditPart instanceof AbstractDNodeContainerCompartmentEditPart) {
            newNode.setIdentifier("Compartment");
        } else if (((View)nodeEditPart.getModel()).getElement() instanceof DDiagramElement) {
            newNode.setIdentifier(((DDiagramElement)((View)nodeEditPart.getModel()).getElement()).getName());
        }
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            newNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)minSize.width, (double)minSize.height));
        }
        catch (SWTException sWTException) {}
        if (nodeEditPart instanceof SiriusNoteEditPart || nodeEditPart instanceof SiriusTextEditPart) {
            newNode.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
        }
        if (parentElkNode != null) {
            parentElkNode.getChildren().add((Object)newNode);
            this.applyParentNodeOption((ElkGraphElement)parentElkNode, elkTargetToOptionsOverrideMap);
        }
        mapping.getGraphMap().put((Object)newNode, (Object)nodeEditPart);
        EObject eObj = nodeEditPart.resolveSemanticElement();
        if (eObj instanceof DNode && ((NodeStyle)((DNode)eObj).getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL && (newNodeLabel = this.createNodeLabel(mapping, nodeEditPart, (IGraphicalEditPart)nodeEditPart.getParent(), parentElkNode, elkTargetToOptionsOverrideMap)) != null) {
            newNode.getLabels().add((Object)newNodeLabel);
        }
        this.addConnections(mapping, nodeEditPart);
        return newNode;
    }

    protected Insets calcSpecificInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    protected ElkPort createPort(LayoutMapping mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)elknode);
        this.applyOptionsRelatedToElementTarget((ElkGraphElement)port, elkTargetToOptionsOverrideMap);
        elknode.setProperty(CoreOptions.PORT_LABELS_PLACEMENT, (Object)PortLabelPlacement.fixed());
        Rectangle portBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
        double xpos = portBounds.x - nodeBounds.x;
        double ypos = portBounds.y - nodeBounds.y;
        port.setLocation(xpos, ypos);
        port.setDimensions((double)portBounds.width, (double)portBounds.height);
        double borderNodeOffset = -IBorderItemOffsets.DEFAULT_OFFSET.preciseWidth();
        EObject eObj = portEditPart.resolveSemanticElement();
        if (eObj instanceof DDiagramElement && new DDiagramElementQuery((DDiagramElement)eObj).isIndirectlyCollapsed()) {
            borderNodeOffset = -IBorderItemOffsets.COLLAPSE_FILTER_OFFSET.preciseWidth();
        }
        port.setProperty(CoreOptions.PORT_BORDER_OFFSET, (Object)borderNodeOffset);
        if (eObj instanceof DNode) {
            PortSide authorizedSide = PortSide.UNDEFINED;
            DNodeQuery query = new DNodeQuery((DNode)eObj);
            List forbiddenSides = query.getForbiddenSide();
            HashSet authorizedSides = new HashSet(PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
            for (Side side : forbiddenSides) {
                authorizedSides.remove(this.convertSideToPortSide(side));
            }
            if (authorizedSides.size() != 4) {
                if (authorizedSides.size() > 1) {
                    if (authorizedSides.contains(PortSide.WEST)) {
                        authorizedSide = PortSide.WEST;
                    } else if (authorizedSides.contains(PortSide.SOUTH)) {
                        authorizedSide = PortSide.SOUTH;
                    } else if (authorizedSides.contains(PortSide.EAST)) {
                        authorizedSide = PortSide.EAST;
                    } else if (authorizedSides.contains(PortSide.NORTH)) {
                        authorizedSide = PortSide.NORTH;
                    }
                } else {
                    authorizedSide = (PortSide)authorizedSides.iterator().next();
                }
                elknode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
                port.setProperty(CoreOptions.PORT_SIDE, (Object)authorizedSide);
            }
        }
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart portEditPartLabel = (IGraphicalEditPart)portChildObj;
            Node node = (Node)portEditPartLabel.getNotationView();
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            int originalXLabelLocation = Integer.MIN_VALUE;
            if (layoutConstraint instanceof Location) {
                Location location = (Location)layoutConstraint;
                originalXLabelLocation = location.getX();
            }
            IFigure labelFigure = portEditPartLabel.getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            } else if (labelFigure instanceof SiriusWrapLabel) {
                SiriusWrapLabel label = (SiriusWrapLabel)labelFigure;
                text = label.getText();
            }
            if (text == null) continue;
            ElkLabel portLabel = ElkGraphUtil.createLabel((ElkGraphElement)port);
            this.applyOptionsRelatedToElementTarget((ElkGraphElement)portLabel, elkTargetToOptionsOverrideMap);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, portChildObj);
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            if (originalXLabelLocation != Integer.MIN_VALUE && originalXLabelLocation == (int)(portBounds.preciseWidth() / 2.0 - labelBounds.preciseWidth() / 2.0)) {
                portLabel.setLocation((double)originalXLabelLocation, (double)(portBounds.height + 1));
            } else {
                portLabel.setLocation(portBounds.preciseWidth() / 2.0 - labelBounds.preciseWidth() / 2.0, (double)(portBounds.height + 1));
            }
            try {
                Dimension size = labelFigure.getPreferredSize();
                portLabel.setDimensions((double)size.width, (double)size.height);
            }
            catch (SWTException sWTException) {}
        }
        return port;
    }

    private PortSide convertSideToPortSide(Side side) {
        PortSide result = PortSide.UNDEFINED;
        if (Side.WEST.equals((Object)side)) {
            result = PortSide.WEST;
        } else if (Side.EAST.equals((Object)side)) {
            result = PortSide.EAST;
        } else if (Side.NORTH.equals((Object)side)) {
            result = PortSide.NORTH;
        } else if (Side.SOUTH.equals((Object)side)) {
            result = PortSide.SOUTH;
        }
        return result;
    }

    protected ElkLabel createNodeLabel(LayoutMapping mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        if (!(labelEditPart instanceof SiriusDescriptionCompartmentEditPart)) {
            Label label;
            Object labelFigure = labelEditPart instanceof IAbstractDiagramNodeEditPart ? ((IAbstractDiagramNodeEditPart)labelEditPart).getNodeLabel() : labelEditPart.getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                text = wrappingLabel.getText();
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                text = label.getText();
            } else if (labelFigure instanceof SiriusWrapLabel) {
                label = (SiriusWrapLabel)labelFigure;
                text = label.getText();
            }
            if (text != null) {
                Rectangle nodeBounds;
                label = ElkGraphUtil.createLabel((ElkGraphElement)elknode);
                this.applyOptionsRelatedToElementTarget((ElkGraphElement)label, elkTargetToOptionsOverrideMap);
                if (StringUtil.isEmpty((String)text)) {
                    label.setText(" ");
                } else {
                    label.setText(text);
                }
                Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
                if (!(labelEditPart instanceof IAbstractDiagramNodeEditPart)) {
                    mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                    nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
                } else {
                    nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelEditPart.getFigure());
                }
                label.setLocation((double)(labelBounds.x - nodeBounds.x), (double)(labelBounds.y - nodeBounds.y));
                try {
                    Dimension size = labelFigure.getPreferredSize();
                    label.setDimensions((double)size.width, (double)size.height);
                }
                catch (SWTException sWTException) {}
                NodeLabelPlacement insideLabelPlacement = NodeLabelPlacement.INSIDE;
                NodeLabelPlacement verticalNodeLabelPlacement = NodeLabelPlacement.V_TOP;
                NodeLabelPlacement horizontalLabelPlacement = NodeLabelPlacement.H_CENTER;
                if (labelEditPart instanceof DNodeListElementEditPart) {
                    verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                } else {
                    EObject siriusObject = labelEditPart instanceof IAbstractDiagramNodeEditPart ? labelEditPart.resolveSemanticElement() : nodeEditPart.resolveSemanticElement();
                    boolean forcedValue = false;
                    if (siriusObject instanceof DDiagramElement) {
                        if (siriusObject instanceof DNodeContainer) {
                            if (new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)((DNodeContainer)siriusObject)).isRegionInVerticalStack()) {
                                forcedValue = true;
                                verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                            } else if (new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)((DNodeContainer)siriusObject)).isRegionInHorizontalStack()) {
                                forcedValue = true;
                            }
                        }
                        if (!forcedValue) {
                            DDiagramElement dde = (DDiagramElement)siriusObject;
                            Style style = dde.getStyle();
                            if (style instanceof LabelStyle) {
                                LabelAlignment labelAlignment = ((LabelStyle)style).getLabelAlignment();
                                if (labelAlignment.equals((Object)LabelAlignment.LEFT)) {
                                    horizontalLabelPlacement = NodeLabelPlacement.H_LEFT;
                                } else if (labelAlignment.equals((Object)LabelAlignment.RIGHT)) {
                                    horizontalLabelPlacement = NodeLabelPlacement.H_RIGHT;
                                }
                            }
                            if (style instanceof NodeStyle) {
                                if (((NodeStyle)style).getLabelPosition().equals((Object)LabelPosition.BORDER_LITERAL)) {
                                    insideLabelPlacement = NodeLabelPlacement.OUTSIDE;
                                }
                                verticalNodeLabelPlacement = NodeLabelPlacement.V_CENTER;
                            }
                        }
                    }
                }
                EnumSet<NodeLabelPlacement> enumSet = EnumSet.of(insideLabelPlacement, horizontalLabelPlacement, verticalNodeLabelPlacement);
                label.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, enumSet);
                return label;
            }
        }
        return null;
    }

    protected void addConnections(LayoutMapping mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            ConnectionEditPart connectionEditPart;
            if (!(targetConn instanceof ConnectionEditPart) || !this.editPartFilter.filter((EditPart)(connectionEditPart = (ConnectionEditPart)targetConn))) continue;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping mapping, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        HashMap<EReference, ElkEdge> reference2EdgeMap = new HashMap<EReference, ElkEdge>();
        List connections = ((List)mapping.getProperty(CONNECTIONS)).stream().sorted(CONNECTION_COMPARATOR).collect(Collectors.toList());
        HashMap<ElkNode, Integer> edgeContainerToNbObliqueEdges = new HashMap<ElkNode, Integer>();
        HashMap<ElkNode, Integer> edgeContainerToNbRectilinearEdges = new HashMap<ElkNode, Integer>();
        for (ConnectionEditPart connection : connections) {
            IDiagramElementEditPart ideep;
            DDiagramElement dde;
            ElkEdge edge;
            boolean isOppositeEdge = false;
            Optional<EdgeLabelPlacement> edgeLabelPlacement = Optional.empty();
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (ElkEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = Optional.of(EdgeLabelPlacement.TAIL);
                    isOppositeEdge = true;
                } else {
                    edge = ElkGraphUtil.createEdge(null);
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = ElkGraphUtil.createEdge(null);
            }
            this.applyOptionsRelatedToElementTarget((ElkGraphElement)edge, elkTargetToOptionsOverrideMap);
            BiMap inverseGraphMap = mapping.getGraphMap().inverse();
            ElkGraphElement sourceElement = (ElkGraphElement)inverseGraphMap.get((Object)connection.getSource());
            ElkGraphElement targetElement = (ElkGraphElement)inverseGraphMap.get((Object)connection.getTarget());
            if (sourceElement == null || targetElement == null) continue;
            ElkNode edgeContainer = ElkDiagramLayoutConnector.findLowestCommonAncestor(sourceElement, targetElement);
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)edgeContainer);
            if (!isOppositeEdge) {
                edgeContainer.getContainedEdges().add((Object)edge);
                mapping.getGraphMap().put((Object)edge, (Object)connection);
                this.setEdgeLayout(edge, connection, offset);
                ElkConnectableShape sourceShape = this.getRealElementToConnectTo(sourceElement, this.getStartingPoint(edge), mapping, elkTargetToOptionsOverrideMap);
                edge.getSources().add((Object)sourceShape);
                ElkConnectableShape targetShape = this.getRealElementToConnectTo(targetElement, this.getEndingPoint(edge), mapping, elkTargetToOptionsOverrideMap);
                edge.getTargets().add((Object)targetShape);
            }
            if (connection instanceof IDiagramElementEditPart && (dde = (ideep = (IDiagramElementEditPart)connection).resolveDiagramElement()) instanceof DEdge) {
                DEdgeQuery dEdgeQuery = new DEdgeQuery((DEdge)dde);
                Routing routing = dEdgeQuery.getRouting();
                if (routing.getValue() == 1 || routing.getValue() == 2) {
                    this.addOneEdges(edgeContainer, edgeContainerToNbRectilinearEdges);
                } else if (routing.getValue() == 0) {
                    this.addOneEdges(edgeContainer, edgeContainerToNbObliqueEdges);
                }
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset, elkTargetToOptionsOverrideMap);
        }
        for (ElkNode edgeContainer : edgeContainerToNbObliqueEdges.keySet()) {
            int nbObliques = (Integer)edgeContainerToNbObliqueEdges.get(edgeContainer);
            Integer nbRectilinears = (Integer)edgeContainerToNbRectilinearEdges.get(edgeContainer);
            if (nbRectilinears == null || nbRectilinears <= nbObliques) {
                this.setEgdeRoutingPropertyIfNotDefined(edgeContainer, EdgeRouting.POLYLINE);
            } else {
                this.setEgdeRoutingPropertyIfNotDefined(edgeContainer, EdgeRouting.ORTHOGONAL);
            }
            if (nbRectilinears == null) continue;
            edgeContainerToNbRectilinearEdges.remove(edgeContainer);
        }
        for (ElkNode edgeContainer : edgeContainerToNbRectilinearEdges.keySet()) {
            this.setEgdeRoutingPropertyIfNotDefined(edgeContainer, EdgeRouting.ORTHOGONAL);
        }
    }

    private void setEgdeRoutingPropertyIfNotDefined(ElkNode edgeContainer, EdgeRouting routingStyleToSet) {
        EdgeRouting currentEdgeRouting = (EdgeRouting)edgeContainer.getProperty(CoreOptions.EDGE_ROUTING);
        if (currentEdgeRouting == null || EdgeRouting.UNDEFINED.equals((Object)currentEdgeRouting)) {
            edgeContainer.setProperty(CoreOptions.EDGE_ROUTING, (Object)routingStyleToSet);
        }
    }

    private void addOneEdges(ElkNode edgeContainer, Map<ElkNode, Integer> edgeContainerToNbEdges) {
        Integer currentNbOfEdges = edgeContainerToNbEdges.get(edgeContainer);
        if (currentNbOfEdges == null) {
            edgeContainerToNbEdges.put(edgeContainer, 1);
        } else {
            edgeContainerToNbEdges.put(edgeContainer, currentNbOfEdges + 1);
        }
    }

    private PrecisionPoint getStartingPoint(ElkEdge edge) {
        ElkEdgeSection section = (ElkEdgeSection)edge.getSections().get(0);
        return new PrecisionPoint(section.getStartX(), section.getStartY());
    }

    private PrecisionPoint getEndingPoint(ElkEdge edge) {
        ElkEdgeSection section = (ElkEdgeSection)edge.getSections().get(0);
        return new PrecisionPoint(section.getEndX(), section.getEndY());
    }

    private ElkConnectableShape getRealElementToConnectTo(ElkGraphElement graphElement, PrecisionPoint pointToCreateNodeIfNecessary, LayoutMapping mapping, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        ElkConnectableShape result = null;
        if (graphElement instanceof ElkConnectableShape) {
            result = (ElkConnectableShape)graphElement;
        } else if (graphElement instanceof ElkEdge) {
            ElkEdge secondPartOfEdge = (ElkEdge)graphElement.getProperty(SECOND_PART_OF_SPLIT_EDGE);
            if (secondPartOfEdge != null) {
                result = (ElkConnectableShape)((ElkEdge)graphElement).getTargets().get(0);
            } else {
                ElkNode edgeContainer = ((ElkEdge)graphElement).getContainingNode();
                ElkNode newNode = ElkGraphUtil.createNode((ElkNode)edgeContainer);
                this.applyOptionsRelatedToElementTarget((ElkGraphElement)newNode, elkTargetToOptionsOverrideMap);
                newNode.setIdentifier(EDGE_ON_EDGE_ID_NODE);
                newNode.setX(pointToCreateNodeIfNecessary.preciseX());
                newNode.setY(pointToCreateNodeIfNecessary.preciseY());
                newNode.setDimensions(1.0, 1.0);
                newNode.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
                if (edgeContainer != null) {
                    edgeContainer.getChildren().add((Object)newNode);
                    this.applyParentNodeOption((ElkGraphElement)edgeContainer, elkTargetToOptionsOverrideMap);
                }
                result = newNode;
                this.splitEdge((ElkEdge)graphElement, newNode, mapping, elkTargetToOptionsOverrideMap);
            }
        }
        return result;
    }

    private void splitEdge(ElkEdge edgeToSplit, ElkNode intermediateNode, LayoutMapping mapping, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        Object editPart = mapping.getGraphMap().get((Object)edgeToSplit);
        if (editPart instanceof ConnectionEditPart) {
            edgeToSplit.setProperty(CoreOptions.PRIORITY, (Object)10);
            edgeToSplit.setProperty(LayeredOptions.PRIORITY_STRAIGHTNESS, (Object)10);
            edgeToSplit.getTargets().add((Object)intermediateNode);
            int indexOfEdgeToSplit = edgeToSplit.getContainingNode().getContainedEdges().indexOf((Object)edgeToSplit);
            ElkEdge secondEdge = ElkGraphUtil.createEdge(null);
            edgeToSplit.getContainingNode().getContainedEdges().add(indexOfEdgeToSplit + 1, (Object)secondEdge);
            this.applyOptionsRelatedToElementTarget((ElkGraphElement)secondEdge, elkTargetToOptionsOverrideMap);
            secondEdge.getSources().add((Object)intermediateNode);
            secondEdge.getTargets().add((Object)((ElkConnectableShape)edgeToSplit.getTargets().get(0)));
            edgeToSplit.getTargets().remove(0);
            secondEdge.getProperties().putAll(edgeToSplit.getProperties());
            secondEdge.setProperty(LayeredOptions.PRIORITY_DIRECTION, (Object)10);
            edgeToSplit.getProperties().put(SECOND_PART_OF_SPLIT_EDGE, (Object)secondEdge);
            ElkEdgeSection originalSection = (ElkEdgeSection)edgeToSplit.getSections().get(0);
            ElkEdgeSection secondEdgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)secondEdge);
            PrecisionPoint originalEndingPoint = new PrecisionPoint(originalSection.getEndX(), originalSection.getEndY());
            PrecisionPoint intermediateNodeLocation = new PrecisionPoint(intermediateNode.getX(), intermediateNode.getY());
            PrecisionPoint startPoint = new PrecisionPoint(originalSection.getStartX(), originalSection.getStartY());
            if (originalSection.getBendPoints().isEmpty()) {
                originalSection.setEndX((double)intermediateNodeLocation.x);
                originalSection.setEndY((double)intermediateNodeLocation.y);
                secondEdgeSection.setStartX((double)intermediateNodeLocation.x);
                secondEdgeSection.setStartY((double)intermediateNodeLocation.y);
            } else {
                boolean isOnSecondPart = false;
                Iterator iterator = originalSection.getBendPoints().iterator();
                while (iterator.hasNext()) {
                    ElkBendPoint bendPoint = (ElkBendPoint)iterator.next();
                    PrecisionPoint endPoint = new PrecisionPoint(bendPoint.getX(), bendPoint.getY());
                    if (new LineSeg((Point)startPoint, (Point)endPoint).containsPoint((Point)intermediateNodeLocation, 1)) {
                        originalSection.setEndX((double)intermediateNodeLocation.x);
                        originalSection.setEndY((double)intermediateNodeLocation.y);
                        isOnSecondPart = true;
                        secondEdgeSection.setStartX((double)intermediateNodeLocation.x);
                        secondEdgeSection.setStartY((double)intermediateNodeLocation.y);
                    }
                    if (isOnSecondPart) {
                        ElkGraphUtil.createBendPoint((ElkEdgeSection)secondEdgeSection, (double)endPoint.preciseX(), (double)endPoint.preciseY());
                        iterator.remove();
                    }
                    startPoint = endPoint;
                }
                if (isOnSecondPart) {
                    originalSection.setEndX((double)intermediateNodeLocation.x);
                    originalSection.setEndY((double)intermediateNodeLocation.y);
                    secondEdgeSection.setStartX((double)intermediateNodeLocation.x);
                    secondEdgeSection.setStartY((double)intermediateNodeLocation.y);
                }
            }
            secondEdgeSection.setEndX(originalEndingPoint.preciseX());
            secondEdgeSection.setEndY(originalEndingPoint.preciseY());
        }
    }

    protected void setEdgeLayout(ElkEdge edge, ConnectionEditPart connection, KVector offset) {
        double currentSize;
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        ElkEdgeSection edgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
        Point firstPoint = pointList.getPoint(0);
        edgeSection.setStartX((double)firstPoint.x - offset.x);
        edgeSection.setStartY((double)firstPoint.y - offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)((double)point.x - offset.x), (double)((double)point.y - offset.y));
            ++i;
        }
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        edgeSection.setEndX((double)lastPoint.x - offset.x);
        edgeSection.setEndY((double)lastPoint.y - offset.y);
        if (figure instanceof Shape && (currentSize = (double)((Shape)figure).getLineWidth()) != (Double)CoreOptions.EDGE_THICKNESS.getDefault()) {
            edge.setProperty(CoreOptions.EDGE_THICKNESS, (Object)currentSize);
        }
    }

    protected void processEdgeLabels(LayoutMapping mapping, ConnectionEditPart connection, ElkEdge edge, Optional<EdgeLabelPlacement> placement, KVector offset, Map<LayoutOptionTarget, Set<LayoutOption>> elkTargetToOptionsOverrideMap) {
        for (Object obj : connection.getChildren()) {
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            Object labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.setWidth(wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap());
                    iconBounds.setHeight(wrappingLabel.getIcon().getBounds().height);
                    labelText = "O " + (String)labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.setWidth(iconBounds.width + label.getIconTextGap());
                    labelText = "O " + (String)labelText;
                }
            } else if (labelFigure instanceof SiriusWrapLabel) {
                label = (SiriusWrapLabel)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.setWidth(iconBounds.width + label.getIconTextGap());
                    labelText = "O " + (String)labelText;
                }
            }
            if (labelText != null && ((String)labelText).length() > 0) {
                label = ElkGraphUtil.createLabel((ElkGraphElement)edge);
                this.applyOptionsRelatedToElementTarget((ElkGraphElement)label, elkTargetToOptionsOverrideMap);
                if (!placement.isPresent()) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement.get());
                }
                label.setLocation((double)labelBounds.x - offset.x, (double)labelBounds.y - offset.y);
                label.setWidth((double)labelBounds.width);
                label.setHeight((double)labelBounds.height);
                label.setText((String)labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = ElkGraphUtil.createLabel(null);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    public void layout(LayoutMapping layoutMapping) {
        BasicProgressMonitor basicProgressMonitor = new BasicProgressMonitor(0);
        this.graphLayoutEngine.layout(layoutMapping.getLayoutGraph(), basicProgressMonitor.subTask(1.0f));
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        return null;
    }

    public static ElkNode findLowestCommonAncestor(ElkGraphElement graphElement1, ElkGraphElement graphElement2) {
        ElkNode node1 = null;
        if (graphElement1 instanceof ElkPort) {
            node1 = ((ElkPort)graphElement1).getParent();
        } else if (graphElement1 instanceof ElkNode) {
            node1 = (ElkNode)graphElement1;
        } else if (graphElement1 instanceof ElkEdge) {
            node1 = ElkGraphUtil.findBestEdgeContainment((ElkEdge)((ElkEdge)graphElement1));
        }
        ElkNode node2 = null;
        if (graphElement2 instanceof ElkPort) {
            node2 = ((ElkPort)graphElement2).getParent();
        } else if (graphElement2 instanceof ElkNode) {
            node2 = (ElkNode)graphElement2;
        } else if (graphElement2 instanceof ElkEdge) {
            node2 = ElkGraphUtil.findBestEdgeContainment((ElkEdge)((ElkEdge)graphElement2));
        }
        if (node1 != null && node2 != null) {
            return ElkGraphUtil.findLowestCommonAncestor((ElkNode)node1, (ElkNode)node2);
        }
        return null;
    }

    private static class EdgeEditPartComparator
    implements Comparator<ConnectionEditPart> {
        private EdgeEditPartComparator() {
        }

        @Override
        public int compare(ConnectionEditPart o1, ConnectionEditPart o2) {
            EditPart source1 = o1.getSource();
            EditPart source2 = o2.getSource();
            EditPart target1 = o1.getTarget();
            EditPart target2 = o2.getTarget();
            if (o2 == source1 || o2 == target1) {
                return 1;
            }
            if (o1 == source2 || o1 == target2) {
                return -1;
            }
            if (this.isTargetingEdge(o1) && !this.isTargetingEdge(o2)) {
                return 1;
            }
            if (!this.isTargetingEdge(o1) && this.isTargetingEdge(o2)) {
                return -1;
            }
            return 0;
        }

        private boolean isTargetingEdge(ConnectionEditPart part) {
            return part.getSource() instanceof ConnectionEditPart || part.getTarget() instanceof ConnectionEditPart;
        }
    }
}

