/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutPhases;
import org.eclipse.elk.alg.rectpacking.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.BoxLayoutProvider;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class RectPackingLayoutProvider
extends AbstractLayoutProvider {
    private final AlgorithmAssembler<RectPackingLayoutPhases, ElkNode> algorithmAssembler = AlgorithmAssembler.create(RectPackingLayoutPhases.class);

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Rectangle Packing", 1.0f);
        ElkPadding padding = (ElkPadding)layoutGraph.getProperty(RectPackingOptions.PADDING);
        boolean fixedGraphSize = (Boolean)layoutGraph.getProperty(RectPackingOptions.NODE_SIZE_FIXED_GRAPH_SIZE);
        double nodeNodeSpacing = (Double)layoutGraph.getProperty(RectPackingOptions.SPACING_NODE_NODE);
        boolean tryBox = (Boolean)layoutGraph.getProperty(RectPackingOptions.TRYBOX);
        EList rectangles = layoutGraph.getChildren();
        boolean stackable = false;
        if (tryBox && rectangles.size() >= 3) {
            ElkNode region2 = (ElkNode)rectangles.get(0);
            ElkNode region3 = (ElkNode)rectangles.get(1);
            int counter = 0;
            while (counter + 2 < rectangles.size()) {
                ElkNode region1 = region2;
                region2 = region3;
                region3 = (ElkNode)rectangles.get(counter + 2);
                if (region1.getHeight() >= region2.getHeight() + region3.getHeight() + nodeNodeSpacing || region3.getHeight() >= region1.getHeight() + region2.getHeight() + nodeNodeSpacing) {
                    stackable = true;
                    break;
                }
                ++counter;
            }
        } else {
            stackable = true;
        }
        if (!stackable) {
            int priority = rectangles.size();
            for (ElkNode elkNode : rectangles) {
                elkNode.setProperty(CoreOptions.PRIORITY, (Object)priority);
                --priority;
            }
            new BoxLayoutProvider().layout(layoutGraph, (IElkProgressMonitor)new BasicProgressMonitor());
            progressMonitor.done();
            return;
        }
        List<ILayoutProcessor<ElkNode>> algorithm = this.assembleAlgorithm(layoutGraph);
        float monitorProgress = 1.0f / (float)algorithm.size();
        int slotIndex = 0;
        for (ILayoutProcessor<ElkNode> processor : algorithm) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            if (progressMonitor.isLoggingEnabled()) {
                progressMonitor.logGraph(layoutGraph, String.valueOf(slotIndex) + "-Before " + processor.getClass().getSimpleName());
            }
            processor.process((Object)layoutGraph, progressMonitor.subTask(monitorProgress));
            ++slotIndex;
        }
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, String.valueOf(slotIndex) + "-Finished");
        }
        RectPackingLayoutProvider.applyPadding((List<ElkNode>)rectangles, padding);
        if (!fixedGraphSize) {
            ElkUtil.resizeNode((ElkNode)layoutGraph, (double)((Double)layoutGraph.getProperty(InternalProperties.DRAWING_WIDTH) + padding.getHorizontal()), (double)((Double)layoutGraph.getProperty(InternalProperties.DRAWING_HEIGHT) + padding.getVertical()), (boolean)false, (boolean)true);
        }
        if (!((Boolean)layoutGraph.getProperty(RectPackingOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)layoutGraph).execute();
        }
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "Output");
        }
        progressMonitor.done();
    }

    private static void applyPadding(List<ElkNode> rectangles, ElkPadding padding) {
        for (ElkNode rect : rectangles) {
            rect.setLocation(rect.getX() + padding.getLeft(), rect.getY() + padding.getTop());
        }
    }

    private List<ILayoutProcessor<ElkNode>> assembleAlgorithm(ElkNode layoutGraph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)RectPackingLayoutPhases.P1_WIDTH_APPROXIMATION, (ILayoutPhaseFactory)layoutGraph.getProperty(RectPackingOptions.WIDTH_APPROXIMATION_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)RectPackingLayoutPhases.P2_PACKING, (ILayoutPhaseFactory)layoutGraph.getProperty(RectPackingOptions.PACKING_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)RectPackingLayoutPhases.P3_WHITESPACE_ELIMINATION, (ILayoutPhaseFactory)layoutGraph.getProperty(RectPackingOptions.WHITE_SPACE_ELIMINATION_STRATEGY));
        this.algorithmAssembler.addProcessorConfiguration(this.getPhaseIndependentLayoutProcessorConfiguration(layoutGraph));
        List processors = this.algorithmAssembler.build((Object)layoutGraph);
        return processors;
    }

    private LayoutProcessorConfiguration<RectPackingLayoutPhases, ElkNode> getPhaseIndependentLayoutProcessorConfiguration(ElkNode layoutGraph) {
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.create();
        configuration.addBefore((Enum)RectPackingLayoutPhases.P1_WIDTH_APPROXIMATION, (ILayoutProcessorFactory)IntermediateProcessorStrategy.MIN_SIZE_PRE_PROCESSOR);
        configuration.addBefore((Enum)RectPackingLayoutPhases.P2_PACKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.MIN_SIZE_POST_PROCESSOR);
        if (((Boolean)layoutGraph.getProperty(RectPackingOptions.INTERACTIVE)).booleanValue()) {
            configuration.addBefore((Enum)RectPackingLayoutPhases.P1_WIDTH_APPROXIMATION, (ILayoutProcessorFactory)IntermediateProcessorStrategy.INTERACTIVE_NODE_REORDERER);
        }
        return configuration;
    }
}

