/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.api.command.view.AbstractZOrderRecordingCommand;

public class SendElementsBackward
extends AbstractZOrderRecordingCommand {
    int newIndex = -1;

    public SendElementsBackward(TransactionalEditingDomain domain, List<? extends View> elementsToSendBackward, int index) {
        super(domain, elementsToSendBackward);
        this.elementsToMove = this.reverseSortSelection(this.elementsToMove);
        if (index < -1 && index > this.getChildrenSize() - 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.SendElementsBackward_wrongIndex, this.getChildrenSize() - 1));
        }
        this.newIndex = index;
    }

    private int getChildrenSize() {
        if (this.elementsToMove.get(0) instanceof Edge && this.containerView instanceof Diagram) {
            return ((Diagram)this.containerView).getEdges().size();
        }
        return this.containerView.getChildren().size();
    }

    protected void doExecute() {
        for (View view : this.elementsToMove) {
            if (view instanceof Edge && this.containerView instanceof Diagram) {
                if (this.newIndex == -1) {
                    EList children = ((Diagram)this.containerView).getPersistedEdges();
                    int oldIndex = children.indexOf((Object)view);
                    if (oldIndex <= 0) continue;
                    ((Diagram)this.containerView).removeEdge((Edge)view);
                    ((Diagram)this.containerView).insertEdgeAt((Edge)view, oldIndex - 1);
                    continue;
                }
                ((Diagram)this.containerView).removeEdge((Edge)view);
                ((Diagram)this.containerView).insertEdgeAt((Edge)view, this.newIndex);
                continue;
            }
            int oldIndex = this.containerView.getChildren().indexOf((Object)view);
            if (oldIndex <= 0) continue;
            ViewUtil.repositionChildAt((View)this.containerView, (View)view, (int)(oldIndex - 1));
        }
    }

    @Override
    protected String getCommandLabelForOneElement() {
        return Messages.SendElementsBackward_oneElementLabel;
    }

    @Override
    protected String getCommandLabelForSeveralElements() {
        return Messages.SendElementsBackward_severalElementsLabel;
    }
}

