/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p1widthapproximation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.p1widthapproximation.BestCandidateFilter;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.core.math.ElkPadding;

public class AreaFilter
implements BestCandidateFilter {
    @Override
    public List<DrawingData> filterList(List<DrawingData> candidates, double aspectRatio, ElkPadding padding) {
        ArrayList<DrawingData> remainingCandidates = new ArrayList<DrawingData>();
        double minArea = Double.POSITIVE_INFINITY;
        for (DrawingData opt : candidates) {
            minArea = Math.min(minArea, (opt.getDrawingWidth() + padding.getHorizontal()) * (opt.getDrawingHeight() + padding.getVertical()));
        }
        for (DrawingData candidate : candidates) {
            if ((candidate.getDrawingWidth() + padding.getHorizontal()) * (candidate.getDrawingHeight() + padding.getVertical()) != minArea) continue;
            remainingCandidates.add(candidate);
        }
        return remainingCandidates;
    }
}

