/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport.control;

import java.nio.file.Path;
import java.util.function.Consumer;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.files.PlanProFileResource;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.modelloader.ModelLoader;
import org.eclipse.set.feature.projectdata.utils.AbstractImportControl;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.model.planpro.Layoutinformationen.DocumentRoot;
import org.eclipse.set.model.planpro.Layoutinformationen.LayoutinformationenFactory;
import org.eclipse.set.model.planpro.Layoutinformationen.LayoutinformationenPackage;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.widgets.FileField;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportLayoutControl
extends AbstractImportControl {
    private FileField fileField;
    private PlanPro_Layoutinfo layoutToImport;
    private final Runnable handleControlChange;
    private final IEventBroker broker;

    public ImportLayoutControl(ServiceProvider serviceProvider, IModelSession modelSession, IEventBroker broker, Runnable handleControlChange) {
        super(serviceProvider, modelSession);
        this.handleControlChange = handleControlChange;
        this.broker = broker;
    }

    @Override
    public boolean isValid() {
        return this.layoutToImport != null;
    }

    @Override
    public void resetControl() {
        this.layoutToImport = null;
        this.fileField.getText().setText("");
        this.setImported(false);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void doImport(Shell shell) {
        PlanPro_Layoutinfo sourceLayout = this.modelSession.getLayoutInformation();
        if (this.layoutToImport == null) {
            return;
        }
        if (sourceLayout != null && !this.serviceProvider.dialogService.confirmOverwriteOperationalData(shell)) {
            return;
        }
        if (this.modelSession.getToolboxFile().getLayoutDocumentRoot() == null) {
            this.createDocumentRoot();
        }
        try {
            try {
                Command importCommand = SetCommand.create((EditingDomain)this.modelSession.getEditingDomain(), (Object)this.modelSession.getToolboxFile().getLayoutDocumentRoot(), (Object)LayoutinformationenPackage.eINSTANCE.getDocumentRoot_PlanProLayoutinfo(), (Object)this.layoutToImport);
                this.modelSession.getEditingDomain().getCommandStack().execute(importCommand);
                this.modelSession.save(shell);
                this.serviceProvider.dialogService.reportImported(shell);
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new EditingCompleted());
                this.broker.send("modelsession/change/layout", (Object)this.modelSession.getLayoutInformation());
                this.resetControl();
                this.setImported(true);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new RuntimeException(e);
            }
            catch (UserAbortion userAbortion) {
                if (this.modelSession.isDirty()) {
                    this.modelSession.revert();
                }
            }
        }
        finally {
            if (this.modelSession.isDirty()) {
                this.modelSession.revert();
            }
        }
    }

    @Override
    public void createControl(Composite parent, Shell shell, ToolboxFileRole role) {
        this.fileField = new FileField(parent, this.serviceProvider.dialogService.getPlanProFileFilters(), this.serviceProvider.dialogService);
        this.fileField.getComposite().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileField.getButton().setText(this.serviceProvider.messages.PlanProImportPart_fileFieldButtonText);
        this.fileField.setPathValidation(path -> this.validatePath((Path)path, t -> {
            if (t.layoutInfo() == null) {
                this.serviceProvider.dialogService.openInformation(shell, this.serviceProvider.messages.PlanProImportPart_Notcontains_Layout_Title, this.serviceProvider.messages.PlanProImportPart_Notcontains_Layout_Msg);
                return;
            }
            this.layoutToImport = t.layoutInfo();
        }, shell, role));
        this.fileField.getText().addModifyListener(this.selectedFileHandle());
    }

    @Override
    protected Boolean validatePath(Path path, Consumer<ModelLoader.ModelContents> storeModel, Shell shell, ToolboxFileRole role) {
        boolean validatePath = super.validatePath(path, storeModel, shell, role);
        return this.layoutToImport != null && validatePath;
    }

    @Override
    protected ModifyListener selectedFileHandle() {
        return e -> {
            Text text;
            Object object = e.getSource();
            if (object instanceof Text && !(text = (Text)object).getText().isBlank()) {
                this.handleControlChange.run();
            }
        };
    }

    private void createDocumentRoot() {
        EditingDomain editingDomain = this.modelSession.getEditingDomain();
        DocumentRoot documentRoot = LayoutinformationenFactory.eINSTANCE.createDocumentRoot();
        PlanProFileResource layoutResource = new PlanProFileResource(URI.createURI((String)"http://www.plan-pro.org/modell/Layoutinformationen/1.10.0.3"));
        editingDomain.getResourceSet().getResources().add((Object)layoutResource);
        layoutResource.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider(editingDomain));
        layoutResource.getContents().add((Object)documentRoot);
        this.modelSession.getToolboxFile().setResourcePath((Resource)layoutResource, this.modelSession.getToolboxFile().getLayoutPath());
    }
}

