/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.TopKantePath;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BereichObjektExtensions
extends BasisObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(BereichObjektExtensions.class);

    public static DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getPath(Bereich_Objekt bereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        return new TopKantePath(bereich, start, end);
    }

    public static DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getPath(Bereich_Objekt bereich, Punkt_Objekt start, Punkt_Objekt end) {
        Set<Punkt_Objekt_TOP_Kante_AttributeGroup> s = BereichObjektExtensions.intersection(bereich, start);
        Set<Punkt_Objekt_TOP_Kante_AttributeGroup> e = BereichObjektExtensions.intersection(bereich, end);
        boolean _isEmpty = s.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("start: topKante=");
            String _wert = CollectionExtensions.getUnique(PunktObjektExtensions.getTopKanten(start)).getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" abstand=");
            BigDecimal _wert_1 = PunktObjektExtensions.getSinglePoint(start).getAbstand().getWert();
            _builder.append((Object)_wert_1);
            logger.error(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("bereichObjektTeilbereich: ");
            String _debugString = Debug.debugString(bereich.getBereichObjektTeilbereich());
            _builder_1.append(_debugString);
            logger.error(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Startsignal ");
            String _debugString_1 = Debug.debugString(start);
            _builder_2.append(_debugString_1);
            _builder_2.append(" not in Bereich ");
            String _debugName = Debug.debugName(bereich);
            _builder_2.append(_debugName);
            throw new IllegalArgumentException(_builder_2.toString());
        }
        boolean _isEmpty_1 = e.isEmpty();
        if (_isEmpty_1) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Zielelement ");
            String _debugString_2 = Debug.debugString(end);
            _builder_3.append(_debugString_2);
            _builder_3.append(" not in Bereich ");
            String _debugName_1 = Debug.debugName(bereich);
            _builder_3.append(_debugName_1);
            throw new IllegalArgumentException(_builder_3.toString());
        }
        Punkt_Objekt_TOP_Kante_AttributeGroup _unique = CollectionExtensions.getUnique(s);
        Punkt_Objekt_TOP_Kante_AttributeGroup _unique_1 = CollectionExtensions.getUnique(e);
        return new TopKantePath(bereich, _unique, _unique_1);
    }

    public static Set<TOP_Kante> getTopKanten(Bereich_Objekt bereich) {
        Functions.Function1 _function = it -> BereichObjektExtensions.getTopKante(it);
        return IterableExtensions.toSet((Iterable)ListExtensions.map((List)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function));
    }

    public static BigDecimal getLength(Bereich_Objekt bereich) {
        Functions.Function1 _function = it -> new TopArea((Bereich_Objekt_Teilbereich_AttributeGroup)it);
        Functions.Function1 _function_1 = it -> it.topGUID;
        Functions.Function1 _function_2 = it -> BereichObjektExtensions.removeOverlaps(it);
        Functions.Function1 _function_3 = it -> it.length();
        Functions.Function2 _function_4 = (a, b) -> a.add((BigDecimal)b);
        return (BigDecimal)IterableExtensions.reduce((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)ListExtensions.map((List)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function2)_function_4);
    }

    public static TOP_Kante getTopKanteFor(Bereich_Objekt bereich, Collection<Punkt_Objekt_TOP_Kante_AttributeGroup> singlePoints) {
        boolean _notEquals;
        Functions.Function1 _function = e -> {
            Functions.Function1 _function_1 = it -> TopKanteExtensions.isConnectedTo(e, it);
            return IterableExtensions.exists((Iterable)singlePoints, (Functions.Function1)_function_1);
        };
        List topKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter(BereichObjektExtensions.getTopKanten(bereich), (Functions.Function1)_function));
        boolean _isEmpty = topKanten.isEmpty();
        if (_isEmpty) {
            return null;
        }
        int _size = topKanten.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("bereich=");
            String _debugString = Debug.debugString(bereich);
            _builder.append(_debugString);
            _builder.append(" punktObjekte=");
            Functions.Function1 _function_1 = it -> Debug.debugString(PunktObjektTopKanteExtensions.getPunktObjekt(it));
            Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.map(singlePoints, (Functions.Function1)_function_1));
            _builder.append((Object)_set);
            _builder.append(" topKanten=");
            String _debugString_1 = Debug.debugString(topKanten);
            _builder.append(_debugString_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return (TOP_Kante)topKanten.get(0);
    }

    public static boolean intersects(Bereich_Objekt bereich, Punkt_Objekt punktObjekt) {
        boolean _isEmpty = BereichObjektExtensions.intersection(bereich, punktObjekt).isEmpty();
        return !_isEmpty;
    }

    public static boolean intersects(Bereich_Objekt bereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt> path) {
        boolean _isEmpty = BereichObjektExtensions.intersection(bereich, path).isEmpty();
        return !_isEmpty;
    }

    public static boolean areaIntersects(Bereich_Objekt bereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        Functions.Function1 _function = it -> BereichObjektExtensions.areaIntersects(it, path);
        boolean result = IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            String _debugName = Debug.debugName(bereich);
            _builder.append(_debugName);
            _builder.append(" areaIntersects ");
            String _debugNodesAndEdges = Debug.debugNodesAndEdges(path);
            _builder.append(_debugNodesAndEdges);
            _builder.append(" = ");
            _builder.append((Object)result);
            logger.debug(_builder.toString());
        }
        return result;
    }

    public static boolean intersects(Bereich_Objekt bereich, Bereich_Objekt other) {
        Functions.Function1 _function = it -> BereichObjektExtensions.intersects(other, it);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersects(Bereich_Objekt bereich, Bereich_Objekt_Teilbereich_AttributeGroup teilbereich) {
        Functions.Function1 _function = it -> BereichObjektExtensions.intersects(it, teilbereich);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Bereich_Objekt_Teilbereich_AttributeGroup other) {
        String _wert_1;
        boolean _notEquals;
        String _wert = BereichObjektExtensions.getTopKante(teilbereich).getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = BereichObjektExtensions.getTopKante(other).getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        BigDecimal tA = teilbereich.getBegrenzungA().getWert();
        BigDecimal tB = teilbereich.getBegrenzungB().getWert();
        BigDecimal oA = other.getBegrenzungA().getWert();
        BigDecimal oB = other.getBegrenzungB().getWert();
        return BereichObjektExtensions.intersects(tA, tB, oA, oB);
    }

    protected static boolean intersects(BigDecimal a1, BigDecimal a2, BigDecimal b1, BigDecimal b2) {
        boolean _lessThan_1;
        boolean _lessThan;
        Distance distance = new Distance();
        int _compare = distance.compare(a1, a2);
        boolean _lessEqualsThan = _compare <= 0;
        Assert.isTrue((boolean)_lessEqualsThan);
        int _compare_1 = distance.compare(b1, b2);
        boolean _lessEqualsThan_1 = _compare_1 <= 0;
        Assert.isTrue((boolean)_lessEqualsThan_1);
        int _compare_2 = distance.compare(a2, b1);
        boolean bl = _lessThan = _compare_2 < 0;
        if (_lessThan) {
            return false;
        }
        int _compare_3 = distance.compare(b2, a1);
        boolean bl2 = _lessThan_1 = _compare_3 < 0;
        return !_lessThan_1;
    }

    public static boolean intersectsStrictly(Bereich_Objekt bereich, Bereich_Objekt other) {
        Functions.Function1 _function = it -> BereichObjektExtensions.intersectsStrictly(other, it);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersectsStrictly(Bereich_Objekt bereich, Bereich_Objekt_Teilbereich_AttributeGroup teilbereich) {
        Functions.Function1 _function = it -> BereichObjektExtensions.intersectsStrictly(it, teilbereich);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean intersectsStrictly(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Bereich_Objekt_Teilbereich_AttributeGroup other) {
        String _wert_1;
        boolean _notEquals;
        String _wert = BereichObjektExtensions.getTopKante(teilbereich).getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = BereichObjektExtensions.getTopKante(other).getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        Begrenzung_A_TypeClass _begrenzungA = null;
        if (teilbereich != null) {
            _begrenzungA = teilbereich.getBegrenzungA();
        }
        BigDecimal _wert_2 = null;
        if (_begrenzungA != null) {
            _wert_2 = _begrenzungA.getWert();
        }
        BigDecimal tA = _wert_2;
        Begrenzung_B_TypeClass _begrenzungB = null;
        if (teilbereich != null) {
            _begrenzungB = teilbereich.getBegrenzungB();
        }
        BigDecimal _wert_3 = null;
        if (_begrenzungB != null) {
            _wert_3 = _begrenzungB.getWert();
        }
        BigDecimal tB = _wert_3;
        Begrenzung_A_TypeClass _begrenzungA_1 = null;
        if (other != null) {
            _begrenzungA_1 = other.getBegrenzungA();
        }
        BigDecimal _wert_4 = null;
        if (_begrenzungA_1 != null) {
            _wert_4 = _begrenzungA_1.getWert();
        }
        BigDecimal oA = _wert_4;
        Begrenzung_B_TypeClass _begrenzungB_1 = null;
        if (other != null) {
            _begrenzungB_1 = other.getBegrenzungB();
        }
        BigDecimal _wert_5 = null;
        if (_begrenzungB_1 != null) {
            _wert_5 = _begrenzungB_1.getWert();
        }
        BigDecimal oB = _wert_5;
        return BereichObjektExtensions.intersectsStrictly(tA, tB, oA, oB);
    }

    protected static boolean intersectsStrictly(BigDecimal a1, BigDecimal a2, BigDecimal b1, BigDecimal b2) {
        Functions.Function1 _function = it -> it == null;
        boolean _exists = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new BigDecimal[]{a1, a2, b1, b2})), (Functions.Function1)_function);
        if (_exists) {
            return false;
        }
        Distance distance = new Distance();
        int _compare = distance.compare(a1, a2);
        boolean _lessEqualsThan = _compare <= 0;
        Assert.isTrue((boolean)_lessEqualsThan);
        int _compare_1 = distance.compare(b1, b2);
        boolean _lessEqualsThan_1 = _compare_1 <= 0;
        Assert.isTrue((boolean)_lessEqualsThan_1);
        int aEndBStart = distance.compare(a2, b1);
        if (aEndBStart < 0) {
            return false;
        }
        int bEndAStart = distance.compare(b2, a1);
        if (bEndAStart < 0) {
            return false;
        }
        if (aEndBStart == 0) {
            return bEndAStart == 0;
        }
        return true;
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(Bereich_Objekt bereich, Punkt_Objekt punktObjekt) {
        Functions.Function1 _function = it -> BereichObjektExtensions.contains(bereich, it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function));
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(Bereich_Objekt bereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt> path) {
        return BereichObjektExtensions.intersection(bereich, IteratorExtensions.toSet((Iterator)path.getPointIterator()));
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(Bereich_Objekt bereich, Set<Punkt_Objekt> punktObjekte) {
        Functions.Function1 _function = it -> PunktObjektExtensions.getSinglePoints(it);
        Functions.Function1 _function_1 = it -> BereichObjektExtensions.contains(bereich, it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(punktObjekte, (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static boolean contains(Bereich_Objekt bereich, Punkt_Objekt object) {
        Functions.Function1 _function = bo -> {
            Functions.Function1 _function_1 = it -> BereichObjektExtensions.contains(bo, it);
            return IterableExtensions.exists(PunktObjektExtensions.getSinglePoints(object), (Functions.Function1)_function_1);
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean contains(Bereich_Objekt bereich, Punkt_Objekt object, double tolerance) {
        if (tolerance == 1.0) {
            return BereichObjektExtensions.contains(bereich, object);
        }
        Functions.Function1 _function = bo -> {
            Functions.Function1 _function_1 = it -> BereichObjektExtensions.contains(bo, it, tolerance);
            return IterableExtensions.exists(PunktObjektExtensions.getSinglePoints(object), (Functions.Function1)_function_1);
        };
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean contains(Bereich_Objekt bereich, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        Functions.Function1 _function = it -> BereichObjektExtensions.contains(it, singlePoint);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean contains(Bereich_Objekt bereich, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, double tolerant) {
        Functions.Function1 _function = it -> BereichObjektExtensions.contains(it, singlePoint, tolerant);
        return IterableExtensions.exists((Iterable)bereich.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static boolean contains(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        ID_TOP_Kante_TypeClass _iDTOPKante = teilbereich.getIDTOPKante();
        String _wert = null;
        if (_iDTOPKante != null) {
            _wert = _iDTOPKante.getWert();
        }
        ID_TOP_Kante_TypeClass _iDTOPKante_1 = singlePoint.getIDTOPKante();
        String _wert_1 = null;
        if (_iDTOPKante_1 != null) {
            _wert_1 = _iDTOPKante_1.getWert();
        }
        boolean sameTopKante = Objects.equals(_wert, _wert_1);
        Distance distance = new Distance();
        if (sameTopKante) {
            boolean _greaterThan;
            BigDecimal B;
            BigDecimal A = teilbereich.getBegrenzungA().getWert();
            int _compare = distance.compare(A, B = teilbereich.getBegrenzungB().getWert());
            boolean bl = _greaterThan = _compare > 0;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Teilbereich with Begrenzungen A=");
                _builder.append((Object)A);
                _builder.append(" B=");
                _builder.append((Object)B);
                throw new IllegalArgumentException(_builder.toString());
            }
            BigDecimal abstand = singlePoint.getAbstand().getWert();
            return distance.compare(A, abstand) <= 0 && distance.compare(abstand, B) <= 0;
        }
        return false;
    }

    public static boolean contains(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, double tolerant) {
        boolean sameTopKante;
        BigDecimal tolerantBigDecimal = BigDecimal.valueOf(tolerant);
        ID_TOP_Kante_TypeClass _iDTOPKante = teilbereich.getIDTOPKante();
        TOP_Kante _value = null;
        if (_iDTOPKante != null) {
            _value = _iDTOPKante.getValue();
        }
        TOP_Kante teilBereichTopKante = _value;
        ID_TOP_Kante_TypeClass _iDTOPKante_1 = teilbereich.getIDTOPKante();
        String _wert = null;
        if (_iDTOPKante_1 != null) {
            _wert = _iDTOPKante_1.getWert();
        }
        ID_TOP_Kante_TypeClass _iDTOPKante_2 = singlePoint.getIDTOPKante();
        String _wert_1 = null;
        if (_iDTOPKante_2 != null) {
            _wert_1 = _iDTOPKante_2.getWert();
        }
        if (sameTopKante = Objects.equals(_wert, _wert_1)) {
            BigDecimal _laenge;
            BigDecimal _wert_4;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Bereich_Objekt_Teilbereich_AttributeGroup clone = (Bereich_Objekt_Teilbereich_AttributeGroup)EcoreUtil.copy((EObject)teilbereich);
            BigDecimal _wert_2 = teilbereich.getBegrenzungA().getWert();
            boolean bl = _tripleNotEquals = _wert_2 != BigDecimal.ZERO;
            if (_tripleNotEquals) {
                BigDecimal _wert_3 = teilbereich.getBegrenzungA().getWert();
                BigDecimal tolerantLimitA = _wert_3.subtract(tolerantBigDecimal);
                Begrenzung_A_TypeClass _begrenzungA = clone.getBegrenzungA();
                BigDecimal _xifexpression = null;
                boolean _lessEqualsThan = tolerantLimitA.compareTo(BigDecimal.ZERO) <= 0;
                _xifexpression = _lessEqualsThan ? BigDecimal.ZERO : tolerantLimitA;
                _begrenzungA.setWert(_xifexpression);
            }
            boolean bl2 = _tripleNotEquals_1 = (_wert_4 = teilbereich.getBegrenzungB().getWert()) != (_laenge = TopKanteExtensions.getLaenge(teilBereichTopKante));
            if (_tripleNotEquals_1) {
                BigDecimal _wert_5 = teilbereich.getBegrenzungB().getWert();
                BigDecimal tolerantLimitB = _wert_5.add(tolerantBigDecimal);
                Begrenzung_B_TypeClass _begrenzungB = clone.getBegrenzungB();
                BigDecimal _xifexpression_1 = null;
                BigDecimal _laenge_1 = TopKanteExtensions.getLaenge(teilBereichTopKante);
                boolean _greaterEqualsThan = tolerantLimitB.compareTo(_laenge_1) >= 0;
                _xifexpression_1 = _greaterEqualsThan ? TopKanteExtensions.getLaenge(teilBereichTopKante) : tolerantLimitB;
                _begrenzungB.setWert(_xifexpression_1);
            }
            boolean isContains = BereichObjektExtensions.contains(clone, singlePoint);
            if (clone.getBegrenzungA().getWert() == BigDecimal.ZERO && clone.getBegrenzungB().getWert() == TopKanteExtensions.getLaenge(teilBereichTopKante) && !isContains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The TOP_Kante: ");
                String _wert_6 = teilbereich.getIDTOPKante().getWert();
                _builder.append(_wert_6);
                _builder.append(" should contain the Punkt_Objekt: ");
                String _identitaet = PunktObjektTopKanteExtensions.getIdentitaet(singlePoint);
                _builder.append(_identitaet);
                throw new IllegalArgumentException(_builder.toString());
            }
            return isContains;
        }
        Functions.Function1 _function = it -> {
            TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
            return it != _topKante;
        };
        boolean _forall = IterableExtensions.forall(TopKanteExtensions.getAdjacentTopKanten(teilBereichTopKante), (Functions.Function1)_function);
        if (_forall) {
            return false;
        }
        BigDecimal A = teilbereich.getBegrenzungA().getWert();
        BigDecimal B = teilbereich.getBegrenzungB().getWert();
        Range topKanteRange = Range.of((Comparable)BigDecimal.ZERO, (Comparable)TopKanteExtensions.getLaenge(teilBereichTopKante));
        if (topKanteRange.contains((Object)A.subtract(tolerantBigDecimal)) && topKanteRange.contains((Object)B.add(tolerantBigDecimal))) {
            return false;
        }
        BigDecimal _xifexpression_2 = null;
        boolean _isStartedBy = topKanteRange.isStartedBy((Object)A);
        _xifexpression_2 = _isStartedBy ? tolerantBigDecimal : tolerantBigDecimal.subtract(A);
        BigDecimal tolerantDistanceFromA = _xifexpression_2;
        BigDecimal _xifexpression_3 = null;
        boolean _isEndedBy = topKanteRange.isEndedBy((Object)B);
        if (_isEndedBy) {
            _xifexpression_3 = tolerantBigDecimal;
        } else {
            BigDecimal _plus = tolerantBigDecimal.add(B);
            BigDecimal _maximum = (BigDecimal)topKanteRange.getMaximum();
            _xifexpression_3 = _plus.subtract(_maximum);
        }
        BigDecimal tolerantDistanceFromB = _xifexpression_3;
        return BereichObjektExtensions.containsWithinTolerant(teilbereich, singlePoint, TopKanteExtensions.getTOPKnotenA(teilBereichTopKante), tolerantDistanceFromA) || BereichObjektExtensions.containsWithinTolerant(teilbereich, singlePoint, TopKanteExtensions.getTOPKnotenB(teilBereichTopKante), tolerantDistanceFromB);
    }

    private static boolean containsWithinTolerant(Bereich_Objekt_Teilbereich_AttributeGroup botb, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, TOP_Knoten topKnote, BigDecimal tolerant) {
        Functions.Function1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _and = false;
            TOP_Kante _topKante = BereichObjektExtensions.getTopKante(botb);
            boolean bl = _tripleNotEquals = it != _topKante;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _tripleEquals;
                ID_TOP_Kante_TypeClass _iDTOPKante = singlePoint.getIDTOPKante();
                TOP_Kante _value = null;
                if (_iDTOPKante != null) {
                    _value = _iDTOPKante.getValue();
                }
                _and = _tripleEquals = it == _value;
            }
            return _and;
        };
        TOP_Kante targetTopKante = (TOP_Kante)IterableExtensions.findFirst(TopKnotenExtensions.getTopKanten(topKnote), (Functions.Function1)_function);
        return targetTopKante != null && TopKanteExtensions.getAbstand(targetTopKante, topKnote, singlePoint).compareTo(tolerant) <= 0;
    }

    public static BigDecimal getLength(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        BigDecimal _wert = portion.getBegrenzungB().getWert();
        BigDecimal _wert_1 = portion.getBegrenzungA().getWert();
        return _wert.subtract(_wert_1);
    }

    public static TOP_Kante getTopKante(Bereich_Objekt_Teilbereich_AttributeGroup portion) {
        ID_TOP_Kante_TypeClass _iDTOPKante = portion.getIDTOPKante();
        TOP_Kante _value = null;
        if (_iDTOPKante != null) {
            _value = _iDTOPKante.getValue();
        }
        return _value;
    }

    public static <T extends Punkt_Objekt> List<T> filterContained(Bereich_Objekt bereich, Iterable<T> punktObjekte) {
        Functions.Function1 _function = it -> BereichObjektExtensions.intersects(bereich, it);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(punktObjekte, (Functions.Function1)_function));
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        List edges = path.getEdgeList();
        int size = edges.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return BereichObjektExtensions.areaIntersects(teilbereich, (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart(), (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)edges.get(0)), (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd());
        }
        Functions.Function1 _function = it -> it != IterableExtensions.head((Iterable)edges) && it != IterableExtensions.lastOrNull((Iterable)edges);
        Iterable middleEdges = IterableExtensions.filter((Iterable)edges, (Functions.Function1)_function);
        return BereichObjektExtensions.areaIntersects(teilbereich, (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart(), (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)IterableExtensions.head((Iterable)edges))) || BereichObjektExtensions.areaIntersects(teilbereich, (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)((DirectedEdge)IterableExtensions.lastOrNull((Iterable)edges)), (Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd()) || IterableExtensions.exists((Iterable)middleEdges, it -> BereichObjektExtensions.areaIntersects(teilbereich, (DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)it));
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        String _wert_1;
        boolean _notEquals;
        TOP_Kante tTopKante = BereichObjektExtensions.getTopKante(teilbereich);
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = tTopKante.getIdentitaet().getWert();
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = eTopKante.getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        BigDecimal tA = teilbereich.getBegrenzungA().getWert();
        BigDecimal tB = teilbereich.getBegrenzungB().getWert();
        Assert.isNotNull((Object)start);
        Assert.isNotNull((Object)end);
        BigDecimal aStart = TopKanteExtensions.getAbstand(eTopKante, start);
        BigDecimal aEnd = TopKanteExtensions.getAbstand(eTopKante, end);
        BigDecimal eA = aStart.min(aEnd);
        BigDecimal eB = aStart.max(aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        boolean _not;
        String _wert_1;
        boolean _notEquals;
        ID_TOP_Kante_TypeClass tTopKante = teilbereich.getIDTOPKante();
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = null;
        if (tTopKante != null) {
            _wert = tTopKante.getWert();
        }
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = eTopKante.getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        BigDecimal tA = teilbereich.getBegrenzungA().getWert();
        BigDecimal tB = teilbereich.getBegrenzungB().getWert();
        Assert.isNotNull((Object)start);
        BigDecimal aStart = TopKanteExtensions.getAbstand(eTopKante, start);
        BigDecimal aEnd = TopKanteExtensions.getLaenge(eTopKante);
        boolean _isForwards = edge.isForwards();
        boolean bl2 = _not = !_isForwards;
        if (_not) {
            aEnd = BigDecimal.ZERO;
        }
        BigDecimal eA = aStart.min(aEnd);
        BigDecimal eB = aStart.max(aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        boolean _not;
        String _wert_1;
        boolean _notEquals;
        ID_TOP_Kante_TypeClass tTopKante = teilbereich.getIDTOPKante();
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = null;
        if (tTopKante != null) {
            _wert = tTopKante.getWert();
        }
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = eTopKante.getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        BigDecimal tA = teilbereich.getBegrenzungA().getWert();
        BigDecimal tB = teilbereich.getBegrenzungB().getWert();
        Assert.isNotNull((Object)end);
        BigDecimal aStart = BigDecimal.ZERO;
        boolean _isForwards = edge.isForwards();
        boolean bl2 = _not = !_isForwards;
        if (_not) {
            aStart = TopKanteExtensions.getLaenge(eTopKante);
        }
        BigDecimal aEnd = TopKanteExtensions.getAbstand(eTopKante, end);
        BigDecimal eA = aStart.min(aEnd);
        BigDecimal eB = aStart.max(aEnd);
        return BereichObjektExtensions.intersects(tA, tB, eA, eB);
    }

    private static boolean areaIntersects(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        ID_TOP_Kante_TypeClass tTopKante = teilbereich.getIDTOPKante();
        TOP_Kante eTopKante = (TOP_Kante)edge.getElement();
        String _wert = null;
        if (tTopKante != null) {
            _wert = tTopKante.getWert();
        }
        String _wert_1 = eTopKante.getIdentitaet().getWert();
        return Objects.equals(_wert, _wert_1);
    }

    public static boolean contains(Bereich_Objekt_Teilbereich_AttributeGroup teilbereich, TOP_Kante topKante, double distance) {
        String _wert_1;
        boolean _notEquals;
        ID_TOP_Kante_TypeClass _iDTOPKante = teilbereich.getIDTOPKante();
        String _wert = null;
        if (_iDTOPKante != null) {
            _wert = _iDTOPKante.getWert();
        }
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1 = topKante.getIdentitaet().getWert());
        if (_notEquals) {
            return false;
        }
        Distance comparator = new Distance();
        BigDecimal A = teilbereich.getBegrenzungA().getWert();
        BigDecimal B = teilbereich.getBegrenzungB().getWert();
        BigDecimal toBigDecimal = BigDecimal.valueOf(distance);
        return comparator.compare(A, toBigDecimal) <= 0 && comparator.compare(toBigDecimal, B) <= 0;
    }

    public static BigDecimal getOverlappingLength(Bereich_Objekt bo, Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        if (bo == null || tb == null) {
            return BigDecimal.ZERO;
        }
        Functions.Function1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _and = false;
            Begrenzung_A_TypeClass _begrenzungA = it.getBegrenzungA();
            BigDecimal _wert = null;
            if (_begrenzungA != null) {
                _wert = _begrenzungA.getWert();
            }
            boolean bl = _tripleNotEquals = _wert != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _tripleNotEquals_1;
                Begrenzung_B_TypeClass _begrenzungB = it.getBegrenzungB();
                BigDecimal _wert_1 = null;
                if (_begrenzungB != null) {
                    _wert_1 = _begrenzungB.getWert();
                }
                _and = _tripleNotEquals_1 = _wert_1 != null;
            }
            return _and;
        };
        Functions.Function1 _function_1 = it -> new TopArea((Bereich_Objekt_Teilbereich_AttributeGroup)it);
        List tb1 = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        TopArea tb2 = new TopArea(tb);
        Functions.Function1 _function_2 = it -> it.topGUID;
        Functions.Function1 _function_3 = it -> BereichObjektExtensions.removeOverlaps(it);
        Iterable noOverlap1 = IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)tb1, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3);
        BigDecimal _elvis = null;
        Functions.Function1 _function_4 = it -> it.getOverlappingLength(tb2);
        Functions.Function2 _function_5 = (a, b) -> a.add((BigDecimal)b);
        BigDecimal _reduce = (BigDecimal)IterableExtensions.reduce((Iterable)IterableExtensions.map((Iterable)noOverlap1, (Functions.Function1)_function_4), (Functions.Function2)_function_5);
        _elvis = _reduce != null ? _reduce : BigDecimal.ZERO;
        return _elvis;
    }

    public static BigDecimal getOverlappingLength(Bereich_Objekt bo, Bereich_Objekt bo2) {
        if (bo == null || bo2 == null) {
            return BigDecimal.ZERO;
        }
        Functions.Function1 _function = it -> new TopArea((Bereich_Objekt_Teilbereich_AttributeGroup)it);
        List tb1 = IterableExtensions.toList((Iterable)ListExtensions.map((List)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> new TopArea((Bereich_Objekt_Teilbereich_AttributeGroup)it);
        List tb2 = IterableExtensions.toList((Iterable)ListExtensions.map((List)bo2.getBereichObjektTeilbereich(), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> it.topGUID;
        Functions.Function1 _function_3 = it -> BereichObjektExtensions.removeOverlaps(it);
        Iterable noOverlap1 = IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)tb1, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = it -> it.topGUID;
        Functions.Function1 _function_5 = it -> BereichObjektExtensions.removeOverlaps(it);
        Iterable noOverlap2 = IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)tb2, (Functions.Function1)_function_4).values(), (Functions.Function1)_function_5);
        BigDecimal _elvis = null;
        Functions.Function1 _function_6 = tb -> {
            Functions.Function1 _function_7 = it -> tb.getOverlappingLength((TopArea)it);
            return IterableExtensions.map((Iterable)noOverlap2, (Functions.Function1)_function_7);
        };
        Functions.Function2 _function_7 = (a, b) -> a.add((BigDecimal)b);
        BigDecimal _reduce = (BigDecimal)IterableExtensions.reduce((Iterable)IterableExtensions.flatMap((Iterable)noOverlap1, (Functions.Function1)_function_6), (Functions.Function2)_function_7);
        _elvis = _reduce != null ? _reduce : BigDecimal.ZERO;
        return _elvis;
    }

    private static List<TopArea> removeOverlaps(List<TopArea> areas) {
        BigDecimal current = BigDecimal.ZERO;
        Functions.Function1 _function = it -> it.start;
        List _sortBy = IterableExtensions.sortBy(areas, (Functions.Function1)_function);
        for (TopArea area : _sortBy) {
            boolean _lessThan;
            if (area.start.compareTo(BigDecimal.ZERO) < 0 || area.end.compareTo(BigDecimal.ZERO) < 0) continue;
            boolean bl = _lessThan = area.start.compareTo(current) < 0;
            if (_lessThan) {
                area.start = current;
            }
            current = area.end;
        }
        return areas;
    }

    public static Stell_Bereich getMostOverlapControlArea(Bereich_Objekt bo) {
        Iterable areas = BasisAttributExtensions.getContainer((EObject)bo).getStellBereich();
        Comparator _function = (first, second) -> {
            BigDecimal firstDistance = BereichObjektExtensions.getOverlappingLength(bo, (Bereich_Objekt)first);
            BigDecimal secondDistance = BereichObjektExtensions.getOverlappingLength(bo, (Bereich_Objekt)second);
            return firstDistance.compareTo(secondDistance);
        };
        return (Stell_Bereich)IterableExtensions.max((Iterable)areas, (Comparator)_function);
    }

    public static List<List<TopPoint>> toTopPoints(Bereich_Objekt bo) {
        Functions.Function1 _function = it -> BereichObjektExtensions.toTopPoints(it);
        return ListExtensions.map((List)bo.getBereichObjektTeilbereich(), (Functions.Function1)_function);
    }

    public static List<TopPoint> toTopPoints(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        TOP_Kante _topKante = BereichObjektExtensions.getTopKante(tb);
        BigDecimal _wert = tb.getBegrenzungA().getWert();
        TopPoint _topPoint = new TopPoint(_topKante, _wert);
        TOP_Kante _topKante_1 = BereichObjektExtensions.getTopKante(tb);
        BigDecimal _wert_1 = tb.getBegrenzungB().getWert();
        TopPoint _topPoint_1 = new TopPoint(_topKante_1, _wert_1);
        return List.of(_topPoint, _topPoint_1);
    }

    private static class TopArea {
        private String topGUID;
        private BigDecimal start;
        private BigDecimal end;

        public TopArea(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
            boolean _tripleEquals;
            ID_TOP_Kante_TypeClass _iDTOPKante = null;
            if (tb != null) {
                _iDTOPKante = tb.getIDTOPKante();
            }
            String _wert = null;
            if (_iDTOPKante != null) {
                _wert = _iDTOPKante.getWert();
            }
            this.topGUID = _wert;
            boolean _or = false;
            Begrenzung_A_TypeClass _begrenzungA = null;
            if (tb != null) {
                _begrenzungA = tb.getBegrenzungA();
            }
            BigDecimal _wert_1 = null;
            if (_begrenzungA != null) {
                _wert_1 = _begrenzungA.getWert();
            }
            boolean bl = _tripleEquals = _wert_1 == null;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _tripleEquals_1;
                Begrenzung_B_TypeClass _begrenzungB = null;
                if (tb != null) {
                    _begrenzungB = tb.getBegrenzungB();
                }
                BigDecimal _wert_2 = null;
                if (_begrenzungB != null) {
                    _wert_2 = _begrenzungB.getWert();
                }
                _or = _tripleEquals_1 = _wert_2 == null;
            }
            if (_or) {
                this.start = BigDecimal.valueOf(-1L);
                this.end = BigDecimal.valueOf(-1L);
            } else {
                boolean _lessEqualsThan;
                Begrenzung_A_TypeClass _begrenzungA_1 = null;
                if (tb != null) {
                    _begrenzungA_1 = tb.getBegrenzungA();
                }
                BigDecimal _wert_3 = null;
                if (_begrenzungA_1 != null) {
                    _wert_3 = _begrenzungA_1.getWert();
                }
                Begrenzung_B_TypeClass _begrenzungB_1 = null;
                if (tb != null) {
                    _begrenzungB_1 = tb.getBegrenzungB();
                }
                BigDecimal _wert_4 = null;
                if (_begrenzungB_1 != null) {
                    _wert_4 = _begrenzungB_1.getWert();
                }
                boolean bl2 = _lessEqualsThan = _wert_3.compareTo(_wert_4) <= 0;
                if (_lessEqualsThan) {
                    Begrenzung_A_TypeClass _begrenzungA_2 = null;
                    if (tb != null) {
                        _begrenzungA_2 = tb.getBegrenzungA();
                    }
                    BigDecimal _wert_5 = null;
                    if (_begrenzungA_2 != null) {
                        _wert_5 = _begrenzungA_2.getWert();
                    }
                    this.start = _wert_5;
                    Begrenzung_B_TypeClass _begrenzungB_2 = null;
                    if (tb != null) {
                        _begrenzungB_2 = tb.getBegrenzungB();
                    }
                    BigDecimal _wert_6 = null;
                    if (_begrenzungB_2 != null) {
                        _wert_6 = _begrenzungB_2.getWert();
                    }
                    this.end = _wert_6;
                } else {
                    Begrenzung_A_TypeClass _begrenzungA_3 = null;
                    if (tb != null) {
                        _begrenzungA_3 = tb.getBegrenzungA();
                    }
                    BigDecimal _wert_7 = null;
                    if (_begrenzungA_3 != null) {
                        _wert_7 = _begrenzungA_3.getWert();
                    }
                    this.end = _wert_7;
                    Begrenzung_B_TypeClass _begrenzungB_3 = null;
                    if (tb != null) {
                        _begrenzungB_3 = tb.getBegrenzungB();
                    }
                    BigDecimal _wert_8 = null;
                    if (_begrenzungB_3 != null) {
                        _wert_8 = _begrenzungB_3.getWert();
                    }
                    this.start = _wert_8;
                }
            }
        }

        public BigDecimal length() {
            return this.end.subtract(this.start);
        }

        public BigDecimal getOverlappingLength(TopArea other) {
            boolean _lessEqualsThan_1;
            boolean _lessThan;
            if (!Objects.equals(this.topGUID, other.topGUID) || this.start.compareTo(BigDecimal.ZERO) < 0 || this.end.compareTo(BigDecimal.ZERO) < 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal end = this.end.min(other.end);
            boolean bl = _lessThan = this.start.compareTo(other.start) < 0;
            if (_lessThan) {
                boolean _lessEqualsThan;
                boolean bl2 = _lessEqualsThan = this.end.compareTo(other.start) <= 0;
                if (_lessEqualsThan) {
                    return BigDecimal.ZERO;
                }
                return end.subtract(other.start);
            }
            boolean bl3 = _lessEqualsThan_1 = other.end.compareTo(this.start) <= 0;
            if (_lessEqualsThan_1) {
                return BigDecimal.ZERO;
            }
            return end.subtract(this.start);
        }
    }
}

