/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.radiocontrol;

import jakarta.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.exceptions.NoEnumTranslationFound;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioControlRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RadioControlRenderer.class);
    private final EnumTranslationService translationService = Services.getToolboxViewModelService().getTranslationService();
    SelectObservableValue<Enumerator> selectedRadioButtonObservable;

    @Inject
    public RadioControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding binding = this.getDataBindingContext().bindValue(this.selectedRadioButtonObservable, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy()), null);
        return new Binding[]{binding};
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        Composite radioGroup = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(radioGroup);
        IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EEnum eEnum = (EEnum)EEnum.class.cast(structuralFeature.getEType());
        this.selectedRadioButtonObservable = new SelectObservableValue();
        for (EEnumLiteral literal : eEnum.getELiterals()) {
            Button button = new Button(radioGroup, 16);
            try {
                button.setText(this.translationService.translate((Enumerator)literal).getPresentation());
            }
            catch (NoEnumTranslationFound e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                button.setText(literal.getName());
            }
            ISWTObservableValue observe = WidgetProperties.buttonSelection().observe((Widget)button);
            this.selectedRadioButtonObservable.addOption((Object)literal.getInstance(), (IObservableValue)observe);
        }
        return radioGroup;
    }

    protected String getUnsetText() {
        return null;
    }
}

