/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.pdf.PdfRendererService;
import org.eclipse.set.core.services.pdf.PdfViewer;
import org.eclipse.set.feature.export.Messages;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.RefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TitleBoxPdfPart
extends BasePart
implements PdfViewer.SaveListener {
    private static final String TITLEBOX_PDF = "titlebox.pdf";
    @Inject
    private ExportService exportService;
    @Inject
    private PdfRendererService rendererService;
    private PdfViewer viewer;
    @Inject
    @Translation
    Messages messages;

    @Inject
    public TitleBoxPdfPart() {
    }

    protected void createView(Composite parent) {
        this.createTitleboxPdfMonitor();
        this.createTitlebox(parent);
    }

    private void createTitleboxPdfMonitor() {
        try {
            if (this.getModelSession() != null) {
                IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(TitleBoxPdfPart.this.messages.TitleBoxPdfPart_LoadTitlebox, -1);
                            TitleBoxPdfPart.this.createTitleboxPdf();
                            monitor.done();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                new ProgressMonitorDialog(this.getToolboxShell()).run(true, false, runnableWithProgress);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAttachmentPath(String guid) {
        try {
            return this.getModelSession().getToolboxFile().getMediaPath(Guid.create((String)guid));
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    void createTitleboxPdf() throws Exception {
        PlanProToTitleboxTransformation planProToTitlebox = new PlanProToTitleboxTransformation(this.getSessionService());
        Titlebox titlebox = planProToTitlebox.transform(null, this::getAttachmentPath);
        this.exportService.exportTitleboxPdf(titlebox, this.getTitleBoxPath(), OverwriteHandling.forCheckbox((boolean)true), (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
    }

    private void createTitlebox(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = this.rendererService.createViewer(parent);
        this.viewer.show(this.getTitleBoxPath());
        this.viewer.setSaveListener((PdfViewer.SaveListener)this);
    }

    private Path getTitleBoxPath() {
        String tmpDir = this.getModelSession().getTempDir().toString();
        return Paths.get(tmpDir, TITLEBOX_PDF);
    }

    protected SelectableAction getOutdatedAction() {
        return new RefreshAction((BasePart)this, e -> this.updatePdfView());
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        if (this.isOutdated()) {
            this.updatePdfView();
        }
    }

    void updatePdfView() {
        this.createTitleboxPdfMonitor();
        this.viewer.refresh();
        this.setOutdated(false);
    }

    public Optional<Path> saveFile(String filename) {
        Shell shell = this.getToolboxShell();
        Path location = this.getModelSession().getToolboxFile().getPath();
        Path parent = location.getParent();
        String defaultPath = parent == null ? "" : parent.toString();
        String defaultFileName = String.format(filename, PathExtensions.getBaseFileName((Path)location));
        return this.getDialogService().saveFileDialog(shell, this.getDialogService().getDokumentFileFilters(), Paths.get(defaultPath, defaultFileName));
    }

    public void saveCompleted(Path path) {
        this.getDialogService().reportSavedFile(this.getToolboxShell(), path);
    }
}

