/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Kommentar_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareFootnoteContainer;
import org.eclipse.set.model.tablemodel.FootnoteContainer;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.SimpleFootnoteContainer;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.TablemodelPackage;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TableExtensions {
    public static final String FOOTNOTE_SEPARATOR = "; ";

    public static Table create(String root, String ... columnLabels) {
        Table newTable = TablemodelFactory.eINSTANCE.createTable();
        TableContent newTableContent = TablemodelFactory.eINSTANCE.createTableContent();
        newTable.setTablecontent(newTableContent);
        ColumnDescriptor rootDescriptor = TableExtensions.toDescriptor(root, null);
        newTable.getColumndescriptors().add((Object)rootDescriptor);
        Functions.Function1 _function = it -> TableExtensions.toDescriptor(it, rootDescriptor);
        newTable.getColumndescriptors().addAll((Collection)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)columnLabels)), (Functions.Function1)_function));
        return newTable;
    }

    private static ColumnDescriptor toDescriptor(String columnLabel, ColumnDescriptor parent) {
        ColumnDescriptor descriptor = TablemodelFactory.eINSTANCE.createColumnDescriptor();
        descriptor.setLabel(columnLabel);
        descriptor.setParent(parent);
        return descriptor;
    }

    public static List<ColumnDescriptor> getColumns(Table table) {
        EList descriptors = table.getColumndescriptors();
        boolean _isEmpty = descriptors.isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.newLinkedList();
        }
        return ColumnDescriptorExtensions.getColumns((ColumnDescriptor)descriptors.get(0));
    }

    public static List<TableRow> getTableRows(Table table) {
        TableContent content;
        TableContent _tablecontent = null;
        if (table != null) {
            _tablecontent = table.getTablecontent();
        }
        if ((content = _tablecontent) == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        LinkedList rows = CollectionLiterals.newLinkedList();
        EList _rowgroups = content.getRowgroups();
        for (RowGroup rowgroup : _rowgroups) {
            rows.addAll(rowgroup.getRows());
        }
        return rows;
    }

    public static int getPropertyCount(Table table) {
        return TableExtensions.getColumns(table).size();
    }

    public static ColumnDescriptor getRootDescriptor(Table table) {
        boolean _isEmpty = table.getColumndescriptors().isEmpty();
        if (_isEmpty) {
            return null;
        }
        return ColumnDescriptorExtensions.getRoot((ColumnDescriptor)table.getColumndescriptors().get(0));
    }

    public static TableRow addRow(Ur_Objekt leadingObject, Table table, String ... values) {
        return TableExtensions.addRow(leadingObject, 0, table, values);
    }

    public static TableRow addRow(Ur_Objekt leadingObject, int leadingObjectIndex, Table table, String ... values) {
        RowGroup newRowGroup = TablemodelFactory.eINSTANCE.createRowGroup();
        TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
        newRowGroup.getRows().add((Object)newRow);
        newRowGroup.setLeadingObject(leadingObject);
        newRowGroup.setLeadingObjectIndex(leadingObjectIndex);
        table.getTablecontent().getRowgroups().add((Object)newRowGroup);
        Consumer<ColumnDescriptor> _function = it -> newRow.getCells().add((Object)ColumnDescriptorExtensions.createTableCell(it));
        TableExtensions.getColumns(table).forEach(_function);
        Consumer<Pair> _function_1 = it -> TableRowExtensions.set(newRow, (Integer)it.getKey(), (String)it.getValue());
        org.eclipse.xtext.xbase.lib.IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)values))).forEach(_function_1);
        return newRow;
    }

    public static void addRowGroup(Table table, RowGroup groupToAdd) {
        boolean _tripleEquals;
        RowGroup clone = (RowGroup)EcoreUtil.copy((EObject)groupToAdd);
        TableContent _tablecontent = table.getTablecontent();
        boolean bl = _tripleEquals = _tablecontent == null;
        if (_tripleEquals) {
            TableContent tableContent = TablemodelFactory.eINSTANCE.createTableContent();
            TableContentExtensions.addRowGroup(tableContent, clone);
            table.setTablecontent(tableContent);
            return;
        }
        Ur_Objekt leadingObject = groupToAdd.getLeadingObject();
        if (leadingObject != null && org.eclipse.xtext.xbase.lib.IterableExtensions.forall((Iterable)table.getTablecontent().getRowgroups(), it -> leadingObject != null)) {
            boolean _not;
            Functions.Function1 _function = it -> {
                Ur_Objekt _leadingObject = it.getLeadingObject();
                Identitaet_TypeClass _identitaet = null;
                if (_leadingObject != null) {
                    _identitaet = _leadingObject.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (leadingObject != null) {
                    _identitaet_1 = leadingObject.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                return _wert.equals(_wert_1);
            };
            boolean _exists = org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function);
            boolean bl2 = _not = !_exists;
            if (_not) {
                TableContentExtensions.addRowGroup(table.getTablecontent(), clone);
            }
            return;
        }
        Functions.Function1 _function_1 = it -> it.getLabel();
        List cloumnLabels = ListExtensions.map((List)table.getColumndescriptors(), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = row -> {
            Functions.Function1 _function_3 = column -> TableRowExtensions.getPlainStringValue(row, column);
            return org.eclipse.xtext.xbase.lib.IterableExtensions.join((Iterable)ListExtensions.map((List)cloumnLabels, (Functions.Function1)_function_3), (CharSequence)"");
        };
        List mapRowToAdd = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)ListExtensions.map((List)clone.getRows(), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> it.getRows().size() == groupToAdd.getRows().size() && org.eclipse.xtext.xbase.lib.IterableExtensions.forall((Iterable)it.getRows(), row -> {
            boolean _xblockexpression = false;
            Functions.Function1 _function_4 = column -> TableRowExtensions.getPlainStringValue(row, column);
            String plainString = org.eclipse.xtext.xbase.lib.IterableExtensions.join((Iterable)ListExtensions.map((List)cloumnLabels, (Functions.Function1)_function_4), (CharSequence)"");
            Functions.Function1 _function_5 = rowToAddString -> rowToAddString.equals(plainString);
            _xblockexpression = org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)mapRowToAdd, (Functions.Function1)_function_5);
            return _xblockexpression;
        });
        boolean alreadyExistsRowContent = org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function_3);
        if (!alreadyExistsRowContent) {
            TableContentExtensions.addRowGroup(table.getTablecontent(), clone);
        }
    }

    public static void set(Table table, int row, String columnLabel, String value) {
        TableRowExtensions.set(TableExtensions.getTableRows(table).get(row), columnLabel, value);
    }

    public static String getPlainStringValue(Table table, int row, String columnLabel) {
        return TableRowExtensions.getPlainStringValue(TableExtensions.getTableRows(table).get(row), columnLabel);
    }

    public static String getPlainStringValue(Table table, int row, int column) {
        return TableRowExtensions.getPlainStringValue(TableExtensions.getTableRows(table).get(row), column);
    }

    public static String toDebugString(Table table, int columnWidth) {
        StringConcatenation _builder = new StringConcatenation();
        String _paddedString = StringExtensions.toPaddedString((String)"Row", (int)3);
        _builder.append(_paddedString);
        _builder.append(" ");
        String _paddedString_1 = StringExtensions.toPaddedString((String)"Id", (int)columnWidth);
        _builder.append(_paddedString_1);
        _builder.append(" ");
        String _simpleString = TableExtensions.toSimpleString(TableExtensions.getColumns(table), columnWidth);
        _builder.append(_simpleString);
        _builder.newLineIfNotEmpty();
        List<TableRow> rows = TableExtensions.getTableRows(table);
        _builder.newLineIfNotEmpty();
        for (TableRow row : rows) {
            int _indexOf = rows.indexOf(row);
            int _plus = _indexOf + 1;
            String _debugString = TableRowExtensions.toDebugString(row, _plus, columnWidth);
            _builder.append(_debugString);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public static boolean isEqual(Table table, Table other) {
        return TableExtensions.hasEqualDescriptors(table, other) && TableContentExtensions.isEqual(table.getTablecontent(), other.getTablecontent());
    }

    public static boolean hasEqualDescriptors(Table table, Table other) {
        int _size_1;
        boolean _notEquals;
        int _size = table.getColumndescriptors().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getColumndescriptors().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isEqual((ColumnDescriptor)it.getValue(), (ColumnDescriptor)other.getColumndescriptors().get(((Integer)it.getKey()).intValue()));
        return org.eclipse.xtext.xbase.lib.IterableExtensions.forall((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.indexed((Iterable)table.getColumndescriptors()), (Functions.Function1)_function);
    }

    public static TableRow getMatchingRow(Table table, TableRow row) {
        TableRow _xblockexpression = null;
        RowGroup group = TableRowExtensions.getGroup(row);
        int rowIndex = group.getRows().indexOf((Object)row);
        RowGroup _groupByLeadingObject = TableExtensions.getGroupByLeadingObject(table, group.getLeadingObject(), group.getLeadingObjectIndex());
        EList _rows = null;
        if (_groupByLeadingObject != null) {
            _rows = _groupByLeadingObject.getRows();
        }
        Optional _indexOutBoundableObject = null;
        if (_rows != null) {
            _indexOutBoundableObject = EObjectExtensions.getIndexOutBoundableObject((List)_rows, (int)rowIndex);
        }
        TableRow _orElse = null;
        if (_indexOutBoundableObject != null) {
            _orElse = _indexOutBoundableObject.orElse(null);
        }
        _xblockexpression = _orElse;
        return _xblockexpression;
    }

    public static RowGroup getGroupByLeadingObject(Table table, Ur_Objekt object, int index) {
        Functions.Function1 _function = it -> {
            int _leadingObjectIndex;
            boolean _tripleEquals;
            boolean _equals;
            boolean _and = false;
            Ur_Objekt _leadingObject = it.getLeadingObject();
            Identitaet_TypeClass _identitaet = null;
            if (_leadingObject != null) {
                _identitaet = _leadingObject.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            Identitaet_TypeClass _identitaet_1 = null;
            if (object != null) {
                _identitaet_1 = object.getIdentitaet();
            }
            String _wert_1 = null;
            if (_identitaet_1 != null) {
                _wert_1 = _identitaet_1.getWert();
            }
            _and = !(_equals = Objects.equals(_wert, _wert_1)) ? false : (_tripleEquals = (_leadingObjectIndex = it.getLeadingObjectIndex()) == index);
            return _and;
        };
        return (RowGroup)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function);
    }

    public static RowGroup getGroupById(Table table, String groupId, int index) {
        Functions.Function1 _function = it -> {
            int _leadingObjectIndex;
            boolean _tripleEquals;
            boolean _equals;
            boolean _and = false;
            Ur_Objekt _leadingObject = it.getLeadingObject();
            Identitaet_TypeClass _identitaet = null;
            if (_leadingObject != null) {
                _identitaet = _leadingObject.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            _and = !(_equals = Objects.equals(_wert, groupId)) ? false : (_tripleEquals = (_leadingObjectIndex = it.getLeadingObjectIndex()) == index);
            return _and;
        };
        return (RowGroup)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function);
    }

    public static void setTextAlignment(Table table, int columnIdx, TextAlignment textAlignment) {
        Consumer<RowGroup> _function = it -> RowGroupExtensions.setTextAlignment(it, columnIdx, textAlignment);
        table.getTablecontent().getRowgroups().forEach(_function);
    }

    public static void save(Table table, Path filepath) throws IOException {
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        extensionToFactoryMap.put("tm", _xMIResourceFactoryImpl);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)filepath.toString()));
        resource.getContents().add((Object)table);
        resource.save(Collections.EMPTY_MAP);
    }

    public static Table load(Path filepath) {
        TablemodelPackage.eINSTANCE.eClass();
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        extensionToFactoryMap.put("tm", _xMIResourceFactoryImpl);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createURI((String)filepath.toString()), true);
        EObject _get = (EObject)resource.getContents().get(0);
        return (Table)_get;
    }

    private static String toSimpleString(List<ColumnDescriptor> descriptors, int columnWidth) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (ColumnDescriptor descriptor : descriptors) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _paddedString = StringExtensions.toPaddedString((String)descriptor.getLabel(), (int)columnWidth);
            _builder.append(_paddedString);
        }
        return _builder.toString();
    }

    public static int getLeadingObjectRowIndexByGUID(Table table, String guid) {
        int rowIndex = 0;
        EList _rowgroups = table.getTablecontent().getRowgroups();
        for (RowGroup rowGroup : _rowgroups) {
            boolean _equals;
            Ur_Objekt _leadingObject = rowGroup.getLeadingObject();
            Identitaet_TypeClass _identitaet = null;
            if (_leadingObject != null) {
                _identitaet = _leadingObject.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (_equals = Objects.equals(_wert, guid)) {
                return rowIndex;
            }
            int _rowIndex = rowIndex;
            int _size = rowGroup.getRows().size();
            rowIndex = _rowIndex + _size;
        }
        return -1;
    }

    public static Iterable<FootnoteInfo> getAllFootnotes(Table table) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> new FootnoteInfo((Bearbeitungsvermerk)it_1, FootnoteType.COMMON_FOOTNOTE);
            return ListExtensions.map((List)it.getFootnotes(), (Functions.Function1)_function_1);
        };
        Iterator _map = IteratorExtensions.map((Iterator)Iterators.filter((Iterator)table.eAllContents(), SimpleFootnoteContainer.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> new FootnoteInfo((Bearbeitungsvermerk)it_1, FootnoteType.COMMON_FOOTNOTE);
            return ListExtensions.map((List)it.getUnchangedFootnotes(), (Functions.Function1)_function_2);
        };
        Iterator _map_1 = IteratorExtensions.map((Iterator)Iterators.filter((Iterator)table.eAllContents(), CompareFootnoteContainer.class), (Functions.Function1)_function_1);
        Iterable common = Iterables.concat((Iterable)IteratorExtensions.toList((Iterator)Iterators.concat((Iterator)_map, (Iterator)_map_1)));
        Functions.Function1 _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> new FootnoteInfo((Bearbeitungsvermerk)it_1, FootnoteType.OLD_FOOTNOTE);
            return ListExtensions.map((List)it.getOldFootnotes(), (Functions.Function1)_function_3);
        };
        Iterable old = Iterables.concat((Iterable)IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)table.eAllContents(), CompareFootnoteContainer.class), (Functions.Function1)_function_2)));
        Functions.Function1 _function_3 = it -> {
            Functions.Function1 _function_4 = it_1 -> new FootnoteInfo((Bearbeitungsvermerk)it_1, FootnoteType.NEW_FOOTNOTE);
            return ListExtensions.map((List)it.getNewFootnotes(), (Functions.Function1)_function_4);
        };
        Iterable newF = Iterables.concat((Iterable)IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)table.eAllContents(), CompareFootnoteContainer.class), (Functions.Function1)_function_3)));
        Functions.Function1 _function_4 = it -> it.toText();
        List _sortBy = org.eclipse.xtext.xbase.lib.IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)common, (Iterable)newF), (Functions.Function1)_function_4);
        Functions.Function1 _function_5 = it -> it.toText();
        List _sortBy_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.sortBy((Iterable)old, (Functions.Function1)_function_5);
        Iterable footnotes = Iterables.concat((Iterable)_sortBy, (Iterable)_sortBy_1);
        Functions.Function1 _function_6 = it -> {
            String _text = it.toText();
            return Pair.of((Object)_text, (Object)it.footnote);
        };
        Functions.Function1 _function_7 = it -> {
            int _plus;
            FootnoteInfo _value = (FootnoteInfo)it.getValue();
            Integer _key = (Integer)it.getKey();
            _value.index = _plus = _key + 1;
            return (FootnoteInfo)it.getValue();
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.indexed((Iterable)IterableExtensions.distinctBy((Iterable)footnotes, (Functions.Function1)_function_6)), (Functions.Function1)_function_7);
    }

    public static FootnoteInfo getFootnoteInfo(Table table, Bearbeitungsvermerk fn) {
        Functions.Function1 _function = it -> Objects.equals(it.footnote, fn);
        return (FootnoteInfo)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst(TableExtensions.getAllFootnotes(table), (Functions.Function1)_function);
    }

    public static FootnoteInfo getFootnoteInfo(EObject tableContent, Bearbeitungsvermerk fn) {
        EObject object = tableContent;
        while (!(object instanceof Table)) {
            object = object.eContainer();
        }
        return TableExtensions.getFootnoteInfo((Table)object, fn);
    }

    public static boolean isTableEmpty(Table table) {
        return org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty(TableExtensions.getTableRows(table));
    }

    public static boolean isInlineFootnote(Table table) {
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isFootnoteReferenceColumn(it);
        ColumnDescriptor remarkColumn = (ColumnDescriptor)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)table.getColumndescriptors(), (Functions.Function1)_function);
        if (remarkColumn == null) {
            return false;
        }
        Float remarkColumnWidth = ColumnDescriptorExtensions.getColumnWidth(remarkColumn);
        int maxCharInCell = StringExtensions.maxCharInCell((float)remarkColumnWidth.floatValue());
        Functions.Function1 _function_1 = row -> {
            FootnoteContainer fc = row.getFootnotes();
            if (fc == null) {
                return true;
            }
            if (fc instanceof SimpleFootnoteContainer) {
                Functions.Function1 _function_2 = it -> TableExtensions.getFootnoteInfo(table, it);
                Iterable remarks = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((SimpleFootnoteContainer)fc).getFootnotes(), (Functions.Function1)_function_2));
                return org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)remarks) || org.eclipse.xtext.xbase.lib.IterableExtensions.join((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)remarks, it -> it.toText()), (CharSequence)", ").length() < maxCharInCell;
            }
            if (fc instanceof CompareFootnoteContainer) {
                Functions.Function1 _function_3 = it -> TableExtensions.getFootnoteInfo(table, it);
                Iterable oldFootnotes = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((CompareFootnoteContainer)fc).getOldFootnotes(), (Functions.Function1)_function_3));
                Functions.Function1 _function_4 = it -> TableExtensions.getFootnoteInfo(table, it);
                Iterable newFootnotes = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((CompareFootnoteContainer)fc).getNewFootnotes(), (Functions.Function1)_function_4));
                Functions.Function1 _function_5 = it -> TableExtensions.getFootnoteInfo(table, it);
                Iterable unchangedFootnotes = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map((List)((CompareFootnoteContainer)fc).getUnchangedFootnotes(), (Functions.Function1)_function_5));
                Functions.Function1 _function_6 = it -> {
                    boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)it);
                    return !_isEmpty;
                };
                Iterable notEmptyContainer = org.eclipse.xtext.xbase.lib.IterableExtensions.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Iterable[]{oldFootnotes, newFootnotes, unchangedFootnotes})), (Functions.Function1)_function_6);
                boolean _switchResult = false;
                int _size = org.eclipse.xtext.xbase.lib.IterableExtensions.size((Iterable)notEmptyContainer);
                switch (_size) {
                    case 0: {
                        _switchResult = true;
                        break;
                    }
                    case 1: {
                        Functions.Function1 _function_7 = it -> it.toText();
                        Iterable remarks_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)((Iterable)IterableExtensions.getFirstOrNull((Iterable)notEmptyContainer)), (Functions.Function1)_function_7));
                        return org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)remarks_1) || org.eclipse.xtext.xbase.lib.IterableExtensions.join((Iterable)remarks_1, (CharSequence)FOOTNOTE_SEPARATOR).length() < maxCharInCell;
                    }
                    default: {
                        _switchResult = false;
                    }
                }
                return _switchResult;
            }
            return true;
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.forall(TableExtensions.getTableRows(table), (Functions.Function1)_function_1);
    }

    public static class FootnoteInfo {
        public Bearbeitungsvermerk footnote;
        public int index;
        public FootnoteType type;

        public FootnoteInfo(Bearbeitungsvermerk fn, FootnoteType ft) {
            this.footnote = fn;
            this.type = ft;
        }

        public String toShorthand() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("*");
            _builder.append((Object)this.index);
            return _builder.toString();
        }

        public String toReferenceText() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("*");
            _builder.append((Object)this.index);
            _builder.append(": ");
            Bearbeitungsvermerk_Allg_AttributeGroup _bearbeitungsvermerkAllg = null;
            if (this.footnote != null) {
                _bearbeitungsvermerkAllg = this.footnote.getBearbeitungsvermerkAllg();
            }
            Kommentar_TypeClass _kommentar = null;
            if (_bearbeitungsvermerkAllg != null) {
                _kommentar = _bearbeitungsvermerkAllg.getKommentar();
            }
            String _wert = null;
            if (_kommentar != null) {
                _wert = _kommentar.getWert();
            }
            _builder.append(_wert);
            return _builder.toString();
        }

        public String toText() {
            Bearbeitungsvermerk_Allg_AttributeGroup _bearbeitungsvermerkAllg = null;
            if (this.footnote != null) {
                _bearbeitungsvermerkAllg = this.footnote.getBearbeitungsvermerkAllg();
            }
            Kommentar_TypeClass _kommentar = null;
            if (_bearbeitungsvermerkAllg != null) {
                _kommentar = _bearbeitungsvermerkAllg.getKommentar();
            }
            String _wert = null;
            if (_kommentar != null) {
                _wert = _kommentar.getWert();
            }
            return _wert;
        }
    }

    public static enum FootnoteType {
        OLD_FOOTNOTE,
        NEW_FOOTNOTE,
        COMMON_FOOTNOTE;

    }
}

