/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.ssks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.export.pdf.FopPdfExportBuilder;
import org.eclipse.set.feature.table.pt1.messages.Messages;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.services.fop.FopService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={TableExport.class})
public class SsksTablePdfExportBuilder
extends FopPdfExportBuilder {
    @Reference
    private Messages messages;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setEnumTranslationService(EnumTranslationService enumTranslationService) {
        this.enumTranslationService = enumTranslationService;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setFopService(FopService fopService) {
        this.fopService = fopService;
    }

    public List<String> getPageBreakRowsIndex(Table table) {
        ArrayList<String> result = new ArrayList<String>();
        List.of("D", "B").forEach(columnPosition -> {
            ColumnDescriptor col = TableExtensions.getColumns((Table)table).stream().filter(column -> column.getColumnPosition().equals(columnPosition)).findFirst().orElse(null);
            Optional<Integer> lastRowIndex = SsksTablePdfExportBuilder.getLastRowIndex(table, col);
            if (lastRowIndex.isPresent()) {
                result.add(lastRowIndex.get().toString());
            }
        });
        return result;
    }

    private static Optional<Integer> getLastRowIndex(Table table, ColumnDescriptor column) {
        List<Map.Entry<Integer, TableRow>> signalEntries = SsksTablePdfExportBuilder.getSignalEntries(table, column);
        Optional<Map.Entry> collect = signalEntries.stream().collect(Collectors.maxBy(Comparator.comparingInt(Map.Entry::getKey)));
        if (collect.isPresent()) {
            return Optional.of((Integer)collect.get().getKey());
        }
        return Optional.empty();
    }

    private static List<Map.Entry<Integer, TableRow>> getSignalEntries(Table table, ColumnDescriptor column) {
        if (column == null) {
            return Collections.emptyList();
        }
        List tableRows = TableExtensions.getTableRows((Table)table);
        return tableRows.stream().collect(Collectors.toMap(e -> tableRows.indexOf(e) + 1, Function.identity())).entrySet().parallelStream().filter(entry -> {
            TableRow row = (TableRow)entry.getValue();
            String cellValue = TableRowExtensions.getPlainStringValue((TableRow)row, (ColumnDescriptor)column);
            return !cellValue.isEmpty() && !cellValue.isBlank();
        }).toList();
    }

    public String getTableShortcut() {
        return this.messages.ToolboxTableNameSsksShort.toLowerCase();
    }

    public TableExport.ExportFormat getExportFormat() {
        return TableExport.ExportFormat.PDF;
    }
}

