/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.autofill;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.autofill.CopyValue;
import org.eclipse.set.basis.autofill.DefaultAutofill;
import org.eclipse.set.basis.autofill.FillInstruction;
import org.eclipse.set.basis.autofill.FillPathSetting;
import org.eclipse.set.basis.autofill.FillSetting;
import org.eclipse.set.basis.autofill.FillTrigger;
import org.eclipse.set.feature.projectdata.autofill.PlanProTrigger;
import org.eclipse.set.model.planpro.PlanPro.PlanProFactory;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Planung_Projekt;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DateAutofill
extends DefaultAutofill {
    private static final int MIN_DATE = 1000;
    private Planung_Projekt planning;
    private final PlanProTrigger trigger = new PlanProTrigger(() -> confirmation.test(this.getDate()), true);
    private FillPathSetting source;

    private static boolean isValidDate(Object value) {
        if (value == null) {
            return false;
        }
        XMLGregorianCalendar date = (XMLGregorianCalendar)value;
        return date.getYear() > 1000;
    }

    public DateAutofill(Predicate<String> confirmation, Consumer<Exception> exceptionHandler) {
        super(exceptionHandler);
    }

    public Consumer<Text> getTextConsumer() {
        return this.trigger;
    }

    public void setEnable(boolean value) {
        this.trigger.setEnable(value);
    }

    public void setPlanning(Control parent, Planung_Projekt planning) {
        this.planning = planning;
        this.trigger.addAdapter(parent, (EObject)planning, (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_P_Allg_AttributeGroup_DatumAbschlussProjekt(), (EStructuralFeature)PlanProPackage.eINSTANCE.getDatum_Abschluss_Projekt_TypeClass_Wert());
        this.source = new FillPathSetting((EFactory)PlanProFactory.eINSTANCE, (EObject)planning, new EStructuralFeature[]{PlanProPackage.eINSTANCE.getPlanung_Projekt_PlanungPAllg(), PlanProPackage.eINSTANCE.getPlanung_P_Allg_AttributeGroup_DatumAbschlussProjekt(), PlanProPackage.eINSTANCE.getDatum_Abschluss_Projekt_TypeClass_Wert()});
        this.trigger.addCondition(() -> DateAutofill.isValidDate(this.source.getValue()));
    }

    public void setGroup(Planung_Gruppe group) {
        FillPathSetting targetDatumAbschlussGruppe = new FillPathSetting((EFactory)PlanProFactory.eINSTANCE, (EObject)group, new EStructuralFeature[]{PlanProPackage.eINSTANCE.getPlanung_Gruppe_PlanungGAllg(), PlanProPackage.eINSTANCE.getPlanung_G_Allg_AttributeGroup_DatumAbschlussGruppe(), PlanProPackage.eINSTANCE.getDatum_Abschluss_Gruppe_TypeClass_Wert()});
        this.addFillingInstruction((FillInstruction)new CopyValue((FillTrigger)this.trigger, (FillSetting)this.source, (FillSetting)targetDatumAbschlussGruppe));
        FillPathSetting targetDatumAbschlussEinzel = new FillPathSetting((EFactory)PlanProFactory.eINSTANCE, (EObject)group, new EStructuralFeature[]{PlanProPackage.eINSTANCE.getPlanung_Gruppe_LSTPlanungEinzel(), PlanProPackage.eINSTANCE.getPlanung_Einzel_PlanungEAllg(), PlanProPackage.eINSTANCE.getPlanung_E_Allg_AttributeGroup_DatumAbschlussEinzel(), PlanProPackage.eINSTANCE.getDatum_Abschluss_Einzel_TypeClass_Wert()});
        this.addFillingInstruction((FillInstruction)new CopyValue((FillTrigger)this.trigger, (FillSetting)this.source, (FillSetting)targetDatumAbschlussEinzel));
    }

    private String getDate() {
        XMLGregorianCalendar date = this.planning.getPlanungPAllg().getDatumAbschlussProjekt().getWert();
        LocalDate localDate = LocalDate.of(date.getYear(), date.getMonth(), date.getDay());
        return localDate.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
    }
}

