/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.feature.siteplan.SiteplanConstants;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOForm;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.GEO_Form_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Gleis.ENUMGleisart;
import org.eclipse.set.model.planpro.Gleis.Gleis_Art;
import org.eclipse.set.model.planpro.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.Track;
import org.eclipse.set.model.siteplan.TrackDesignation;
import org.eclipse.set.model.siteplan.TrackSection;
import org.eclipse.set.model.siteplan.TrackSegment;
import org.eclipse.set.model.siteplan.TrackShape;
import org.eclipse.set.model.siteplan.TrackType;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.WKrAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(immediate=true, service={Transformator.class, EventHandler.class}, property={"event.topics=modelsession/change/model", "event.topics=modelsession/close"})
public class TrackTransformator
extends BaseTransformator<TOP_Kante>
implements EventHandler {
    @Reference
    private GeoKanteGeometryService geometryService;
    @Reference
    private PositionService positionService;
    private boolean existsTrackType = true;
    private static final String ERROR_NO_GLEIS_ART = "Keine Gleisart f\u00fcr Segment der GEO_Kante '%s' gefunden.";
    private static final String ERROR_MULTIPLE_GLEIS_ART = "Mehrere Gleisarten f\u00fcr Segment der GEO_Kante '%s' gefunden.";
    private String sectionColor = "";

    public void handleEvent(Event event) {
        String _topic_1;
        boolean _equals_1;
        String _topic = event.getTopic();
        boolean _equals = Objects.equals(_topic, "modelsession/close");
        if (_equals) {
            this.existsTrackType = true;
        }
        if (_equals_1 = Objects.equals(_topic_1 = event.getTopic(), "modelsession/change/model")) {
            boolean _greaterThan;
            Object _property = event.getProperty("org.eclipse.e4.data");
            IModelSession modelSession = (IModelSession)_property;
            PlanPro_Schnittstelle schnittstelle = modelSession.getPlanProSchnittstelle();
            Functions.Function1 _function = it -> PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)schnittstelle, (ContainerType)it);
            Functions.Function1 _function_1 = it -> it.getGleisArt();
            List trackTypes = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.flatMap((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ContainerType[]{ContainerType.INITIAL, ContainerType.FINAL, ContainerType.SINGLE})), (Functions.Function1)_function)), (Functions.Function1)_function_1));
            int _size = trackTypes.size();
            this.existsTrackType = _greaterThan = _size > 0;
        }
    }

    @Override
    public void transform(TOP_Kante topKante) {
        boolean _isContinuousTrackInSwitch = this.isContinuousTrackInSwitch(topKante);
        if (_isContinuousTrackInSwitch) {
            return;
        }
        Track track = SiteplanFactory.eINSTANCE.createTrack();
        track.setGuid(topKante.getIdentitaet().getWert());
        List geoKantes = this.geometryService.getTopKantenMetaData(topKante);
        this.sectionColor = SiteplanConstants.TOP_KANTEN_COLOR.get(track.getGuid());
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.sectionColor);
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("hsl(");
            int _size = SiteplanConstants.TOP_KANTEN_COLOR.size();
            int _plus = _size + 1;
            double _multiply = (double)_plus * 137.5;
            _builder.append((Object)_multiply);
            _builder.append(", 100%, 65%)");
            this.sectionColor = _builder.toString();
            SiteplanConstants.TOP_KANTEN_COLOR.put(track.getGuid(), this.sectionColor);
        }
        String _name = this.getClass().getName();
        String _plus_1 = _name + "_";
        String _guid = track.getGuid();
        String _plus_2 = _plus_1 + _guid;
        Procedures.Procedure1 _function = it -> {
            TrackSection section = this.transformTrackSection((GEOKanteMetadata)it);
            GEOKanteMetadata md = it;
            Track track2 = track;
            synchronized (track2) {
                track.getSections().add((Object)section);
                EList _designations = track.getDesignations();
                Functions.Function1 _function_1 = it_1 -> it_1.getBereichObjekte();
                Functions.Function1 _function_2 = it_1 -> this.transform((Gleis_Bezeichnung)it_1, md);
                Iterable _filterNull = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.flatMap((Iterable)it.getSegments(), (Functions.Function1)_function_1), Gleis_Bezeichnung.class)), (Functions.Function1)_function_2));
                Iterables.addAll((Collection)_designations, (Iterable)_filterNull);
            }
        };
        TransformUtils.createTransformatorThread(geoKantes, _plus_2, Runtime.getRuntime().availableProcessors(), _function);
        this.addSiteplanElement(track, SiteplanPackage.eINSTANCE.getSiteplanState_Tracks());
    }

    private org.eclipse.set.model.siteplan.Coordinate startCoordinate(GEOKanteMetadata md) {
        try {
            GEOKanteCoordinate coordAlongGeoKante = this.geometryService.getCoordinate(md, md.getStart(), BigDecimal.ZERO, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
            Position knotenACoordinate = this.positionService.transformPosition(coordAlongGeoKante);
            org.eclipse.set.model.siteplan.Coordinate result = SiteplanFactory.eINSTANCE.createCoordinate();
            result.setX(knotenACoordinate.getX());
            result.setY(knotenACoordinate.getY());
            return result;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public TrackSection transformTrackSection(GEOKanteMetadata md) {
        TrackSection section = SiteplanFactory.eINSTANCE.createTrackSection();
        section.setGuid(md.getGeoKante().getIdentitaet().getWert());
        section.setShape(TrackTransformator.transformGeoForm(md.getGeoKante().getGEOKanteAllg().getGEOForm()));
        section.setColor(this.sectionColor);
        section.setStartCoordinate(this.startCoordinate(md));
        Functions.Function1 _function = segment -> {
            boolean _isEmpty = segment.getPositions().isEmpty();
            return !_isEmpty;
        };
        Consumer<TrackSegment> _function_1 = it -> section.getSegments().add(it);
        org.eclipse.xtext.xbase.lib.IterableExtensions.filter(this.transform(md), (Functions.Function1)_function).forEach(_function_1);
        return section;
    }

    public boolean isContinuousTrackInSwitch(TOP_Kante topKante) {
        Functions.Function1 _function_1;
        Functions.Function1 _function = it -> {
            TOP_Kante _continuousCrossingLeg = this.getContinuousCrossingLeg((W_Kr_Gsp_Komponente)it);
            return Objects.equals(_continuousCrossingLeg, topKante);
        };
        Iterable trackSwitchComponents = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getWKrGspKomponente(), (Functions.Function1)_function);
        boolean _isEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isEmpty((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)trackSwitchComponents, (Functions.Function1)(_function_1 = it -> {
            boolean _xblockexpression = false;
            W_Kr_Gsp_Element gspElement = WKrGspKomponenteExtensions.getWKrGspElement((W_Kr_Gsp_Komponente)it);
            W_Kr_Anlage gspAnlage = WKrGspElementExtensions.getWKrAnlage((W_Kr_Gsp_Element)gspElement);
            _xblockexpression = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement).size() == 2 || WKrAnlageExtensions.getWKrGspElemente((W_Kr_Anlage)gspAnlage).size() == 2;
            return _xblockexpression;
        })));
        return !_isEmpty;
    }

    public TOP_Kante getContinuousCrossingLeg(W_Kr_Gsp_Komponente component) {
        ENUMLinksRechts crossingSide;
        boolean _equals;
        TOP_Knoten topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component);
        Zungenpaar_AttributeGroup _zungenpaar = component.getZungenpaar();
        Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
        if (_zungenpaar != null) {
            _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
        }
        ENUMLinksRechts _wert = null;
        if (_kreuzungsgleis != null) {
            _wert = _kreuzungsgleis.getWert();
        }
        if (_equals = Objects.equals(crossingSide = _wert, ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS)) {
            List _topKanten = null;
            if (topKnoten != null) {
                _topKanten = TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten);
            }
            Iterable _filter = null;
            if (_topKanten != null) {
                Functions.Function1 _function = it -> {
                    ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                    return Objects.equals(_tOPAnschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
                };
                _filter = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)_topKanten, (Functions.Function1)_function);
            }
            TOP_Kante _head = null;
            if (_filter != null) {
                _head = (TOP_Kante)org.eclipse.xtext.xbase.lib.IterableExtensions.head(_filter);
            }
            return _head;
        }
        boolean _equals_1 = Objects.equals(crossingSide, ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS);
        if (_equals_1) {
            List _topKanten_1 = null;
            if (topKnoten != null) {
                _topKanten_1 = TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten);
            }
            Iterable _filter_1 = null;
            if (_topKanten_1 != null) {
                Functions.Function1 _function_1 = it -> {
                    ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                    return Objects.equals(_tOPAnschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
                };
                _filter_1 = org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)_topKanten_1, (Functions.Function1)_function_1);
            }
            TOP_Kante _head_1 = null;
            if (_filter_1 != null) {
                _head_1 = (TOP_Kante)org.eclipse.xtext.xbase.lib.IterableExtensions.head(_filter_1);
            }
            return _head_1;
        }
        return null;
    }

    public static TrackShape transformGeoForm(GEO_Form_TypeClass form) {
        ENUMGEOForm _wert = form.getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUMGEO_FORM_GERADE: {
                    return TrackShape.STRAIGHT;
                }
                case ENUMGEO_FORM_BOGEN: {
                    return TrackShape.CURVE;
                }
                case ENUMGEO_FORM_KLOTHOIDE: {
                    return TrackShape.CLOTHOID;
                }
                case ENUMGEO_FORM_BLOSSKURVE: {
                    return TrackShape.BLOSSCURVE;
                }
                case ENUMGEO_FORM_BLOSS_EINFACH_GESCHWUNGEN: {
                    return TrackShape.BLOSS_CURVED_SIMPLE;
                }
                case ENUMGEO_FORM_SONSTIGE: {
                    return TrackShape.OTHER;
                }
                case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: {
                    return TrackShape.DIRECTIONAL_STRAIGHT_KINK_END;
                }
                case ENUMGEO_FORM_KM_SPRUNG: {
                    return TrackShape.KM_JUMP;
                }
                case ENUMGEO_FORM_UEBERGANGSBOGEN_SFORM: {
                    return TrackShape.TRANSITION_CURVE_SFORM;
                }
                case ENUMGEO_FORM_SFORM_EINFACH_GESCHWUNGEN: {
                    return TrackShape.SFORM_SIMPLE_CURVED;
                }
            }
            return TrackShape.UNKNOWN;
        }
        return TrackShape.UNKNOWN;
    }

    public Iterable<TrackSegment> transform(GEOKanteMetadata geoKante) {
        Functions.Function1 _function = it -> this.transform((GEOKanteSegment)it, geoKante);
        return ListExtensions.map((List)geoKante.getSegments(), (Functions.Function1)_function);
    }

    private TrackSegment transform(GEOKanteSegment segment, GEOKanteMetadata md) {
        TrackSegment result = SiteplanFactory.eINSTANCE.createTrackSegment();
        GEO_Kante geoKante = md.getGeoKante();
        Functions.Function1 _function = it -> this.positionService.transformPosition((GEOKanteCoordinate)it);
        result.getPositions().addAll((Collection)ListExtensions.map(this.getCoordinates(segment, md), (Functions.Function1)_function));
        result.getType().addAll(this.getTrackType(segment, md));
        GEO_Knoten geoKnotenA = GeoKanteExtensions.getGeoKnotenA((GEO_Kante)geoKante);
        GeoPosition center = GeoKanteExtensions.getCoordinate((GEO_Kante)geoKante, (GEO_Knoten)geoKnotenA, (BigDecimal)geoKante.getGEOKanteAllg().getGEOLaenge().getWert().divide(BigDecimal.valueOf(2L), 5, RoundingMode.HALF_UP), (BigDecimal)BigDecimal.ZERO, (ENUMWirkrichtung)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        String guid = geoKante.getIdentitaet().getWert();
        if (((Object[])Conversions.unwrapArray((Object)result.getType(), Object.class)).length > 1 && this.existsTrackType) {
            this.recordError(guid, String.format(ERROR_MULTIPLE_GLEIS_ART, guid), this.positionService.transformCoordinate(center.getCoordinate(), GeoKnotenExtensions.getCRS((GEO_Knoten)geoKnotenA)));
        } else if (((Object[])Conversions.unwrapArray((Object)result.getType(), Object.class)).length == 0 && this.existsTrackType) {
            this.recordError(guid, String.format(ERROR_NO_GLEIS_ART, guid), this.positionService.transformCoordinate(center.getCoordinate(), GeoKnotenExtensions.getCRS((GEO_Knoten)geoKnotenA)));
        }
        return result;
    }

    private Set<TrackType> getTrackType(GEOKanteSegment segment, GEOKanteMetadata md) {
        boolean _greaterThan;
        BigDecimal _start = segment.getStart();
        BigDecimal _start_1 = segment.getStart();
        BigDecimal _length = segment.getLength();
        BigDecimal _plus = _start_1.add(_length);
        Range segmentRange = Range.closed((Comparable)_start, (Comparable)_plus);
        Functions.Function1 _function = ga -> {
            Functions.Function1 _function_1 = botb -> Objects.equals(botb.getIDTOPKante().getValue(), md.getGeoKante().getIDGEOArt().getValue()) && segmentRange.isConnected(Range.closed((Comparable)botb.getBegrenzungA().getWert(), (Comparable)botb.getBegrenzungB().getWert()));
            return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)ga.getBereichObjektTeilbereich(), (Functions.Function1)_function_1);
        };
        Functions.Function1 _function_1 = it -> it.getGleisart().getWert();
        Set trackTypeAreas = org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)IterableExtensions.distinctBy((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)Iterables.filter((Iterable)segment.getBereichObjekte(), Gleis_Art.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> this.transformTrackType((Gleis_Art)it);
        Set siteplanTrackType = org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)trackTypeAreas, (Functions.Function1)_function_2));
        int _length_1 = ((Object[])Conversions.unwrapArray((Object)trackTypeAreas, Object.class)).length;
        boolean bl = _greaterThan = _length_1 > 1;
        if (_greaterThan) {
            int i = 0;
            while (i < ((Object[])Conversions.unwrapArray((Object)trackTypeAreas, Object.class)).length) {
                Gleis_Art currentArea = ((Gleis_Art[])Conversions.unwrapArray((Object)trackTypeAreas, Gleis_Art.class))[i];
                int j = i + 1;
                while (j < ((Object[])Conversions.unwrapArray((Object)trackTypeAreas, Object.class)).length) {
                    boolean _tripleEquals;
                    BigDecimal length = BereichObjektExtensions.getOverlappingLength((Bereich_Objekt)currentArea, (Bereich_Objekt)((Bereich_Objekt[])Conversions.unwrapArray((Object)trackTypeAreas, Bereich_Objekt.class))[j]);
                    int _compareTo = length.compareTo(BigDecimal.ZERO);
                    boolean bl2 = _tripleEquals = _compareTo == 0;
                    if (_tripleEquals) {
                        Functions.Function1 _function_3 = it -> it.getValue();
                        return Set.of((TrackType)org.eclipse.xtext.xbase.lib.IterableExtensions.minBy((Iterable)siteplanTrackType, (Functions.Function1)_function_3));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return siteplanTrackType;
    }

    private TrackType transformTrackType(Gleis_Art gleisart) {
        ENUMGleisart _wert = gleisart.getGleisart().getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUM_GLEISART_ANSCHLUSSGLEIS: {
                    return TrackType.CONNECTING_TRACK;
                }
                case ENUM_GLEISART_DURCHGEHENDES_HAUPTGLEIS: {
                    return TrackType.PASSING_MAIN_TRACK;
                }
                case ENUM_GLEISART_HAUPTGLEIS: {
                    return TrackType.MAIN_TRACK;
                }
                case ENUM_GLEISART_NEBENGLEIS: {
                    return TrackType.SIDE_TRACK;
                }
                case ENUM_GLEISART_SONSTIGE: {
                    return TrackType.OTHER;
                }
                case ENUM_GLEISART_STRECKENGLEIS: {
                    return TrackType.ROUTE_TRACK;
                }
            }
        }
        return null;
    }

    private TrackDesignation transform(Gleis_Bezeichnung gleisBezeichnung, GEOKanteMetadata md) {
        boolean _notEquals;
        TrackDesignation result = SiteplanFactory.eINSTANCE.createTrackDesignation();
        result.setName(gleisBezeichnung.getBezeichnung().getBezGleisBezeichnung().getWert());
        Comparator _function = (a, b) -> this.getLength((Bereich_Objekt_Teilbereich_AttributeGroup)a).compareTo(this.getLength((Bereich_Objekt_Teilbereich_AttributeGroup)b));
        Bereich_Objekt_Teilbereich_AttributeGroup maxTB = (Bereich_Objekt_Teilbereich_AttributeGroup)org.eclipse.xtext.xbase.lib.IterableExtensions.max((Iterable)gleisBezeichnung.getBereichObjektTeilbereich(), (Comparator)_function);
        ID_TOP_Kante_TypeClass _iDTOPKante = maxTB.getIDTOPKante();
        TOP_Kante _value = null;
        if (_iDTOPKante != null) {
            _value = _iDTOPKante.getValue();
        }
        Identitaet_TypeClass _identitaet = null;
        if (_value != null) {
            _identitaet = _value.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        Identitaet_TypeClass _identitaet_1 = GeoKanteExtensions.topKante((GEO_Kante)md.getGeoKante()).getIdentitaet();
        String _wert_1 = null;
        if (_identitaet_1 != null) {
            _wert_1 = _identitaet_1.getWert();
        }
        boolean bl = _notEquals = !Objects.equals(_wert, _wert_1);
        if (_notEquals) {
            return null;
        }
        BigDecimal centerDistance = this.getLength(maxTB).divide(BigDecimal.valueOf(2L), 5, RoundingMode.HALF_UP);
        if (centerDistance.compareTo(md.getStart()) < 0 || centerDistance.compareTo(md.getEnd()) >= 0) {
            return null;
        }
        GEOKanteCoordinate coordinate = this.geometryService.getCoordinate(md, centerDistance, BigDecimal.ZERO, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        result.setPosition((org.eclipse.set.model.siteplan.Coordinate)this.positionService.transformPosition(coordinate));
        return result;
    }

    public BigDecimal getLength(Bereich_Objekt_Teilbereich_AttributeGroup tb) {
        BigDecimal _wert = tb.getBegrenzungB().getWert();
        BigDecimal _wert_1 = tb.getBegrenzungA().getWert();
        return _wert.subtract(_wert_1);
    }

    public List<GEOKanteCoordinate> getCoordinates(GEOKanteSegment segment, GEOKanteMetadata geoKante) {
        Coordinate[] _coordinates;
        ArrayList result = CollectionLiterals.newArrayList();
        BigDecimal _length = geoKante.getLength();
        boolean _equals = Objects.equals(_length, 0);
        if (_equals) {
            try {
                GEO_Kante gk = geoKante.getGeoKante();
                GEO_Knoten knotenA = gk.getIDGEOKnotenA().getValue();
                GEO_Knoten knotenB = gk.getIDGEOKnotenB().getValue();
                Coordinate _coordinate = GeoKnotenExtensions.getCoordinate((GEO_Knoten)knotenA);
                Set _bereichObjekte = segment.getBereichObjekte();
                ENUMGEOKoordinatensystem _cRS = GeoKnotenExtensions.getCRS((GEO_Knoten)knotenA);
                GEOKanteCoordinate _gEOKanteCoordinate = new GEOKanteCoordinate(_coordinate, geoKante, _bereichObjekte, _cRS);
                Coordinate _coordinate_1 = GeoKnotenExtensions.getCoordinate((GEO_Knoten)knotenB);
                Set _bereichObjekte_1 = segment.getBereichObjekte();
                ENUMGEOKoordinatensystem _cRS_1 = GeoKnotenExtensions.getCRS((GEO_Knoten)knotenB);
                GEOKanteCoordinate _gEOKanteCoordinate_1 = new GEOKanteCoordinate(_coordinate_1, geoKante, _bereichObjekte_1, _cRS_1);
                return List.of(_gEOKanteCoordinate, _gEOKanteCoordinate_1);
            }
            catch (Throwable _t) {
                if (_t instanceof NullPointerException) {
                    NullPointerException e = (NullPointerException)_t;
                    throw new RuntimeException(e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        Coordinate lastCoordinate = null;
        BigDecimal distance = geoKante.getStart();
        Coordinate[] coordinateArray = _coordinates = geoKante.getGeometry().getCoordinates();
        int n = _coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            if (lastCoordinate == null) {
                lastCoordinate = coordinate;
            } else {
                boolean _lessThan;
                BigDecimal _start = segment.getStart();
                boolean bl = _lessThan = distance.compareTo(_start) < 0;
                if (_lessThan) {
                    BigDecimal _distance = distance;
                    BigDecimal _valueOf = BigDecimal.valueOf(lastCoordinate.distance(coordinate));
                    distance = _distance.add(_valueOf);
                    lastCoordinate = coordinate;
                } else {
                    boolean _greaterThan;
                    BigDecimal _end = segment.getEnd();
                    boolean bl2 = _greaterThan = distance.compareTo(_end) > 0;
                    if (_greaterThan) {
                        return result;
                    }
                    boolean _isEmpty = result.isEmpty();
                    if (_isEmpty) {
                        ENUMGEOKoordinatensystem _cRS = GeoKnotenExtensions.getCRS((GEO_Knoten)geoKante.getGeoKnoten());
                        GEOKanteCoordinate _gEOKanteCoordinate = new GEOKanteCoordinate(lastCoordinate, geoKante, _cRS);
                        result.add(_gEOKanteCoordinate);
                    }
                    ENUMGEOKoordinatensystem _cRS_1 = GeoKnotenExtensions.getCRS((GEO_Knoten)geoKante.getGeoKnoten());
                    GEOKanteCoordinate _gEOKanteCoordinate_1 = new GEOKanteCoordinate(coordinate, geoKante, _cRS_1);
                    result.add(_gEOKanteCoordinate_1);
                    BigDecimal _distance_1 = distance;
                    BigDecimal _valueOf_1 = BigDecimal.valueOf(lastCoordinate.distance(coordinate));
                    distance = _distance_1.add(_valueOf_1);
                    lastCoordinate = coordinate;
                }
            }
            ++n2;
        }
        return result;
    }
}

