/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.positionservice;

import java.util.EnumMap;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.ppmodel.extensions.geometry.CoordinateExtensions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;
import org.osgi.service.component.annotations.Component;

@Component
public class PositionServiceImpl
implements PositionService {
    private static final String TARGET_CRS_DEFINITION = "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext +no_defs";
    private static final String TARGET_CRS = "EPSG:3857";
    final CRSFactory crsFactory;
    final EnumMap<ENUMGEOKoordinatensystem, CoordinateReferenceSystem> crsReferences = new EnumMap(ENUMGEOKoordinatensystem.class);
    final CoordinateReferenceSystem proj4TargetCRS;

    public PositionServiceImpl() {
        this.crsFactory = new CRSFactory();
        this.setProj4CRS();
        this.proj4TargetCRS = this.crsFactory.createFromParameters(TARGET_CRS, TARGET_CRS_DEFINITION);
    }

    private void setProj4CRS() {
        this.crsReferences.put(ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_CR0, this.crsFactory.createFromParameters("EPSG:31466", CoordinateExtensions.CRS_CR0_PARAMETER));
        this.crsReferences.put(ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_DR0, this.crsFactory.createFromParameters("EPSG:31467", CoordinateExtensions.CRS_DR0_PARAMETER));
        this.crsReferences.put(ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_ER0, this.crsFactory.createFromParameters("EPSG:31468", CoordinateExtensions.CRS_ERO_PARAMETER));
        this.crsReferences.put(ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_FR0, this.crsFactory.createFromParameters("EPSG:31465", CoordinateExtensions.CRS_FRO_PARAMETER));
    }

    @Override
    public org.eclipse.set.model.siteplan.Coordinate transformCoordinate(org.eclipse.set.model.siteplan.Coordinate result, double x, double y, ENUMGEOKoordinatensystem crs) {
        CoordinateTransformFactory transformFactory = new CoordinateTransformFactory();
        CoordinateReferenceSystem sourceRef = this.getCRSReference(crs);
        ProjCoordinate targetCoor = new ProjCoordinate();
        transformFactory.createTransform(sourceRef, this.proj4TargetCRS).transform(new ProjCoordinate(x, y), targetCoor);
        result.setX(targetCoor.x);
        result.setY(targetCoor.y);
        return result;
    }

    @Override
    public org.eclipse.set.model.siteplan.Coordinate transformCoordinate(double x, double y, ENUMGEOKoordinatensystem crs) {
        return this.transformCoordinate(SiteplanFactory.eINSTANCE.createCoordinate(), x, y, crs);
    }

    @Override
    public org.eclipse.set.model.siteplan.Coordinate transformCoordinate(Coordinate coordinate, ENUMGEOKoordinatensystem crs) {
        return this.transformCoordinate(coordinate.x, coordinate.y, crs);
    }

    @Override
    public Position transformPosition(GeoPosition coordinate, ENUMGEOKoordinatensystem crs) {
        Position position = SiteplanFactory.eINSTANCE.createPosition();
        this.transformCoordinate((org.eclipse.set.model.siteplan.Coordinate)position, coordinate.getCoordinate().x, coordinate.getCoordinate().y, crs);
        position.setRotation(coordinate.getTopologicalRotation());
        return position;
    }

    @Override
    public Position transformPosition(GEOKanteCoordinate geoPosition) {
        return this.transformPosition(geoPosition.getGeoPosition(), geoPosition.getCRS());
    }

    private CoordinateReferenceSystem getCRSReference(ENUMGEOKoordinatensystem crs) {
        if (this.crsReferences.isEmpty()) {
            return null;
        }
        return this.crsReferences.get(crs);
    }
}

