/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RoundRobinIterator<T>
implements Iterator<T> {
    private final Collection<T> collection;
    private Iterator<T> delegate;

    public RoundRobinIterator(Collection<T> collection) {
        this.collection = collection;
        if (!collection.isEmpty()) {
            this.delegate = collection.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.delegate != null;
    }

    @Override
    public T next() {
        if (this.delegate == null) {
            throw new NoSuchElementException();
        }
        if (!this.delegate.hasNext()) {
            this.delegate = this.collection.iterator();
        }
        return this.delegate.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

