/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.export.xsl.AbstractTransformTableHeader;
import org.eclipse.set.utils.export.xsl.TransformStyle;
import org.eclipse.set.utils.export.xsl.TransformTableBody;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MultiPageTableHeader
extends AbstractTransformTableHeader {
    private static final String MULTIPAGE_LAYOUT_TEMPLATE_PATH = "data/export/pdf/multipage_layout.xsl";
    private static final String XSL_MAINPAGE_TEMPLATE_NAME = "MainPage";
    Set<Integer> pageBreakAts = new LinkedHashSet<Integer>();

    protected MultiPageTableHeader(XSSFSheet sheet, float maxPaperWidth) {
        super(sheet, maxPaperWidth);
        int[] nArray = sheet.getColumnBreaks();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndex = nArray[n2];
            this.pageBreakAts.add(columnIndex);
            ++n2;
        }
    }

    @Override
    protected void addTableToTemplate(Element tableTemplate, Element table) {
        Element block = this.doc.createElement("fo:block");
        block.appendChild(table);
        tableTemplate.appendChild(block);
    }

    @Override
    protected Document getFopPageTemplate() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        Document tableTemplate = MultiPageTableHeader.parseTemplate("data/export/pdf/table_template.xsl");
        Node rootNode = tableTemplate.getElementsByTagName("xsl:stylesheet").item(0);
        Document multipageTemplate = MultiPageTableHeader.parseTemplate(MULTIPAGE_LAYOUT_TEMPLATE_PATH);
        Optional<Element> newPageBlock = MultiPageTableHeader.findNodebyTagName(multipageTemplate, "fo:block", "id", XSLConstant.TableAttribute.START_INDENT);
        if (newPageBlock.isPresent()) {
            newPageBlock.get().setAttribute(XSLConstant.TableAttribute.START_INDENT, BigDecimalExtensions.toTableDecimal(BigDecimal.valueOf(this.maxPaperWidth).negate(), 2) + "cm");
        }
        Node clone = tableTemplate.importNode(multipageTemplate.getFirstChild(), true);
        Optional<Element> singlePageLayout = MultiPageTableHeader.findNodebyTagName(tableTemplate, "xsl:template", "name", XSL_MAINPAGE_TEMPLATE_NAME);
        if (singlePageLayout.isPresent()) {
            rootNode.replaceChild(clone, singlePageLayout.get());
        } else {
            rootNode.appendChild(clone);
        }
        return tableTemplate;
    }

    @Override
    protected Set<Element> getTableStyle() {
        return new TransformTableBody(this.doc, (Sheet)this.sheet).pageBreakColumnCellStyle(this.pageBreakAts);
    }

    @Override
    protected Pair<Integer, Float> transformColumn(LinkedHashSet<Element> cols, float sumWidth, int colsIndex, int columNumber) {
        float columnWidth = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, colsIndex);
        if (this.pageBreakAts.contains(colsIndex) || this.isBigerThanPaperWidth(sumWidth + columnWidth, colsIndex + 1)) {
            this.pageBreakAts.add(colsIndex);
            columnWidth = this.maxPaperWidth - sumWidth;
            cols.add(this.createTableColumn(columNumber, columnWidth));
            Pair<Integer, Float> repeatColumns = this.transformBreakColumns(cols, columNumber);
            return Pair.of((Object)((Integer)repeatColumns.getKey()), (Object)((Float)repeatColumns.getValue()));
        }
        cols.add(this.createTableColumn(columNumber, columnWidth));
        return Pair.of((Object)columNumber, (Object)Float.valueOf(sumWidth + columnWidth));
    }

    private Pair<Integer, Float> transformBreakColumns(LinkedHashSet<Element> columns, int columnNumber) {
        LinkedHashSet<Integer> repeatingColumns = ExcelWorkbookExtension.getRepeatingColumns((Sheet)this.sheet);
        if (repeatingColumns.isEmpty()) {
            float columnWidth = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, 0);
            columns.add(this.createTableColumn(columnNumber, columnWidth));
            return Pair.of((Object)(columnNumber + 1), (Object)Float.valueOf(columnWidth));
        }
        float repeatColumnsWidth = 0.0f;
        int index = 0;
        while (index < repeatingColumns.size()) {
            int colIndex = columnNumber + index + 1;
            float columnWidth = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, new ArrayList<Integer>(repeatingColumns).get(index));
            repeatColumnsWidth += columnWidth;
            columns.add(this.createTableColumn(colIndex, columnWidth));
            ++index;
        }
        return Pair.of((Object)(columnNumber + repeatingColumns.size()), (Object)Float.valueOf(repeatColumnsWidth));
    }

    @Override
    protected int getCellSpanColumn(Optional<Cell> excelCell) {
        if (excelCell.isEmpty()) {
            return 0;
        }
        Optional<CellRangeAddress> cellSpanRange = ExcelWorkbookExtension.getColumnSpanRangeAt(excelCell.get());
        if (cellSpanRange.isPresent()) {
            int spanCount = cellSpanRange.get().getNumberOfCells();
            Integer breakInSpan = this.pageBreakAts.stream().filter(colIndex -> colIndex < ((CellRangeAddress)cellSpanRange.get()).getLastColumn() && colIndex > ((CellRangeAddress)cellSpanRange.get()).getFirstColumn()).findFirst().orElse(null);
            if (breakInSpan != null) {
                int colIndex2 = excelCell.get().getColumnIndex();
                if (ExcelWorkbookExtension.getCellStringValue(excelCell).isEmpty()) {
                    Optional<Cell> cellAt = ExcelWorkbookExtension.getCellAt(excelCell.get().getSheet(), cellSpanRange.get().getFirstRow(), cellSpanRange.get().getFirstColumn());
                    excelCell.get().setCellValue(ExcelWorkbookExtension.getCellStringValue(cellAt).orElse(""));
                }
                return colIndex2 <= breakInSpan ? breakInSpan - cellSpanRange.get().getFirstColumn() + 1 : cellSpanRange.get().getLastColumn() - breakInSpan;
            }
            return spanCount;
        }
        return 0;
    }

    @Override
    protected void addCell(Set<Element> cells, int rowIndex, Element cell, int cellStartCol) {
        cells.add(cell);
        if (!this.pageBreakAts.contains(cellStartCol)) {
            return;
        }
        TransformStyle.setBorderStyle((Element)IterableExtensions.lastOrNull(cells), XSLConstant.TableAttribute.BorderDirection.RIGHT, "wide-border-style");
        LinkedHashSet<Integer> repeatingColumns = ExcelWorkbookExtension.getRepeatingColumns((Sheet)this.sheet);
        if (repeatingColumns.isEmpty()) {
            cells.add(this.transformFirstColumnCell((Row)this.sheet.getRow(rowIndex)));
            return;
        }
        repeatingColumns.forEach(colIndex -> {
            if (colIndex == 0) {
                cells.add(this.transformFirstColumnCell((Row)this.sheet.getRow(rowIndex)));
            } else if (ExcelWorkbookExtension.getRowSpanRangeAt((Sheet)this.sheet, rowIndex, colIndex).isEmpty() && (ExcelWorkbookExtension.getCellAt((Sheet)this.sheet, rowIndex, rowIndex).isPresent() || rowIndex == ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet))) {
                Element cloneNode = (Element)cells.toArray(new Element[0])[colIndex].cloneNode(true);
                String columnsSpanned = cloneNode.getAttribute(XSLConstant.TableAttribute.NUMBER_COLUMNS_SPANNED);
                if (colIndex == repeatingColumns.size() - 1) {
                    TransformStyle.setBorderStyle(cloneNode, XSLConstant.TableAttribute.BorderDirection.RIGHT, "wide-border-style");
                }
                if (columnsSpanned.isEmpty() || columnsSpanned.equals("1")) {
                    cells.add(cloneNode);
                } else {
                    try {
                        Integer spanCount = Integer.parseInt(columnsSpanned);
                        long repeatingSpanCount = repeatingColumns.stream().filter(col -> colIndex <= col && colIndex + spanCount >= col).count();
                        cloneNode.setAttribute(XSLConstant.TableAttribute.NUMBER_COLUMNS_SPANNED, String.valueOf(repeatingSpanCount));
                        cells.add(cloneNode);
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException();
                    }
                }
            }
        });
    }

    private boolean isBigerThanPaperWidth(float currentSumWidth, int nextColumnIndex) {
        CellRangeAddress nextColumnGroup = Arrays.stream(ExcelWorkbookExtension.getParentGroupSpan((Sheet)this.sheet)).filter(group -> group.getFirstColumn() == nextColumnIndex).findFirst().orElse(null);
        if (nextColumnGroup != null) {
            float groupSumWidth = 0.0f;
            int i = nextColumnIndex;
            while (i <= nextColumnGroup.getLastColumn()) {
                groupSumWidth += ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, i);
                ++i;
            }
            return currentSumWidth + groupSumWidth > this.maxPaperWidth;
        }
        return currentSumWidth + ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, nextColumnIndex) > this.maxPaperWidth;
    }
}

