/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EMFExtensions {
    public static void registerExtensionFactory(String extension, Object factory) {
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!extensionToFactoryMap.containsKey(factory)) {
            extensionToFactoryMap.put(extension, factory);
            return;
        }
        Object oldFactory = extensionToFactoryMap.get(extension);
        Assert.isTrue((boolean)oldFactory.getClass().equals(factory.getClass()));
    }

    public static <T extends EObject> void saveToFile(T value, Path path) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)path.toAbsolutePath().toString()));
        resource.getContents().add(value);
        resource.save(null);
    }
}

