/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.gui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HeaderGroupNameDialog
extends Dialog {
    private Button createButton;
    private Text groupNameText;
    private String groupName;
    private final HeaderGroupNameDialogLabels dialogLabels;

    public HeaderGroupNameDialog(Shell parentShell, HeaderGroupNameDialogLabels dialogLabels) {
        super(parentShell);
        this.dialogLabels = dialogLabels;
        this.setShellStyle(67680);
    }

    public void create() {
        super.create();
        this.getShell().setText(this.dialogLabels.shellTitle);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridDataFactory.fillDefaults().minSize(GUIHelper.convertHorizontalPixelToDpi(200, true), -1).align(4, 4).grab(true, false).applyTo((Control)this.createInputPanel(composite));
        Composite buttonPanel = this.createButtonSection(composite);
        GridDataFactory.swtDefaults().align(4, 1024).grab(true, true).applyTo((Control)buttonPanel);
        return composite;
    }

    private Composite createButtonSection(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 2;
        panel.setLayout((Layout)layout);
        this.createButton = this.createButton(panel, 0, this.dialogLabels.createButtonLabel, false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(true, true).applyTo((Control)this.createButton);
        this.createButton.setEnabled(false);
        this.getShell().setDefaultButton(this.createButton);
        Button closeButton = this.createButton(panel, 1, Messages.getString("AbstractStyleEditorDialog.cancelButton"), false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).applyTo((Control)closeButton);
        return panel;
    }

    private Composite createInputPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, false));
        Label createLabel = new Label(row, 0);
        createLabel.setText(String.valueOf(this.dialogLabels.createGroupLabel) + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)createLabel);
        this.groupNameText = new Text(row, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.groupNameText);
        this.groupNameText.addModifyListener(e -> this.createButton.setEnabled(this.groupNameText.getText().length() > 0));
        return row;
    }

    protected void okPressed() {
        this.groupName = this.groupNameText.getText();
        super.okPressed();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static enum HeaderGroupNameDialogLabels {
        CREATE_COLUMN_GROUP(Messages.getString("ColumnGroups.createColumnGroupDialogTitle"), Messages.getString("ColumnGroups.createButtonLabel"), Messages.getString("ColumnGroups.createGroupLabel")){}
        ,
        CREATE_ROW_GROUP(Messages.getString("RowGroups.createRowGroupDialogTitle"), Messages.getString("RowGroups.createButtonLabel"), Messages.getString("RowGroups.createGroupLabel")){};

        public final String shellTitle;
        public final String createButtonLabel;
        public final String createGroupLabel;

        private HeaderGroupNameDialogLabels(String shellTitle, String createButtonLabel, String createGroupLabel) {
            this.shellTitle = shellTitle;
            this.createButtonLabel = createButtonLabel;
            this.createGroupLabel = createGroupLabel;
        }
    }
}

