/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rap.rwt.internal.widgets.fileuploadkit.FileUploadLCA;
import org.eclipse.rap.rwt.internal.widgets.fileuploadkit.FileUploadThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TypedListener;

public class FileUpload
extends Canvas {
    private final IFileUploadAdapter fileUploadAdapter;
    private String text = "";
    private Image image;
    private String[] fileNames = new String[0];
    private String[] filterExtensions = new String[0];
    private String url;

    public FileUpload(Composite parent, int style) {
        super(parent, FileUpload.checkStyle(style));
        this.fileUploadAdapter = new FileUploadAdapter();
    }

    public void setText(String text) {
        if (text == null) {
            SWT.error(4);
        }
        this.checkWidget();
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.image = image;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getFileName() {
        this.checkWidget();
        return this.fileNames.length > 0 ? this.fileNames[0] : null;
    }

    public String[] getFileNames() {
        this.checkWidget();
        return (String[])this.fileNames.clone();
    }

    public void setFilterExtensions(String[] extensions) {
        this.checkWidget();
        if (extensions == null) {
            SWT.error(5);
        }
        this.filterExtensions = extensions;
    }

    public String[] getFilterExtensions() {
        this.checkWidget();
        return this.filterExtensions;
    }

    public void submit(String url) {
        if (url == null) {
            SWT.error(4);
        }
        this.checkWidget();
        if (this.fileNames.length > 0) {
            this.url = url;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean hasText;
        this.checkWidget();
        int width = 0;
        int height = 0;
        boolean hasImage = this.image != null;
        boolean bl = hasText = this.text.length() > 0;
        if (hasImage) {
            Rectangle imageBounds = this.image.getBounds();
            width = imageBounds.width;
            height = imageBounds.height;
        }
        if (hasText) {
            Point extent = TextSizeUtil.stringExtent(this.getFont(), this.text);
            width += extent.x;
            height = Math.max(height, extent.y);
        }
        if (height == 0) {
            height = 10;
        }
        FileUploadThemeAdapter themeAdapter = this.getThemeAdapter();
        if (hasText && hasImage) {
            int spacing = themeAdapter.getSpacing(this);
            width += spacing;
        }
        BoxDimensions padding = themeAdapter.getPadding(this);
        width += padding.left + padding.right;
        height += padding.top + padding.bottom;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = themeAdapter.getBorder(this);
        return new Point(width += border.left + border.right, height += border.top + border.bottom);
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    @Override
    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFileUploadAdapter.class) {
            return (T)this.fileUploadAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)FileUploadLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    private static int checkStyle(int style) {
        int mask = 2050;
        return style & mask;
    }

    private FileUploadThemeAdapter getThemeAdapter() {
        return (FileUploadThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    private final class FileUploadAdapter
    implements IFileUploadAdapter {
        private FileUploadAdapter() {
        }

        @Override
        public void setFileNames(String[] value) {
            FileUpload.this.fileNames = value;
        }

        @Override
        public String getAndResetUrl() {
            String result = FileUpload.this.url;
            FileUpload.this.url = null;
            return result;
        }
    }
}

