/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treecolumnkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.treecolumnkit.TreeColumnOperationHandler;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class TreeColumnLCA
extends WidgetLCA<TreeColumn> {
    public static final TreeColumnLCA INSTANCE = new TreeColumnLCA();
    private static final String TYPE = "rwt.widgets.GridColumn";
    static final String PROP_INDEX = "index";
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_FIXED = "fixed";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    @Override
    public void preserveValues(TreeColumn column) {
        WidgetLCAUtil.preserveToolTipText(column, column.getToolTipText());
        WidgetLCAUtil.preserveFont(column, TreeColumnLCA.getFont(column));
        ItemLCAUtil.preserve(column);
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_INDEX, TreeColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, "left", TreeColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_WIDTH, column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_RESIZABLE, column.getResizable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_MOVEABLE, column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_ALIGNMENT, TreeColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_FIXED, TreeColumnLCA.isFixed(column));
    }

    @Override
    public void renderInitialization(TreeColumn column) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(column, TYPE);
        remoteObject.setHandler(new TreeColumnOperationHandler(column));
        remoteObject.set("parent", WidgetUtil.getId(column.getParent()));
    }

    @Override
    public void renderChanges(TreeColumn column) throws IOException {
        WidgetLCAUtil.renderToolTip(column, column.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(column);
        WidgetLCAUtil.renderFont(column, TreeColumnLCA.getFont(column));
        ItemLCAUtil.renderChanges(column);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_INDEX, TreeColumnLCA.getIndex(column), -1);
        WidgetLCAUtil.renderProperty((Widget)column, "left", TreeColumnLCA.getLeft(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_WIDTH, column.getWidth(), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_RESIZABLE, column.getResizable(), true);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_MOVEABLE, column.getMoveable(), false);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_ALIGNMENT, TreeColumnLCA.getAlignment(column), "left");
        WidgetLCAUtil.renderProperty((Widget)column, PROP_FIXED, TreeColumnLCA.isFixed(column), false);
        WidgetLCAUtil.renderListenSelection(column);
    }

    private static int getIndex(TreeColumn column) {
        return column.getParent().indexOf(column);
    }

    static int getLeft(TreeColumn column) {
        ITreeAdapter adapter = column.getParent().getAdapter(ITreeAdapter.class);
        return adapter.getColumnLeft(column);
    }

    private static String getAlignment(TreeColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static Font getFont(TreeColumn column) {
        Tree tree = column.getParent();
        IControlAdapter adapter = tree.getAdapter(IControlAdapter.class);
        return adapter.getUserFont();
    }

    private static boolean isFixed(TreeColumn column) {
        ITreeAdapter adapter = column.getParent().getAdapter(ITreeAdapter.class);
        return adapter.isFixedColumn(column);
    }

    private TreeColumnLCA() {
    }
}

