/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablecolumnkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.tablecolumnkit.TableColumnOperationHandler;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public final class TableColumnLCA
extends WidgetLCA<TableColumn> {
    public static final TableColumnLCA INSTANCE = new TableColumnLCA();
    private static final String TYPE = "rwt.widgets.GridColumn";
    static final String PROP_INDEX = "index";
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_FIXED = "fixed";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    @Override
    public void preserveValues(TableColumn column) {
        WidgetLCAUtil.preserveToolTipText(column, column.getToolTipText());
        WidgetLCAUtil.preserveFont(column, TableColumnLCA.getFont(column));
        ItemLCAUtil.preserve(column);
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_INDEX, TableColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, "left", TableColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_WIDTH, column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_RESIZABLE, column.getResizable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_MOVEABLE, column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_ALIGNMENT, TableColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_FIXED, TableColumnLCA.isFixed(column));
    }

    @Override
    public void renderInitialization(TableColumn column) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(column, TYPE);
        remoteObject.setHandler(new TableColumnOperationHandler(column));
        remoteObject.set("parent", WidgetUtil.getId(column.getParent()));
    }

    @Override
    public void renderChanges(TableColumn column) throws IOException {
        WidgetLCAUtil.renderToolTip(column, column.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(column);
        WidgetLCAUtil.renderFont(column, TableColumnLCA.getFont(column));
        ItemLCAUtil.renderChanges(column);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_INDEX, TableColumnLCA.getIndex(column), -1);
        WidgetLCAUtil.renderProperty((Widget)column, "left", TableColumnLCA.getLeft(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_WIDTH, column.getWidth(), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_RESIZABLE, column.getResizable(), true);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_MOVEABLE, column.getMoveable(), false);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_ALIGNMENT, TableColumnLCA.getAlignment(column), "left");
        WidgetLCAUtil.renderProperty((Widget)column, PROP_FIXED, TableColumnLCA.isFixed(column), false);
        WidgetLCAUtil.renderListenSelection(column);
    }

    private static int getIndex(TableColumn column) {
        return column.getParent().indexOf(column);
    }

    static int getLeft(TableColumn column) {
        return TableColumnLCA.getTableAdapter(column).getColumnLeft(column);
    }

    private static String getAlignment(TableColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static Font getFont(TableColumn column) {
        Table table = column.getParent();
        IControlAdapter adapter = table.getAdapter(IControlAdapter.class);
        return adapter.getUserFont();
    }

    private static boolean isFixed(TableColumn column) {
        return TableColumnLCA.getTableAdapter(column).isFixedColumn(column);
    }

    private static ITableAdapter getTableAdapter(TableColumn column) {
        return column.getParent().getAdapter(ITableAdapter.class);
    }

    private TableColumnLCA() {
    }
}

