/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//    Denise Smith - May 2012
package org.eclipse.persistence.testing.jaxb.eventhandler;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class MyClass {
       @XmlAttribute
       public Integer myAttribute;
       @XmlElement
       public Integer myElement;
       @XmlAttribute
       public MyEnum myEnumAttribute;
       @XmlElement
       public MyEnum myEnumElement;

       public boolean equals(Object testObject){
           if(testObject instanceof MyClass){
               MyClass compareObject = (MyClass)testObject;
               if(myAttribute != compareObject.myAttribute || myElement != compareObject.myElement){
                   return false;
               }
               if(myEnumAttribute == null){
                   if(compareObject.myEnumAttribute != null){
                       return false;
                   }
               }else if(!myEnumAttribute.equals(compareObject.myEnumAttribute)){
                   return false;
               }
               if(myEnumElement == null){
                   if(compareObject.myEnumElement != null){
                       return false;
                   }
               }else if(!myEnumElement.equals(compareObject.myEnumElement)){
                   return false;
               }
               return true;
           }
           return false;
       }
}
