/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.models.inheritance;

import org.eclipse.persistence.tools.schemaframework.*;

/**
 * This class was generated by the TopLink table creator generator.
 * It stores the meta-data (tables) that define the database schema.
 * @see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator
 */
public class InheritanceTableCreator extends org.eclipse.persistence.tools.schemaframework.TableCreator {
    public InheritanceTableCreator() {
        setName("InheritanceProject");

        addTableDefinition(buildMAMMALTable());
        addTableDefinition(buildJAVAPROGRAMMERTable());
        addTableDefinition(buildANIMALTable());
        addTableDefinition(buildPROGRAMMERTable());
        addTableDefinition(buildALLIGATORTable());
        addTableDefinition(buildANIMAL_MATTTable());
        addTableDefinition(buildPRIMATETable());
        addTableDefinition(buildHUMAN_MTable());
        addTableDefinition(buildBUSTable());
        addTableDefinition(buildPROJECT_WORKER_BATCHTable());
        addTableDefinition(buildCOMPANYTable());
        addTableDefinition(buildINH_MFTable());
        addTableDefinition(buildINH_COMPTable());
        addTableDefinition(buildPROJECT_BATCHTable());
        addTableDefinition(buildBUDGETTED_PROJECT_BATCHTable());
        addTableDefinition(buildKING_DEVELOPERTable());
        addTableDefinition(buildA_KING2Table());
        addTableDefinition(buildCARTable());
        addTableDefinition(buildVEHICLETable());
        addTableDefinition(buildPERSON2Table());
        addTableDefinition(buildPARTNUMSTable());
        addTableDefinition(buildFUEL_VEHTable());
        addTableDefinition(buildKING_PERSONTable());
        addTableDefinition(buildINSECTTable());
        addTableDefinition(buildGRASSHOPPERTable());
        addTableDefinition(buildENTOMOLOGISTTable());
        addTableDefinition(buildLADYBUGTable());
        addTableDefinition(buildWORKERTable());
        addTableDefinition(buildTEACHERTable());
        addTableDefinition(buildFRUITTable());
    }

    public TableDefinition buildALLIGATORTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ALLIGATOR");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(18);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldFAVORITESWAMP = new FieldDefinition();
        fieldFAVORITESWAMP.setName("FAVORITESWAMP");
        fieldFAVORITESWAMP.setTypeName("VARCHAR2");
        fieldFAVORITESWAMP.setSize(255);
        fieldFAVORITESWAMP.setSubSize(0);
        fieldFAVORITESWAMP.setIsPrimaryKey(false);
        fieldFAVORITESWAMP.setIsIdentity(false);
        fieldFAVORITESWAMP.setUnique(false);
        fieldFAVORITESWAMP.setShouldAllowNull(true);
        table.addField(fieldFAVORITESWAMP);

        FieldDefinition fieldVICTIM_ID = new FieldDefinition();
        fieldVICTIM_ID.setName("VICTIM_ID");
        fieldVICTIM_ID.setTypeName("NUMBER");
        fieldVICTIM_ID.setSize(18);
        fieldVICTIM_ID.setSubSize(0);
        fieldVICTIM_ID.setIsPrimaryKey(false);
        fieldVICTIM_ID.setIsIdentity(false);
        fieldVICTIM_ID.setUnique(false);
        fieldVICTIM_ID.setShouldAllowNull(true);
        table.addField(fieldVICTIM_ID);

        ForeignKeyConstraint foreignKeyFK_ALLIGATOR_VICTIM_ID = new ForeignKeyConstraint();
        foreignKeyFK_ALLIGATOR_VICTIM_ID.setName("FK_ALL_VICTIM_ID");
        foreignKeyFK_ALLIGATOR_VICTIM_ID.setTargetTable("ANIMAL_MATT");
        foreignKeyFK_ALLIGATOR_VICTIM_ID.addSourceField("VICTIM_ID");
        foreignKeyFK_ALLIGATOR_VICTIM_ID.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyFK_ALLIGATOR_VICTIM_ID);

        return table;
    }

    public TableDefinition buildANIMALTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ANIMAL");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(18);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(255);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(240);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(true);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        return table;
    }

    public TableDefinition buildANIMAL_MATTTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ANIMAL_MATT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(18);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldANIMALSIZE = new FieldDefinition();
        fieldANIMALSIZE.setName("ANIMALSIZE");
        fieldANIMALSIZE.setTypeName("VARCHAR2");
        fieldANIMALSIZE.setSize(255);
        fieldANIMALSIZE.setSubSize(0);
        fieldANIMALSIZE.setIsPrimaryKey(false);
        fieldANIMALSIZE.setIsIdentity(false);
        fieldANIMALSIZE.setUnique(false);
        fieldANIMALSIZE.setShouldAllowNull(true);
        table.addField(fieldANIMALSIZE);

        FieldDefinition fieldSUBCLASS = new FieldDefinition();
        fieldSUBCLASS.setName("SUBCLASS");
        fieldSUBCLASS.setTypeName("VARCHAR2");
        fieldSUBCLASS.setSize(100);
        fieldSUBCLASS.setSubSize(0);
        fieldSUBCLASS.setIsPrimaryKey(false);
        fieldSUBCLASS.setIsIdentity(false);
        fieldSUBCLASS.setUnique(false);
        fieldSUBCLASS.setShouldAllowNull(true);
        table.addField(fieldSUBCLASS);

        return table;
    }

    public TableDefinition buildA_KING2Table() {
        TableDefinition table = new TableDefinition();
        table.setName("A_KING2");

        FieldDefinition fieldINDEX_KING2 = new FieldDefinition();
        fieldINDEX_KING2.setName("INDEX_KING2");
        fieldINDEX_KING2.setTypeName("NUMBER");
        fieldINDEX_KING2.setSize(15);
        fieldINDEX_KING2.setSubSize(0);
        fieldINDEX_KING2.setIsPrimaryKey(true);
        fieldINDEX_KING2.setIsIdentity(false);
        fieldINDEX_KING2.setUnique(false);
        fieldINDEX_KING2.setShouldAllowNull(false);
        table.addField(fieldINDEX_KING2);

        FieldDefinition fieldBAR = new FieldDefinition();
        fieldBAR.setName("BAR");
        fieldBAR.setTypeName("VARCHAR2");
        fieldBAR.setSize(20);
        fieldBAR.setSubSize(0);
        fieldBAR.setIsPrimaryKey(false);
        fieldBAR.setIsIdentity(false);
        fieldBAR.setUnique(false);
        fieldBAR.setShouldAllowNull(true);
        table.addField(fieldBAR);

        FieldDefinition fieldFOO = new FieldDefinition();
        fieldFOO.setName("FOO");
        fieldFOO.setTypeName("VARCHAR2");
        fieldFOO.setSize(20);
        fieldFOO.setSubSize(0);
        fieldFOO.setIsPrimaryKey(false);
        fieldFOO.setIsIdentity(false);
        fieldFOO.setUnique(false);
        fieldFOO.setShouldAllowNull(true);
        table.addField(fieldFOO);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("CHAR");
        fieldTYPE.setSize(1);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(true);
        table.addField(fieldTYPE);

        FieldDefinition fieldHA = new FieldDefinition();
        fieldHA.setName("HA");
        fieldHA.setTypeName("VARCHAR2");
        fieldHA.setSize(20);
        fieldHA.setSubSize(0);
        fieldHA.setIsPrimaryKey(false);
        fieldHA.setIsIdentity(false);
        fieldHA.setUnique(false);
        fieldHA.setShouldAllowNull(true);
        table.addField(fieldHA);

        return table;
    }

    public TableDefinition buildBUDGETTED_PROJECT_BATCHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("BUDGETTED_PROJECT_BATCH");

        FieldDefinition fieldBUDGET = new FieldDefinition();
        fieldBUDGET.setName("BUDGET");
        fieldBUDGET.setTypeName("NUMBER");
        fieldBUDGET.setSize(15);
        fieldBUDGET.setSubSize(0);
        fieldBUDGET.setIsPrimaryKey(false);
        fieldBUDGET.setIsIdentity(false);
        fieldBUDGET.setUnique(false);
        fieldBUDGET.setShouldAllowNull(true);
        table.addField(fieldBUDGET);

        FieldDefinition fieldPROJECT_ID = new FieldDefinition();
        fieldPROJECT_ID.setName("PROJECT_ID");
        fieldPROJECT_ID.setTypeName("NUMBER");
        fieldPROJECT_ID.setSize(15);
        fieldPROJECT_ID.setSubSize(0);
        fieldPROJECT_ID.setIsPrimaryKey(true);
        fieldPROJECT_ID.setIsIdentity(false);
        fieldPROJECT_ID.setUnique(false);
        fieldPROJECT_ID.setShouldAllowNull(false);
        table.addField(fieldPROJECT_ID);

        FieldDefinition fieldTITLE = new FieldDefinition();
        fieldTITLE.setName("TITLE");
        fieldTITLE.setTypeName("VARCHAR2");
        fieldTITLE.setSize(10);
        fieldTITLE.setSubSize(0);
        fieldTITLE.setIsPrimaryKey(false);
        fieldTITLE.setIsIdentity(false);
        fieldTITLE.setUnique(false);
        fieldTITLE.setShouldAllowNull(true);
        table.addField(fieldTITLE);

        ForeignKeyConstraint foreignKeyBUDGET_PROJECT_ID = new ForeignKeyConstraint();
        foreignKeyBUDGET_PROJECT_ID.setName("BUDGET_PROJECT_ID");
        foreignKeyBUDGET_PROJECT_ID.setTargetTable("PROJECT_BATCH");
        foreignKeyBUDGET_PROJECT_ID.addSourceField("PROJECT_ID");
        foreignKeyBUDGET_PROJECT_ID.addTargetField("PROJECT_ID");
        table.addForeignKeyConstraint(foreignKeyBUDGET_PROJECT_ID);

        return table;
    }

    public TableDefinition buildBUSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("BUS");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldDESCRIP = new FieldDefinition();
        fieldDESCRIP.setName("DESCRIP");
        fieldDESCRIP.setTypeName("VARCHAR2");
        fieldDESCRIP.setSize(30);
        fieldDESCRIP.setSubSize(0);
        fieldDESCRIP.setIsPrimaryKey(false);
        fieldDESCRIP.setIsIdentity(false);
        fieldDESCRIP.setUnique(false);
        fieldDESCRIP.setShouldAllowNull(true);
        table.addField(fieldDESCRIP);

        FieldDefinition fieldDRIVER_ID = new FieldDefinition();
        fieldDRIVER_ID.setName("DRIVER_ID");
        fieldDRIVER_ID.setTypeName("NUMBER");
        fieldDRIVER_ID.setSize(15);
        fieldDRIVER_ID.setSubSize(0);
        fieldDRIVER_ID.setIsPrimaryKey(false);
        fieldDRIVER_ID.setIsIdentity(false);
        fieldDRIVER_ID.setUnique(false);
        fieldDRIVER_ID.setShouldAllowNull(true);
        table.addField(fieldDRIVER_ID);

        ForeignKeyConstraint foreignKeyBUS_PERSON2 = new ForeignKeyConstraint();
        foreignKeyBUS_PERSON2.setName("BUS_PERSON2");
        foreignKeyBUS_PERSON2.setTargetTable("PERSON2");
        foreignKeyBUS_PERSON2.addSourceField("DRIVER_ID");
        foreignKeyBUS_PERSON2.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyBUS_PERSON2);

        ForeignKeyConstraint foreignKeyFK_BUS_FUEL_VEH_ID = new ForeignKeyConstraint();
        foreignKeyFK_BUS_FUEL_VEH_ID.setName("FK_BUS_FUEL_VEH_ID");
        foreignKeyFK_BUS_FUEL_VEH_ID.setTargetTable("FUEL_VEH");
        foreignKeyFK_BUS_FUEL_VEH_ID.addSourceField("ID");
        foreignKeyFK_BUS_FUEL_VEH_ID.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyFK_BUS_FUEL_VEH_ID);

        return table;
    }

    public TableDefinition buildCARTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CAR");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldCDESCRIP = new FieldDefinition();
        fieldCDESCRIP.setName("CDESCRIP");
        fieldCDESCRIP.setTypeName("VARCHAR2");
        fieldCDESCRIP.setSize(30);
        fieldCDESCRIP.setSubSize(0);
        fieldCDESCRIP.setIsPrimaryKey(false);
        fieldCDESCRIP.setIsIdentity(false);
        fieldCDESCRIP.setUnique(false);
        fieldCDESCRIP.setShouldAllowNull(true);
        table.addField(fieldCDESCRIP);

        FieldDefinition fieldFUEL_CAP = new FieldDefinition();
        fieldFUEL_CAP.setName("FUEL_CAP");
        fieldFUEL_CAP.setTypeName("NUMBER");
        fieldFUEL_CAP.setSize(10);
        fieldFUEL_CAP.setSubSize(0);
        fieldFUEL_CAP.setIsPrimaryKey(false);
        fieldFUEL_CAP.setIsIdentity(false);
        fieldFUEL_CAP.setUnique(false);
        fieldFUEL_CAP.setShouldAllowNull(true);
        table.addField(fieldFUEL_CAP);

        ForeignKeyConstraint foreignKeyFK_CAR_FUEL_VEH_ID = new ForeignKeyConstraint();
        foreignKeyFK_CAR_FUEL_VEH_ID.setName("FK_CAR_FUEL_VEH_ID");
        foreignKeyFK_CAR_FUEL_VEH_ID.setTargetTable("FUEL_VEH");
        foreignKeyFK_CAR_FUEL_VEH_ID.addSourceField("ID");
        foreignKeyFK_CAR_FUEL_VEH_ID.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyFK_CAR_FUEL_VEH_ID);

        return table;
    }

    public TableDefinition buildCOMPANYTable() {
        TableDefinition table = new TableDefinition();
        table.setName("COMPANY");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(100);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildENTOMOLOGISTTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ENTOMOLOGIST");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(0);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        return table;
    }

    public TableDefinition buildFUEL_VEHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("FUEL_VEH");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldFUEL_CAP = new FieldDefinition();
        fieldFUEL_CAP.setName("FUEL_CAP");
        fieldFUEL_CAP.setTypeName("NUMBER");
        fieldFUEL_CAP.setSize(10);
        fieldFUEL_CAP.setSubSize(0);
        fieldFUEL_CAP.setIsPrimaryKey(false);
        fieldFUEL_CAP.setIsIdentity(false);
        fieldFUEL_CAP.setUnique(false);
        fieldFUEL_CAP.setShouldAllowNull(true);
        table.addField(fieldFUEL_CAP);

        FieldDefinition fieldFUEL_TYP = new FieldDefinition();
        fieldFUEL_TYP.setName("FUEL_TYP");
        fieldFUEL_TYP.setTypeName("VARCHAR2");
        fieldFUEL_TYP.setSize(30);
        fieldFUEL_TYP.setSubSize(0);
        fieldFUEL_TYP.setIsPrimaryKey(false);
        fieldFUEL_TYP.setIsIdentity(false);
        fieldFUEL_TYP.setUnique(false);
        fieldFUEL_TYP.setShouldAllowNull(true);
        table.addField(fieldFUEL_TYP);

        ForeignKeyConstraint foreignKeyFUEL_VEH_VEHICLE = new ForeignKeyConstraint();
        foreignKeyFUEL_VEH_VEHICLE.setName("FUEL_VEH_VEHICLE");
        foreignKeyFUEL_VEH_VEHICLE.setTargetTable("VEHICLE");
        foreignKeyFUEL_VEH_VEHICLE.addSourceField("ID");
        foreignKeyFUEL_VEH_VEHICLE.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyFUEL_VEH_VEHICLE);

        return table;
    }

    public TableDefinition buildGRASSHOPPERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("GRASSHOPPER");

        FieldDefinition fieldGH_ID = new FieldDefinition();
        fieldGH_ID.setName("GH_ID");
        fieldGH_ID.setTypeName("NUMBER");
        fieldGH_ID.setSize(18);
        fieldGH_ID.setSubSize(0);
        fieldGH_ID.setIsPrimaryKey(true);
        fieldGH_ID.setIsIdentity(false);
        fieldGH_ID.setUnique(false);
        fieldGH_ID.setShouldAllowNull(false);
        table.addField(fieldGH_ID);

        FieldDefinition fieldGH_MAXIMUMJUMP = new FieldDefinition();
        fieldGH_MAXIMUMJUMP.setName("GH_MAXIMUMJUMP");
        fieldGH_MAXIMUMJUMP.setTypeName("NUMBER");
        fieldGH_MAXIMUMJUMP.setSize(18);
        fieldGH_MAXIMUMJUMP.setSubSize(0);
        fieldGH_MAXIMUMJUMP.setIsPrimaryKey(false);
        fieldGH_MAXIMUMJUMP.setIsIdentity(false);
        fieldGH_MAXIMUMJUMP.setUnique(false);
        fieldGH_MAXIMUMJUMP.setShouldAllowNull(true);
        table.addField(fieldGH_MAXIMUMJUMP);

        ForeignKeyConstraint foreignKeyGRASSHOPPER_INSECT = new ForeignKeyConstraint();
        foreignKeyGRASSHOPPER_INSECT.setName("GRASSHOPPER_INSECT");
        foreignKeyGRASSHOPPER_INSECT.setTargetTable("INSECT");
        foreignKeyGRASSHOPPER_INSECT.addSourceField("GH_ID");
        foreignKeyGRASSHOPPER_INSECT.addTargetField("IN_ID");
        table.addForeignKeyConstraint(foreignKeyGRASSHOPPER_INSECT);

        return table;
    }

    public TableDefinition buildHUMAN_MTable() {
        TableDefinition table = new TableDefinition();
        table.setName("HUMAN_M");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldTHE_NAME = new FieldDefinition();
        fieldTHE_NAME.setName("THE_NAME");
        fieldTHE_NAME.setTypeName("VARCHAR2");
        fieldTHE_NAME.setSize(255);
        fieldTHE_NAME.setSubSize(0);
        fieldTHE_NAME.setIsPrimaryKey(false);
        fieldTHE_NAME.setIsIdentity(false);
        fieldTHE_NAME.setUnique(false);
        fieldTHE_NAME.setShouldAllowNull(true);
        table.addField(fieldTHE_NAME);

        ForeignKeyConstraint foreignKeyHUMAN_M_PRIMATE = new ForeignKeyConstraint();
        foreignKeyHUMAN_M_PRIMATE.setName("HUMAN_M_PRIMATE");
        foreignKeyHUMAN_M_PRIMATE.setTargetTable("PRIMATE");
        foreignKeyHUMAN_M_PRIMATE.addSourceField("ID");
        foreignKeyHUMAN_M_PRIMATE.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyHUMAN_M_PRIMATE);

        return table;
    }

    public TableDefinition buildINH_COMPTable() {
        TableDefinition table = new TableDefinition();
        table.setName("INH_COMP");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldMEMORY = new FieldDefinition();
        fieldMEMORY.setName("MEMORY");
        fieldMEMORY.setTypeName("NUMBER");
        fieldMEMORY.setSize(10);
        fieldMEMORY.setSubSize(0);
        fieldMEMORY.setIsPrimaryKey(false);
        fieldMEMORY.setIsIdentity(false);
        fieldMEMORY.setUnique(false);
        fieldMEMORY.setShouldAllowNull(true);
        table.addField(fieldMEMORY);

        FieldDefinition fieldSPEED = new FieldDefinition();
        fieldSPEED.setName("SPEED");
        fieldSPEED.setTypeName("NUMBER");
        fieldSPEED.setSize(10);
        fieldSPEED.setSubSize(0);
        fieldSPEED.setIsPrimaryKey(false);
        fieldSPEED.setIsIdentity(false);
        fieldSPEED.setUnique(false);
        fieldSPEED.setShouldAllowNull(true);
        table.addField(fieldSPEED);

        FieldDefinition fieldMAKE = new FieldDefinition();
        fieldMAKE.setName("MAKE");
        fieldMAKE.setTypeName("VARCHAR2");
        fieldMAKE.setSize(100);
        fieldMAKE.setSubSize(0);
        fieldMAKE.setIsPrimaryKey(false);
        fieldMAKE.setIsIdentity(false);
        fieldMAKE.setUnique(false);
        fieldMAKE.setShouldAllowNull(true);
        table.addField(fieldMAKE);

        FieldDefinition fieldMANUFAC = new FieldDefinition();
        fieldMANUFAC.setName("MANUFAC");
        fieldMANUFAC.setTypeName("VARCHAR2");
        fieldMANUFAC.setSize(100);
        fieldMANUFAC.setSubSize(0);
        fieldMANUFAC.setIsPrimaryKey(false);
        fieldMANUFAC.setIsIdentity(false);
        fieldMANUFAC.setUnique(false);
        fieldMANUFAC.setShouldAllowNull(true);
        table.addField(fieldMANUFAC);

        FieldDefinition fieldCTYPE = new FieldDefinition();
        fieldCTYPE.setName("CTYPE");
        fieldCTYPE.setTypeName("VARCHAR2");
        fieldCTYPE.setSize(20);
        fieldCTYPE.setSubSize(0);
        fieldCTYPE.setIsPrimaryKey(false);
        fieldCTYPE.setIsIdentity(false);
        fieldCTYPE.setUnique(false);
        fieldCTYPE.setShouldAllowNull(true);
        table.addField(fieldCTYPE);

        FieldDefinition fieldPCTYPE = new FieldDefinition();
        fieldPCTYPE.setName("PCTYPE");
        fieldPCTYPE.setTypeName("VARCHAR2");
        fieldPCTYPE.setSize(20);
        fieldPCTYPE.setSubSize(0);
        fieldPCTYPE.setIsPrimaryKey(false);
        fieldPCTYPE.setIsIdentity(false);
        fieldPCTYPE.setUnique(false);
        fieldPCTYPE.setShouldAllowNull(true);
        table.addField(fieldPCTYPE);

        FieldDefinition fieldCLONE = new FieldDefinition();
        fieldCLONE.setName("CLONE");
        fieldCLONE.setTypeName("VARCHAR2");
        fieldCLONE.setSize(255);
        fieldCLONE.setSubSize(0);
        fieldCLONE.setIsPrimaryKey(false);
        fieldCLONE.setIsIdentity(false);
        fieldCLONE.setUnique(false);
        fieldCLONE.setShouldAllowNull(true);
        table.addField(fieldCLONE);

        return table;
    }

    public TableDefinition buildINH_MFTable() {
        TableDefinition table = new TableDefinition();
        table.setName("INH_MF");

        FieldDefinition fieldMF_ID = new FieldDefinition();
        fieldMF_ID.setName("MF_ID");
        fieldMF_ID.setTypeName("NUMBER");
        fieldMF_ID.setSize(10);
        fieldMF_ID.setSubSize(0);
        fieldMF_ID.setIsPrimaryKey(true);
        fieldMF_ID.setIsIdentity(false);
        fieldMF_ID.setUnique(false);
        fieldMF_ID.setShouldAllowNull(false);
        table.addField(fieldMF_ID);

        FieldDefinition fieldPROCS = new FieldDefinition();
        fieldPROCS.setName("PROCS");
        fieldPROCS.setTypeName("NUMBER");
        fieldPROCS.setSize(10);
        fieldPROCS.setSubSize(0);
        fieldPROCS.setIsPrimaryKey(false);
        fieldPROCS.setIsIdentity(false);
        fieldPROCS.setUnique(false);
        fieldPROCS.setShouldAllowNull(true);
        table.addField(fieldPROCS);

        ForeignKeyConstraint foreignKeyINH_MF_INH_COMP = new ForeignKeyConstraint();
        foreignKeyINH_MF_INH_COMP.setName("INH_MF_INH_COMP");
        foreignKeyINH_MF_INH_COMP.setTargetTable("INH_COMP");
        foreignKeyINH_MF_INH_COMP.addSourceField("MF_ID");
        foreignKeyINH_MF_INH_COMP.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyINH_MF_INH_COMP);

        return table;
    }

    public TableDefinition buildINSECTTable() {
        TableDefinition table = new TableDefinition();
        table.setName("INSECT");

        FieldDefinition fieldIN_ID = new FieldDefinition();
        fieldIN_ID.setName("IN_ID");
        fieldIN_ID.setTypeName("NUMBER");
        fieldIN_ID.setSize(18);
        fieldIN_ID.setSubSize(0);
        fieldIN_ID.setIsPrimaryKey(true);
        fieldIN_ID.setIsIdentity(false);
        fieldIN_ID.setUnique(false);
        fieldIN_ID.setShouldAllowNull(false);
        table.addField(fieldIN_ID);

        FieldDefinition fieldIN_TYPE = new FieldDefinition();
        fieldIN_TYPE.setName("IN_TYPE");
        fieldIN_TYPE.setTypeName("VARCHAR2");
        fieldIN_TYPE.setSize(255);
        fieldIN_TYPE.setSubSize(0);
        fieldIN_TYPE.setIsPrimaryKey(false);
        fieldIN_TYPE.setIsIdentity(false);
        fieldIN_TYPE.setUnique(false);
        fieldIN_TYPE.setShouldAllowNull(true);
        table.addField(fieldIN_TYPE);

        FieldDefinition fieldIN_NUMBEROFLEGS = new FieldDefinition();
        fieldIN_NUMBEROFLEGS.setName("IN_NUMBEROFLEGS");
        fieldIN_NUMBEROFLEGS.setTypeName("NUMBER");
        fieldIN_NUMBEROFLEGS.setSize(18);
        fieldIN_NUMBEROFLEGS.setSubSize(0);
        fieldIN_NUMBEROFLEGS.setIsPrimaryKey(false);
        fieldIN_NUMBEROFLEGS.setIsIdentity(false);
        fieldIN_NUMBEROFLEGS.setUnique(false);
        fieldIN_NUMBEROFLEGS.setShouldAllowNull(true);
        table.addField(fieldIN_NUMBEROFLEGS);

        FieldDefinition fieldENTOMOLOGIST = new FieldDefinition();
        fieldENTOMOLOGIST.setName("ENTOMOLOGIST");
        fieldENTOMOLOGIST.setTypeName("NUMBER");
        fieldENTOMOLOGIST.setSize(18);
        fieldENTOMOLOGIST.setSubSize(0);
        fieldENTOMOLOGIST.setIsPrimaryKey(false);
        fieldENTOMOLOGIST.setIsIdentity(false);
        fieldENTOMOLOGIST.setUnique(false);
        fieldENTOMOLOGIST.setShouldAllowNull(true);
        table.addField(fieldENTOMOLOGIST);
        return table;
    }

    public TableDefinition buildJAVAPROGRAMMERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("JAVAPROGRAMMER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNUMBER_OF_SUPPORT = new FieldDefinition();
        fieldNUMBER_OF_SUPPORT.setName("NUMBER_OF_SUPPORT");
        fieldNUMBER_OF_SUPPORT.setTypeName("NUMBER");
        fieldNUMBER_OF_SUPPORT.setSize(10);
        fieldNUMBER_OF_SUPPORT.setSubSize(0);
        fieldNUMBER_OF_SUPPORT.setIsPrimaryKey(false);
        fieldNUMBER_OF_SUPPORT.setIsIdentity(false);
        fieldNUMBER_OF_SUPPORT.setUnique(false);
        fieldNUMBER_OF_SUPPORT.setShouldAllowNull(false);
        table.addField(fieldNUMBER_OF_SUPPORT);

        ForeignKeyConstraint foreignKeyJAVAPROGRAMMER_PROGRAMMER = new ForeignKeyConstraint();
        foreignKeyJAVAPROGRAMMER_PROGRAMMER.setName("JAVAP_P");
        foreignKeyJAVAPROGRAMMER_PROGRAMMER.setTargetTable("PROGRAMMER");
        foreignKeyJAVAPROGRAMMER_PROGRAMMER.addSourceField("ID");
        foreignKeyJAVAPROGRAMMER_PROGRAMMER.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyJAVAPROGRAMMER_PROGRAMMER);

        return table;
    }

    public TableDefinition buildKING_DEVELOPERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("KING_DEVELOPER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldCODEINDEX = new FieldDefinition();
        fieldCODEINDEX.setName("CODEINDEX");
        fieldCODEINDEX.setTypeName("NUMBER");
        fieldCODEINDEX.setSize(6);
        fieldCODEINDEX.setSubSize(0);
        fieldCODEINDEX.setIsPrimaryKey(false);
        fieldCODEINDEX.setIsIdentity(false);
        fieldCODEINDEX.setUnique(false);
        fieldCODEINDEX.setShouldAllowNull(true);
        table.addField(fieldCODEINDEX);

        FieldDefinition fieldOFF_NUM = new FieldDefinition();
        fieldOFF_NUM.setName("OFF_NUM");
        fieldOFF_NUM.setTypeName("NUMBER");
        fieldOFF_NUM.setSize(6);
        fieldOFF_NUM.setSubSize(0);
        fieldOFF_NUM.setIsPrimaryKey(false);
        fieldOFF_NUM.setIsIdentity(false);
        fieldOFF_NUM.setUnique(false);
        fieldOFF_NUM.setShouldAllowNull(true);
        table.addField(fieldOFF_NUM);

        FieldDefinition fieldRESPONS = new FieldDefinition();
        fieldRESPONS.setName("RESPONS");
        fieldRESPONS.setTypeName("VARCHAR2");
        fieldRESPONS.setSize(100);
        fieldRESPONS.setSubSize(0);
        fieldRESPONS.setIsPrimaryKey(false);
        fieldRESPONS.setIsIdentity(false);
        fieldRESPONS.setUnique(false);
        fieldRESPONS.setShouldAllowNull(true);
        table.addField(fieldRESPONS);

        ForeignKeyConstraint foreignKeyDEVELOPER_KING_PERSON_KING = new ForeignKeyConstraint();
        foreignKeyDEVELOPER_KING_PERSON_KING.setName("DEVLOPER_PERSON");
        foreignKeyDEVELOPER_KING_PERSON_KING.setTargetTable("KING_PERSON");
        foreignKeyDEVELOPER_KING_PERSON_KING.addSourceField("ID");
        foreignKeyDEVELOPER_KING_PERSON_KING.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyDEVELOPER_KING_PERSON_KING);

        return table;
    }

    public TableDefinition buildKING_PERSONTable() {
        TableDefinition table = new TableDefinition();
        table.setName("KING_PERSON");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldPERSON_TYPE = new FieldDefinition();
        fieldPERSON_TYPE.setName("PERSON_TYPE");
        fieldPERSON_TYPE.setTypeName("VARCHAR2");
        fieldPERSON_TYPE.setSize(10);
        fieldPERSON_TYPE.setSubSize(0);
        fieldPERSON_TYPE.setIsPrimaryKey(false);
        fieldPERSON_TYPE.setIsIdentity(false);
        fieldPERSON_TYPE.setUnique(false);
        fieldPERSON_TYPE.setShouldAllowNull(true);
        table.addField(fieldPERSON_TYPE);

        return table;
    }

    public TableDefinition buildLADYBUGTable() {
        TableDefinition table = new TableDefinition();
        table.setName("LADYBUG");

        FieldDefinition fieldLB_ID = new FieldDefinition();
        fieldLB_ID.setName("LB_ID");
        fieldLB_ID.setTypeName("NUMBER");
        fieldLB_ID.setSize(18);
        fieldLB_ID.setSubSize(0);
        fieldLB_ID.setIsPrimaryKey(true);
        fieldLB_ID.setIsIdentity(false);
        fieldLB_ID.setUnique(false);
        fieldLB_ID.setShouldAllowNull(false);
        table.addField(fieldLB_ID);

        FieldDefinition fieldLB_NUMBEROFSPOTS = new FieldDefinition();
        fieldLB_NUMBEROFSPOTS.setName("LB_NUMBEROFSPOTS");
        fieldLB_NUMBEROFSPOTS.setTypeName("NUMBER");
        fieldLB_NUMBEROFSPOTS.setSize(18);
        fieldLB_NUMBEROFSPOTS.setSubSize(0);
        fieldLB_NUMBEROFSPOTS.setIsPrimaryKey(false);
        fieldLB_NUMBEROFSPOTS.setIsIdentity(false);
        fieldLB_NUMBEROFSPOTS.setUnique(false);
        fieldLB_NUMBEROFSPOTS.setShouldAllowNull(true);
        table.addField(fieldLB_NUMBEROFSPOTS);

        ForeignKeyConstraint foreignKeyLADYBUG_INSECT = new ForeignKeyConstraint();
        foreignKeyLADYBUG_INSECT.setName("LADYBUG_INSECT");
        foreignKeyLADYBUG_INSECT.setTargetTable("INSECT");
        foreignKeyLADYBUG_INSECT.addSourceField("LB_ID");
        foreignKeyLADYBUG_INSECT.addTargetField("IN_ID");
        table.addForeignKeyConstraint(foreignKeyLADYBUG_INSECT);

        return table;
    }

    public TableDefinition buildMAMMALTable() {
        TableDefinition table = new TableDefinition();
        table.setName("MAMMAL");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldWEIGHT = new FieldDefinition();
        fieldWEIGHT.setName("WEIGHT");
        fieldWEIGHT.setTypeName("NUMBER");
        fieldWEIGHT.setSize(10);
        fieldWEIGHT.setSubSize(0);
        fieldWEIGHT.setIsPrimaryKey(false);
        fieldWEIGHT.setIsIdentity(false);
        fieldWEIGHT.setUnique(false);
        fieldWEIGHT.setShouldAllowNull(false);
        table.addField(fieldWEIGHT);

        return table;
    }

    public TableDefinition buildPARTNUMSTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PARTNUMS");

        FieldDefinition fieldVEHIC_ID = new FieldDefinition();
        fieldVEHIC_ID.setName("VEHIC_ID");
        fieldVEHIC_ID.setTypeName("NUMBER");
        fieldVEHIC_ID.setSize(15);
        fieldVEHIC_ID.setSubSize(0);
        fieldVEHIC_ID.setIsPrimaryKey(false);
        fieldVEHIC_ID.setIsIdentity(false);
        fieldVEHIC_ID.setUnique(false);
        fieldVEHIC_ID.setShouldAllowNull(true);
        table.addField(fieldVEHIC_ID);

        FieldDefinition fieldPART_NUM = new FieldDefinition();
        fieldPART_NUM.setName("PART_NUM");
        fieldPART_NUM.setTypeName("VARCHAR2");
        fieldPART_NUM.setSize(30);
        fieldPART_NUM.setSubSize(0);
        fieldPART_NUM.setIsPrimaryKey(false);
        fieldPART_NUM.setIsIdentity(false);
        fieldPART_NUM.setUnique(false);
        fieldPART_NUM.setShouldAllowNull(true);
        table.addField(fieldPART_NUM);

        ForeignKeyConstraint foreignKeyPARTNUMS_VEHICLE = new ForeignKeyConstraint();
        foreignKeyPARTNUMS_VEHICLE.setName("PARTNUMS_VEHICLE");
        foreignKeyPARTNUMS_VEHICLE.setTargetTable("VEHICLE");
        foreignKeyPARTNUMS_VEHICLE.addSourceField("VEHIC_ID");
        foreignKeyPARTNUMS_VEHICLE.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPARTNUMS_VEHICLE);

        return table;
    }

    public TableDefinition buildPERSON2Table() {
        TableDefinition table = new TableDefinition();
        table.setName("PERSON2");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldC_TYPE = new FieldDefinition();
        fieldC_TYPE.setName("C_TYPE");
        fieldC_TYPE.setTypeName("VARCHAR2");
        fieldC_TYPE.setSize(100);
        fieldC_TYPE.setSubSize(0);
        fieldC_TYPE.setIsPrimaryKey(false);
        fieldC_TYPE.setIsIdentity(false);
        fieldC_TYPE.setUnique(false);
        fieldC_TYPE.setShouldAllowNull(true);
        table.addField(fieldC_TYPE);

        FieldDefinition fieldKNOWS_JAVA = new FieldDefinition();
        fieldKNOWS_JAVA.setName("KNOWS_JAVA");
        fieldKNOWS_JAVA.setTypeName("VARCHAR2");
        fieldKNOWS_JAVA.setSize(1);
        fieldKNOWS_JAVA.setSubSize(0);
        fieldKNOWS_JAVA.setIsPrimaryKey(false);
        fieldKNOWS_JAVA.setIsIdentity(false);
        fieldKNOWS_JAVA.setUnique(false);
        fieldKNOWS_JAVA.setShouldAllowNull(true);
        table.addField(fieldKNOWS_JAVA);

        FieldDefinition fieldBOSS_ID = new FieldDefinition();
        fieldBOSS_ID.setName("BOSS_ID");
        fieldBOSS_ID.setTypeName("NUMBER");
        fieldBOSS_ID.setSize(15);
        fieldBOSS_ID.setSubSize(0);
        fieldBOSS_ID.setIsPrimaryKey(false);
        fieldBOSS_ID.setIsIdentity(false);
        fieldBOSS_ID.setUnique(false);
        fieldBOSS_ID.setShouldAllowNull(true);
        table.addField(fieldBOSS_ID);

        FieldDefinition fieldREP_ID = new FieldDefinition();
        fieldREP_ID.setName("REP_ID");
        fieldREP_ID.setTypeName("NUMBER");
        fieldREP_ID.setSize(15);
        fieldREP_ID.setSubSize(0);
        fieldREP_ID.setIsPrimaryKey(false);
        fieldREP_ID.setIsIdentity(false);
        fieldREP_ID.setUnique(false);
        fieldREP_ID.setShouldAllowNull(true);
        table.addField(fieldREP_ID);

        FieldDefinition fieldFRIEND_ID = new FieldDefinition();
        fieldFRIEND_ID.setName("FRIEND_ID");
        fieldFRIEND_ID.setTypeName("NUMBER");
        fieldFRIEND_ID.setSize(15);
        fieldFRIEND_ID.setSubSize(0);
        fieldFRIEND_ID.setIsPrimaryKey(false);
        fieldFRIEND_ID.setIsIdentity(false);
        fieldFRIEND_ID.setUnique(false);
        fieldFRIEND_ID.setShouldAllowNull(true);
        table.addField(fieldFRIEND_ID);

        FieldDefinition fieldCAR_ID = new FieldDefinition();
        fieldCAR_ID.setName("CAR_ID");
        fieldCAR_ID.setTypeName("NUMBER");
        fieldCAR_ID.setSize(15);
        fieldCAR_ID.setSubSize(0);
        fieldCAR_ID.setIsPrimaryKey(false);
        fieldCAR_ID.setIsIdentity(false);
        fieldCAR_ID.setUnique(false);
        fieldCAR_ID.setShouldAllowNull(true);
        table.addField(fieldCAR_ID);

        ForeignKeyConstraint foreignKeyPERSON2_PERSON2_FRND = new ForeignKeyConstraint();
        foreignKeyPERSON2_PERSON2_FRND.setName("PER2_PER2_FRND");
        foreignKeyPERSON2_PERSON2_FRND.setTargetTable("PERSON2");
        foreignKeyPERSON2_PERSON2_FRND.addSourceField("FRIEND_ID");
        foreignKeyPERSON2_PERSON2_FRND.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON2_PERSON2_FRND);

        ForeignKeyConstraint foreignKeyPERSON2_CAR = new ForeignKeyConstraint();
        foreignKeyPERSON2_CAR.setName("PERSON2_CAR");
        foreignKeyPERSON2_CAR.setTargetTable("CAR");
        foreignKeyPERSON2_CAR.addSourceField("CAR_ID");
        foreignKeyPERSON2_CAR.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON2_CAR);

        ForeignKeyConstraint foreignKeyPERSON2_PERSON2_REP = new ForeignKeyConstraint();
        foreignKeyPERSON2_PERSON2_REP.setName("PER2_PER2_REP");
        foreignKeyPERSON2_PERSON2_REP.setTargetTable("PERSON2");
        foreignKeyPERSON2_PERSON2_REP.addSourceField("REP_ID");
        foreignKeyPERSON2_PERSON2_REP.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON2_PERSON2_REP);

        ForeignKeyConstraint foreignKeyPERSON2_PERSON2_BS = new ForeignKeyConstraint();
        foreignKeyPERSON2_PERSON2_BS.setName("PER2_PER2_BS");
        foreignKeyPERSON2_PERSON2_BS.setTargetTable("PERSON2");
        foreignKeyPERSON2_PERSON2_BS.addSourceField("BOSS_ID");
        foreignKeyPERSON2_PERSON2_BS.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyPERSON2_PERSON2_BS);

        return table;
    }

    public TableDefinition buildPRIMATETable() {
        TableDefinition table = new TableDefinition();
        table.setName("PRIMATE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("VARCHAR2");
        fieldGENDER.setSize(255);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        return table;
    }

    public TableDefinition buildPROGRAMMERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PROGRAMMER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(10);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldSALARY = new FieldDefinition();
        fieldSALARY.setName("SALARY");
        fieldSALARY.setTypeName("NUMBER");
        fieldSALARY.setSize(10);
        fieldSALARY.setSubSize(0);
        fieldSALARY.setIsPrimaryKey(false);
        fieldSALARY.setIsIdentity(false);
        fieldSALARY.setUnique(false);
        fieldSALARY.setShouldAllowNull(false);
        table.addField(fieldSALARY);

        return table;
    }

    public TableDefinition buildPROJECT_BATCHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PROJECT_BATCH");

        FieldDefinition fieldPERSON_ID = new FieldDefinition();
        fieldPERSON_ID.setName("PERSON_ID");
        fieldPERSON_ID.setTypeName("NUMBER");
        fieldPERSON_ID.setSize(15);
        fieldPERSON_ID.setSubSize(0);
        fieldPERSON_ID.setIsPrimaryKey(false);
        fieldPERSON_ID.setIsIdentity(false);
        fieldPERSON_ID.setUnique(false);
        fieldPERSON_ID.setShouldAllowNull(true);
        table.addField(fieldPERSON_ID);

        FieldDefinition fieldPROJECT_ID = new FieldDefinition();
        fieldPROJECT_ID.setName("PROJECT_ID");
        fieldPROJECT_ID.setTypeName("NUMBER");
        fieldPROJECT_ID.setSize(15);
        fieldPROJECT_ID.setSubSize(0);
        fieldPROJECT_ID.setIsPrimaryKey(true);
        fieldPROJECT_ID.setIsIdentity(false);
        fieldPROJECT_ID.setUnique(false);
        fieldPROJECT_ID.setShouldAllowNull(false);
        table.addField(fieldPROJECT_ID);

        FieldDefinition fieldPROJECT_NAME = new FieldDefinition();
        fieldPROJECT_NAME.setName("PROJECT_NAME");
        fieldPROJECT_NAME.setTypeName("VARCHAR2");
        fieldPROJECT_NAME.setSize(30);
        fieldPROJECT_NAME.setSubSize(0);
        fieldPROJECT_NAME.setIsPrimaryKey(false);
        fieldPROJECT_NAME.setIsIdentity(false);
        fieldPROJECT_NAME.setUnique(false);
        fieldPROJECT_NAME.setShouldAllowNull(true);
        table.addField(fieldPROJECT_NAME);

        FieldDefinition fieldPROJECT_TYPE = new FieldDefinition();
        fieldPROJECT_TYPE.setName("PROJECT_TYPE");
        fieldPROJECT_TYPE.setTypeName("VARCHAR2");
        fieldPROJECT_TYPE.setSize(20);
        fieldPROJECT_TYPE.setSubSize(0);
        fieldPROJECT_TYPE.setIsPrimaryKey(false);
        fieldPROJECT_TYPE.setIsIdentity(false);
        fieldPROJECT_TYPE.setUnique(false);
        fieldPROJECT_TYPE.setShouldAllowNull(true);
        table.addField(fieldPROJECT_TYPE);

        ForeignKeyConstraint foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH = new ForeignKeyConstraint();
        foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH.setName("PRJ_WK_BATCH_FK");
        foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH.setTargetTable("PROJECT_WORKER_BATCH");
        foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH.addSourceField("PERSON_ID");
        foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH.addTargetField("PERSON_ID");
        table.addForeignKeyConstraint(foreignKeyPROJECT_BATCH_PROJECT_WORKER_BATCH);

        return table;
    }

    public TableDefinition buildPROJECT_WORKER_BATCHTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PROJECT_WORKER_BATCH");

        FieldDefinition fieldPERSON_ID = new FieldDefinition();
        fieldPERSON_ID.setName("PERSON_ID");
        fieldPERSON_ID.setTypeName("NUMBER");
        fieldPERSON_ID.setSize(15);
        fieldPERSON_ID.setSubSize(0);
        fieldPERSON_ID.setIsPrimaryKey(true);
        fieldPERSON_ID.setIsIdentity(false);
        fieldPERSON_ID.setUnique(false);
        fieldPERSON_ID.setShouldAllowNull(false);
        table.addField(fieldPERSON_ID);

        FieldDefinition fieldPERSON_LAST_NAME = new FieldDefinition();
        fieldPERSON_LAST_NAME.setName("PERSON_LAST_NAME");
        fieldPERSON_LAST_NAME.setTypeName("VARCHAR2");
        fieldPERSON_LAST_NAME.setSize(40);
        fieldPERSON_LAST_NAME.setSubSize(0);
        fieldPERSON_LAST_NAME.setIsPrimaryKey(false);
        fieldPERSON_LAST_NAME.setIsIdentity(false);
        fieldPERSON_LAST_NAME.setUnique(false);
        fieldPERSON_LAST_NAME.setShouldAllowNull(true);
        table.addField(fieldPERSON_LAST_NAME);

        FieldDefinition fieldPERSON_NAME = new FieldDefinition();
        fieldPERSON_NAME.setName("PERSON_NAME");
        fieldPERSON_NAME.setTypeName("VARCHAR2");
        fieldPERSON_NAME.setSize(40);
        fieldPERSON_NAME.setSubSize(0);
        fieldPERSON_NAME.setIsPrimaryKey(false);
        fieldPERSON_NAME.setIsIdentity(false);
        fieldPERSON_NAME.setUnique(false);
        fieldPERSON_NAME.setShouldAllowNull(true);
        table.addField(fieldPERSON_NAME);

        FieldDefinition fieldPROJECT_ID = new FieldDefinition();
        fieldPROJECT_ID.setName("PROJECT_ID");
        fieldPROJECT_ID.setTypeName("NUMBER");
        fieldPROJECT_ID.setSize(15);
        fieldPROJECT_ID.setSubSize(0);
        fieldPROJECT_ID.setIsPrimaryKey(false);
        fieldPROJECT_ID.setIsIdentity(false);
        fieldPROJECT_ID.setUnique(false);
        fieldPROJECT_ID.setShouldAllowNull(true);
        table.addField(fieldPROJECT_ID);

        ForeignKeyConstraint foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD = new ForeignKeyConstraint();
        foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD.setName("PRJ_WK_BATCH_HD");
        foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD.setTargetTable("PROJECT_BATCH");
        foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD.addSourceField("PROJECT_ID");
        foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD.addTargetField("PROJECT_ID");
        table.addForeignKeyConstraint(foreignKeyPROJECT_WORKER_BATCH_PROJECT_BATCH_HD);

        return table;
    }

    public TableDefinition buildVEHICLETable() {
        TableDefinition table = new TableDefinition();
        table.setName("VEHICLE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("NUMBER");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(true);
        table.addField(fieldTYPE);

        FieldDefinition fieldCAPACITY = new FieldDefinition();
        fieldCAPACITY.setName("CAPACITY");
        fieldCAPACITY.setTypeName("NUMBER");
        fieldCAPACITY.setSize(10);
        fieldCAPACITY.setSubSize(0);
        fieldCAPACITY.setIsPrimaryKey(false);
        fieldCAPACITY.setIsIdentity(false);
        fieldCAPACITY.setUnique(false);
        fieldCAPACITY.setShouldAllowNull(true);
        table.addField(fieldCAPACITY);

        FieldDefinition fieldOWNER_ID = new FieldDefinition();
        fieldOWNER_ID.setName("OWNER_ID");
        fieldOWNER_ID.setTypeName("NUMBER");
        fieldOWNER_ID.setSize(15);
        fieldOWNER_ID.setSubSize(0);
        fieldOWNER_ID.setIsPrimaryKey(false);
        fieldOWNER_ID.setIsIdentity(false);
        fieldOWNER_ID.setUnique(false);
        fieldOWNER_ID.setShouldAllowNull(true);
        table.addField(fieldOWNER_ID);

        FieldDefinition fieldBICY_DES = new FieldDefinition();
        fieldBICY_DES.setName("BICY_DES");
        fieldBICY_DES.setTypeName("VARCHAR2");
        fieldBICY_DES.setSize(30);
        fieldBICY_DES.setSubSize(0);
        fieldBICY_DES.setIsPrimaryKey(false);
        fieldBICY_DES.setIsIdentity(false);
        fieldBICY_DES.setUnique(false);
        fieldBICY_DES.setShouldAllowNull(true);
        table.addField(fieldBICY_DES);

        ForeignKeyConstraint foreignKeyVEHICLE_COMPANY = new ForeignKeyConstraint();
        foreignKeyVEHICLE_COMPANY.setName("VEHICLE_COMPANY");
        foreignKeyVEHICLE_COMPANY.setTargetTable("COMPANY");
        foreignKeyVEHICLE_COMPANY.addSourceField("OWNER_ID");
        foreignKeyVEHICLE_COMPANY.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyVEHICLE_COMPANY);

        return table;
    }

    public TableDefinition buildWORKERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("WORKER2");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(15);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(true);
        table.addField(fieldNAME);

        FieldDefinition fieldW_TYPE = new FieldDefinition();
        fieldW_TYPE.setName("W_TYPE");
        fieldW_TYPE.setTypeName("VARCHAR2");
        fieldW_TYPE.setSize(100);
        fieldW_TYPE.setSubSize(0);
        fieldW_TYPE.setIsPrimaryKey(false);
        fieldW_TYPE.setIsIdentity(false);
        fieldW_TYPE.setUnique(false);
        fieldW_TYPE.setShouldAllowNull(true);
        table.addField(fieldW_TYPE);

        FieldDefinition fieldCOMPANY_ID = new FieldDefinition();
        fieldCOMPANY_ID.setName("COMPANY_ID");
        fieldCOMPANY_ID.setTypeName("NUMBER");
        fieldCOMPANY_ID.setSize(15);
        fieldCOMPANY_ID.setSubSize(0);
        fieldCOMPANY_ID.setIsPrimaryKey(false);
        fieldCOMPANY_ID.setIsIdentity(false);
        fieldCOMPANY_ID.setUnique(false);
        fieldCOMPANY_ID.setShouldAllowNull(true);
        table.addField(fieldCOMPANY_ID);

        ForeignKeyConstraint foreignKeyWORKER_COMPANY = new ForeignKeyConstraint();
        foreignKeyWORKER_COMPANY.setName("WORKER_COMPANY");
        foreignKeyWORKER_COMPANY.setTargetTable("COMPANY");
        foreignKeyWORKER_COMPANY.addSourceField("COMPANY_ID");
        foreignKeyWORKER_COMPANY.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyWORKER_COMPANY);

        return table;
    }

    public TableDefinition buildFRUITTable() {
        TableDefinition table = new TableDefinition();
        table.setName("FRUIT");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(0);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(20);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(false);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        FieldDefinition fieldQUALITY = new FieldDefinition();
        fieldQUALITY.setName("QUALITY");
        fieldQUALITY.setTypeName("VARCHAR2");
        fieldQUALITY.setSize(20);
        fieldQUALITY.setSubSize(0);
        fieldQUALITY.setIsPrimaryKey(false);
        fieldQUALITY.setIsIdentity(false);
        fieldQUALITY.setUnique(false);
        fieldQUALITY.setShouldAllowNull(true);
        table.addField(fieldQUALITY);

        FieldDefinition fieldTEACHER_ID = new FieldDefinition();
        fieldTEACHER_ID.setName("TEACHER_ID");
        fieldTEACHER_ID.setTypeName("NUMBER");
        fieldTEACHER_ID.setSize(0);
        fieldTEACHER_ID.setSubSize(0);
        fieldTEACHER_ID.setIsPrimaryKey(false);
        fieldTEACHER_ID.setIsIdentity(false);
        fieldTEACHER_ID.setUnique(false);
        fieldTEACHER_ID.setShouldAllowNull(true);
        table.addField(fieldTEACHER_ID);

        ForeignKeyConstraint foreignKeyFRUIT_TEACHER = new ForeignKeyConstraint();
        foreignKeyFRUIT_TEACHER.setName("FRUIT_TEACHER");
        foreignKeyFRUIT_TEACHER.setTargetTable("TEACHER");
        foreignKeyFRUIT_TEACHER.addSourceField("TEACHER_ID");
        foreignKeyFRUIT_TEACHER.addTargetField("ID");
        table.addForeignKeyConstraint(foreignKeyFRUIT_TEACHER);

        return table;
    }

    public TableDefinition buildTEACHERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TEACHER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(0);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);

        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);

        return table;
    }

}
