/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.util.ArrayList;
import org.eclipse.ecf.server.generic.app.SSLAbstractGenericServerApplication;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class SSLGenericServerApplication
extends SSLAbstractGenericServerApplication
implements IApplication {
    protected final Object appLock = new Object();
    protected boolean done = false;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = this.getArguments(context);
        this.processArguments(args);
        this.initialize();
        if (this.configURL != null) {
            System.out.println("SSL Generic server started with config from " + this.configURL);
        } else {
            System.out.println("SSL Generic server started with id=" + this.serverName);
        }
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.shutdown();
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected String[] getArguments(IApplicationContext context) {
        String[] originalArgs = (String[])context.getArguments().get("application.args");
        if (originalArgs == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < originalArgs.length) {
            if (!originalArgs[i].equals("-pdelaunch")) {
                l.add(originalArgs[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }
}

