/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rap.rwt.internal.textsize.ProbeStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeRecalculation;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SerializableCompatibility;

class MeasurementOperator
implements SerializableCompatibility {
    static final String TYPE = "rwt.client.TextSizeMeasurement";
    static final String METHOD_MEASURE_ITEMS = "measureItems";
    static final String PARAM_ITEMS = "items";
    static final String METHOD_STORE_MEASUREMENTS = "storeMeasurements";
    static final String PARAM_RESULTS = "results";
    private final RemoteObject remoteObject;
    private final Set<Probe> probes;
    private final Set<MeasurementItem> items;

    MeasurementOperator() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        this.remoteObject = connection.createServiceObject(TYPE);
        this.remoteObject.setHandler(new MeasurementOperatorHandler());
        this.probes = new HashSet<Probe>();
        this.items = new HashSet<MeasurementItem>();
        this.addStartupProbesToBuffer();
    }

    private void addStartupProbesToBuffer() {
        Probe[] probeList = TextSizeStorageUtil.getProbeStore().getProbes();
        this.probes.addAll(Arrays.asList(probeList));
    }

    int getProbeCount() {
        return this.probes.size();
    }

    Probe[] getProbes() {
        return this.probes.toArray(new Probe[this.probes.size()]);
    }

    void addProbeToMeasure(FontData fontData) {
        ProbeStore probeStore = TextSizeStorageUtil.getProbeStore();
        Probe probe = probeStore.getProbe(fontData);
        if (probe == null) {
            probe = probeStore.createProbe(fontData);
        }
        this.probes.add(probe);
    }

    int getItemCount() {
        return this.items.size();
    }

    MeasurementItem[] getItems() {
        return this.items.toArray(new MeasurementItem[this.items.size()]);
    }

    void addItemToMeasure(MeasurementItem newItem) {
        this.items.add(newItem);
    }

    void renderMeasurementItems() {
        Probe[] probes = this.getProbes();
        MeasurementItem[] items = this.getItems();
        if (probes.length > 0 || items.length > 0) {
            JsonArray itemsArray = new JsonArray();
            SerializableCompatibility[] serializableCompatibilityArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                Probe probe = serializableCompatibilityArray[n2];
                itemsArray.add(MeasurementUtil.createProbeParamObject(probe));
                ++n2;
            }
            serializableCompatibilityArray = items;
            n = items.length;
            n2 = 0;
            while (n2 < n) {
                SerializableCompatibility item = serializableCompatibilityArray[n2];
                itemsArray.add(MeasurementUtil.createItemParamObject((MeasurementItem)item));
                ++n2;
            }
            JsonObject parameters = new JsonObject().add(PARAM_ITEMS, itemsArray);
            ContextProvider.getProtocolWriter().appendCall(TYPE, METHOD_MEASURE_ITEMS, parameters);
        }
    }

    private final class MeasurementOperatorHandler
    extends AbstractOperationHandler {
        private MeasurementOperatorHandler() {
        }

        @Override
        public void handleCall(String method, JsonObject parameters) {
            if (MeasurementOperator.METHOD_STORE_MEASUREMENTS.equals(method)) {
                final JsonObject results = parameters.get(MeasurementOperator.PARAM_RESULTS).asObject();
                if (LifeCycleUtil.isStartup()) {
                    this.handleMeasuredFontProbeSizes(results);
                } else {
                    ProcessActionRunner.add(new Runnable(){

                        @Override
                        public void run() {
                            MeasurementOperatorHandler.this.handleMeasuredFontProbeSizes(results);
                            if (MeasurementOperatorHandler.this.handleMeasuredTextSizes(results)) {
                                TextSizeRecalculation.execute();
                            }
                        }
                    });
                }
            }
        }

        private void handleMeasuredFontProbeSizes(JsonObject results) {
            Iterator probeList = MeasurementOperator.this.probes.iterator();
            while (probeList.hasNext()) {
                Probe probe = (Probe)probeList.next();
                Point size = this.readMeasuredSize(results, MeasurementUtil.getId(probe));
                if (size == null) continue;
                this.createProbeResult(probe, size);
                probeList.remove();
            }
        }

        private boolean handleMeasuredTextSizes(JsonObject results) {
            int originalItemsSize = MeasurementOperator.this.items.size();
            Iterator itemList = MeasurementOperator.this.items.iterator();
            while (itemList.hasNext()) {
                MeasurementItem item = (MeasurementItem)itemList.next();
                Point size = this.readMeasuredSize(results, MeasurementUtil.getId(item));
                if (size == null) continue;
                this.storeTextMeasurement(item, size);
                itemList.remove();
            }
            return originalItemsSize != MeasurementOperator.this.items.size();
        }

        private Point readMeasuredSize(JsonObject results, String id) {
            JsonValue value = results.get(id);
            if (value != null) {
                return JsonMapping.readPoint(value);
            }
            return null;
        }

        private void createProbeResult(Probe probe, Point size) {
            ProbeResultStore.getInstance().createProbeResult(probe, size);
        }

        private void storeTextMeasurement(MeasurementItem item, Point size) {
            FontData fontData = item.getFontData();
            String textToMeasure = item.getTextToMeasure();
            int wrapWidth = item.getWrapWidth();
            int mode = item.getMode();
            TextSizeStorageUtil.store(fontData, textToMeasure, wrapWidth, mode, size);
        }
    }
}

