/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.dialogs.HandlerChainSelectionDialog;
import org.eclipse.jst.ws.internal.jaxws.ui.dialogs.NewHandlerChainDialog;
import org.eclipse.jst.ws.internal.jaxws.ui.filters.NewHandlerChainViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewJAXWSHandlerWizardPage
extends NewTypeWizardPage {
    private List<String> logicalHandlerList = new ArrayList<String>();
    private List<String> soapHandlerList = new ArrayList<String>();
    private IStatus ok_status = new Status(0, "org.eclipse.jst.ws.jaxws.ui", "");
    private IStatus superClassImplementsStatus = Status.OK_STATUS;
    private IStatus addNewHandlerChainStatus = Status.OK_STATUS;
    private IStatus editHandlerChainStatus = Status.OK_STATUS;
    private IStatus associateWebServiceStatus = Status.OK_STATUS;
    private Combo handlerTypeCombo;
    private Button configureHandlerChainButton;
    private Button createHandlerChainButton;
    private Text newHandlerChainText;
    private Button browseNewHandlerChainButton;
    private Button editHandlerChainButton;
    private Text exisitingHandlerChainText;
    private Button browseExistingHandlerChainButton;
    private Button associateHandlerChainButton;
    private Text webServiceText;
    private Button browseWebServiceButton;

    public NewJAXWSHandlerWizardPage() {
        super(true, "create.new.handler.chain.page");
        this.setTitle(JAXWSUIMessages.JAXWS_HANDLER_WIZARD_PAGE_TITLE);
        this.setDescription(JAXWSUIMessages.JAXWS_HANDLER_WIZARD_PAGE_DESCRIPTION);
        this.logicalHandlerList.add("javax.xml.ws.handler.LogicalHandler<javax.xml.ws.handler.LogicalMessageContext>");
        this.soapHandlerList.add("javax.xml.ws.handler.soap.SOAPHandler<javax.xml.ws.handler.soap.SOAPMessageContext>");
    }

    public void init(IStructuredSelection selection) {
        IJavaElement javaElement = this.getInitialJavaElement(selection);
        this.initContainerPage(javaElement);
        this.initTypePage(javaElement);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns;
        composite.setLayout((Layout)gridLayout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        Label handlerTypeLabel = new Label(composite, 0);
        handlerTypeLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_TYPE);
        this.handlerTypeCombo = new Combo(composite, 2056);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 2;
        this.handlerTypeCombo.setLayoutData((Object)gridData);
        this.handlerTypeCombo.add(JAXWSUIMessages.JAXWS_LOGICAL_HANDLER);
        this.handlerTypeCombo.add(JAXWSUIMessages.JAXWS_SOAP_HANDLER);
        this.handlerTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                if (combo.getSelectionIndex() == 0) {
                    NewJAXWSHandlerWizardPage.this.setSuperInterfaces(NewJAXWSHandlerWizardPage.this.logicalHandlerList, true);
                } else if (combo.getSelectionIndex() == 1) {
                    NewJAXWSHandlerWizardPage.this.setSuperInterfaces(NewJAXWSHandlerWizardPage.this.soapHandlerList, true);
                }
            }
        });
        Group configurationGroup = new Group(composite, 32);
        configurationGroup.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        configurationGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 4;
        configurationGroup.setLayoutData((Object)gridData);
        this.configureHandlerChainButton = new Button((Composite)configurationGroup, 32);
        this.configureHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_ADD);
        this.configureHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    NewJAXWSHandlerWizardPage.this.createHandlerChainButton.setEnabled(true);
                    NewJAXWSHandlerWizardPage.this.editHandlerChainButton.setEnabled(true);
                    NewJAXWSHandlerWizardPage.this.associateHandlerChainButton.setEnabled(true);
                    NewJAXWSHandlerWizardPage.this.enableNewHandlerChainFileWidgets(NewJAXWSHandlerWizardPage.this.createHandlerChainButton.getSelection());
                    NewJAXWSHandlerWizardPage.this.enableEditHandlerChainFileWidgets(NewJAXWSHandlerWizardPage.this.editHandlerChainButton.getSelection());
                    NewJAXWSHandlerWizardPage.this.enableWebServiceWidgets(NewJAXWSHandlerWizardPage.this.associateHandlerChainButton.getSelection());
                } else {
                    NewJAXWSHandlerWizardPage.this.createHandlerChainButton.setEnabled(false);
                    NewJAXWSHandlerWizardPage.this.editHandlerChainButton.setEnabled(false);
                    NewJAXWSHandlerWizardPage.this.associateHandlerChainButton.setEnabled(false);
                    NewJAXWSHandlerWizardPage.this.enableNewHandlerChainFileWidgets(false);
                    NewJAXWSHandlerWizardPage.this.enableEditHandlerChainFileWidgets(false);
                    NewJAXWSHandlerWizardPage.this.enableWebServiceWidgets(false);
                }
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 4;
        this.configureHandlerChainButton.setLayoutData((Object)gridData);
        Group innerGroup = new Group((Composite)configurationGroup, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        innerGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 4;
        innerGroup.setLayoutData((Object)gridData);
        this.createHandlerChainButton = new Button((Composite)innerGroup, 16);
        this.createHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        this.createHandlerChainButton.setLayoutData((Object)gridData);
        this.createHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                NewJAXWSHandlerWizardPage.this.enableNewHandlerChainFileWidgets(button.getSelection());
                NewJAXWSHandlerWizardPage.this.enableEditHandlerChainFileWidgets(!button.getSelection());
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        Label createNewHandlerLabel = new Label((Composite)innerGroup, 0);
        createNewHandlerLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_FILE_PATH1);
        this.newHandlerChainText = new Text((Composite)innerGroup, 2052);
        this.newHandlerChainText.setFont(innerGroup.getFont());
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.newHandlerChainText.setLayoutData((Object)gridData);
        this.newHandlerChainText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        this.browseNewHandlerChainButton = new Button((Composite)innerGroup, 8);
        this.browseNewHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_BROWSE1);
        gridData = new GridData(0x1000008, 4, false, false);
        this.browseNewHandlerChainButton.setLayoutData((Object)gridData);
        this.browseNewHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHandlerChainDialog dialog = new NewHandlerChainDialog(NewJAXWSHandlerWizardPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.addFilter(new NewHandlerChainViewerFilter(NewJAXWSHandlerWizardPage.this.getJavaProject(), true, true));
                if (dialog.open() == 0) {
                    NewJAXWSHandlerWizardPage.this.newHandlerChainText.setText(dialog.getFilePath());
                    NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
                }
            }
        });
        this.editHandlerChainButton = new Button((Composite)innerGroup, 16);
        this.editHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        this.editHandlerChainButton.setLayoutData((Object)gridData);
        Label addToHandlerLabel = new Label((Composite)innerGroup, 0);
        addToHandlerLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_FILE_PATH2);
        this.editHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        this.exisitingHandlerChainText = new Text((Composite)innerGroup, 2052);
        this.exisitingHandlerChainText.setFont(composite.getFont());
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.exisitingHandlerChainText.setLayoutData((Object)gridData);
        this.exisitingHandlerChainText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        this.browseExistingHandlerChainButton = new Button((Composite)innerGroup, 8);
        this.browseExistingHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_BROWSE2);
        gridData = new GridData(4, 4, false, false);
        this.browseExistingHandlerChainButton.setLayoutData((Object)gridData);
        this.browseExistingHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerChainSelectionDialog dialog = new HandlerChainSelectionDialog(NewJAXWSHandlerWizardPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.addFilter(new NewHandlerChainViewerFilter(NewJAXWSHandlerWizardPage.this.getJavaProject(), false, true));
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IResource resource = (IResource)result[0];
                    NewJAXWSHandlerWizardPage.this.exisitingHandlerChainText.setText(resource.getFullPath().toOSString());
                    NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
                }
            }
        });
        this.createSeparator((Composite)innerGroup, nColumns);
        this.associateHandlerChainButton = new Button((Composite)innerGroup, 32);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        this.associateHandlerChainButton.setLayoutData((Object)gridData);
        this.associateHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_ASSOCIATE);
        this.associateHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                NewJAXWSHandlerWizardPage.this.enableWebServiceWidgets(button.getSelection());
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        Label webServiceLabel = new Label((Composite)innerGroup, 0);
        webServiceLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WEB_SERVICE);
        this.webServiceText = new Text((Composite)innerGroup, 2052);
        this.webServiceText.setFont(composite.getFont());
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.webServiceText.setLayoutData((Object)gridData);
        this.webServiceText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
            }
        });
        this.browseWebServiceButton = new Button((Composite)innerGroup, 8);
        this.browseWebServiceButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_BROWSE3);
        gridData = new GridData(4, 4, false, false);
        this.browseWebServiceButton.setLayoutData((Object)gridData);
        this.browseWebServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(NewJAXWSHandlerWizardPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setTitle(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WS_DIALOG_TITLE);
                dialog.setMessage(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WS_DIALOG_DESCRIPTION);
                dialog.setAllowMultiple(false);
                dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.addFilter((ViewerFilter)new NewHandlerChainViewerFilter(NewJAXWSHandlerWizardPage.this.getJavaProject(), true, false));
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 1 && selection[0] instanceof ICompilationUnit) {
                            ICompilationUnit compilationUnit = (ICompilationUnit)selection[0];
                            if (AnnotationUtils.getAnnotation((IJavaElement)compilationUnit.findPrimaryType(), WebService.class) != null) {
                                return NewJAXWSHandlerWizardPage.this.ok_status;
                            }
                            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WS_DIALOG_INVALID);
                        }
                        return new Status(4, "org.eclipse.jst.ws.jaxws.ui", "");
                    }
                });
                if (dialog.open() == 0) {
                    ICompilationUnit selectedCompilationUnit = (ICompilationUnit)dialog.getFirstResult();
                    NewJAXWSHandlerWizardPage.this.webServiceText.setText(selectedCompilationUnit.findPrimaryType().getFullyQualifiedName());
                    NewJAXWSHandlerWizardPage.this.updateConfigureHandlerStatus();
                }
            }
        });
        composite.pack();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.createHandlerChainButton.setSelection(true);
        this.createHandlerChainButton.setEnabled(false);
        this.editHandlerChainButton.setEnabled(false);
        this.associateHandlerChainButton.setEnabled(false);
        this.enableNewHandlerChainFileWidgets(false);
        this.enableEditHandlerChainFileWidgets(false);
        this.enableWebServiceWidgets(false);
    }

    public boolean isConfigureHandlerChain() {
        return this.configureHandlerChainButton.getSelection();
    }

    public boolean isCreateHandlerChain() {
        return this.createHandlerChainButton.getSelection();
    }

    public boolean isEditHandlerChain() {
        return this.editHandlerChainButton.getSelection();
    }

    public String getSelectedHandlerType() {
        return this.handlerTypeCombo.getText();
    }

    public String getNewHandlerChainPath() {
        return this.newHandlerChainText.getText();
    }

    public String getExistingHandlerChainPath() {
        return this.exisitingHandlerChainText.getText();
    }

    public String getHandlerChainPath() {
        if (this.isCreateHandlerChain()) {
            return this.getNewHandlerChainPath();
        }
        if (this.isEditHandlerChain()) {
            return this.getExistingHandlerChainPath();
        }
        return "";
    }

    public boolean isAssociateHandlerChain() {
        return this.associateHandlerChainButton.getSelection();
    }

    public String getSelectedWebServicePath() {
        return this.webServiceText.getText();
    }

    private void enableEditHandlerChainFileWidgets(boolean enable) {
        this.exisitingHandlerChainText.setEnabled(enable);
        this.browseExistingHandlerChainButton.setEnabled(enable);
    }

    private void enableNewHandlerChainFileWidgets(boolean enable) {
        this.newHandlerChainText.setEnabled(enable);
        this.browseNewHandlerChainButton.setEnabled(enable);
    }

    private void enableWebServiceWidgets(boolean enable) {
        this.webServiceText.setEnabled(enable);
        this.browseWebServiceButton.setEnabled(enable);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this.superClassImplementsStatus, this.addNewHandlerChainStatus, this.editHandlerChainStatus, this.associateWebServiceStatus};
        this.updateStatus(status);
    }

    private void updateConfigureHandlerStatus() {
        try {
            this.validateNewHandlerChainField();
            this.validateExistingHandlerChainField();
            this.validateWebServiceField();
            this.doStatusUpdate();
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
    }

    private IStatus validateNewHandlerChainField() throws JavaModelException {
        if (this.isConfigureHandlerChain() && this.isCreateHandlerChain()) {
            this.editHandlerChainStatus = this.ok_status;
            String newHandlerChainPath = this.getNewHandlerChainPath().trim();
            if (newHandlerChainPath.length() == 0) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_NEW_HANDLER_PATH_EMTPY);
                return this.addNewHandlerChainStatus;
            }
            if (!newHandlerChainPath.endsWith(".xml")) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_INVALID_NAME);
                return this.addNewHandlerChainStatus;
            }
            Path path = new Path(newHandlerChainPath);
            if (path.segmentCount() >= 2) {
                IPackageFragmentRoot[] packageFragmentRoots;
                String[] segmenets = path.segments();
                if (!segmenets[0].equals(this.getJavaProject().getElementName())) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.getJavaProject().getElementName()));
                    return this.addNewHandlerChainStatus;
                }
                boolean inSourceFolder = false;
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = this.getJavaProject().getPackageFragmentRoots();
                int n = packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (segmenets[1].equals(packageFragmentRoot.getElementName())) {
                        inSourceFolder = true;
                        break;
                    }
                    ++n2;
                }
                if (!inSourceFolder) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.getJavaProject().getElementName()));
                    return this.addNewHandlerChainStatus;
                }
                if (path.lastSegment() != null && path.lastSegment().equals(".xml")) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_EMPTY_FILE_NAME);
                    return this.addNewHandlerChainStatus;
                }
            } else {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.getJavaProject().getElementName()));
                return this.addNewHandlerChainStatus;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_EXISTS, (Object)res.getName()));
                return this.addNewHandlerChainStatus;
            }
            this.addNewHandlerChainStatus = this.ok_status;
            return this.addNewHandlerChainStatus;
        }
        this.addNewHandlerChainStatus = this.ok_status;
        return this.addNewHandlerChainStatus;
    }

    private IStatus validateExistingHandlerChainField() {
        if (this.isConfigureHandlerChain() && this.isEditHandlerChain()) {
            this.addNewHandlerChainStatus = this.ok_status;
            String existingHandlerChainPath = this.getExistingHandlerChainPath().trim();
            if (existingHandlerChainPath.length() == 0) {
                this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EXISTING_HANDLER_PATH_EMTPY);
                return this.editHandlerChainStatus;
            }
            if (!existingHandlerChainPath.endsWith(".xml")) {
                this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_INVALID_NAME);
                return this.editHandlerChainStatus;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(existingHandlerChainPath);
            if (path.segmentCount() > 1 && path.segment(0).equals(this.getJavaProject().getElementName()) && workspace.getRoot().getFile((IPath)path).exists()) {
                this.editHandlerChainStatus = this.ok_status;
                return this.editHandlerChainStatus;
            }
            this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT_FILE_NOT_FOUND, (Object)existingHandlerChainPath));
            return this.editHandlerChainStatus;
        }
        this.editHandlerChainStatus = this.ok_status;
        return this.editHandlerChainStatus;
    }

    private IStatus validateWebServiceField() throws JavaModelException {
        if (this.isConfigureHandlerChain() && this.isAssociateHandlerChain()) {
            String webServicePath = this.getSelectedWebServicePath().trim();
            if (webServicePath.length() == 0) {
                this.associateWebServiceStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WS_PATH_EMTPY);
                return this.associateWebServiceStatus;
            }
            if (this.getJavaProject().findType(webServicePath) == null) {
                this.associateWebServiceStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_WS_NOT_FOUND);
                return this.associateWebServiceStatus;
            }
            this.associateWebServiceStatus = this.ok_status;
            return this.associateWebServiceStatus;
        }
        this.associateWebServiceStatus = this.ok_status;
        return this.associateWebServiceStatus;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTypeWizardPage.superclass") || fieldName.equals("NewTypeWizardPage.interfaces")) {
            try {
                if (this.getSuperInterfaces().size() == 0 && this.fSuperClassStatus.isOK()) {
                    IType type = this.getJavaProject().findType(this.getSuperClass());
                    if (type != null) {
                        ArrayList<String> interfaceNames = new ArrayList<String>();
                        List<String> superInterfaceNames = Arrays.asList(type.getSuperInterfaceNames());
                        for (String interfaceName : superInterfaceNames) {
                            interfaceNames.add(Signature.getTypeErasure((String)interfaceName));
                        }
                        this.superClassImplementsStatus = interfaceNames.contains("javax.xml.ws.handler.soap.SOAPHandler") || interfaceNames.contains("javax.xml.ws.handler.LogicalHandler") ? this.ok_status : new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_EXTEND_IMPLEMENT_HANDLER);
                    }
                } else {
                    this.superClassImplementsStatus = Status.OK_STATUS;
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme);
            }
        }
        this.doStatusUpdate();
    }

    protected IStatus superInterfacesChanged() {
        IStatus status = Status.OK_STATUS;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            String interfaceName = "javax.xml.ws.handler.LogicalHandler";
            try {
                IType type = root.getJavaProject().findType(interfaceName);
                if (type == null) {
                    status = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_LIBRARY_CLASSPATH);
                    return status;
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return status;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, false, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor != null) {
            monitor.done();
        }
    }
}

