/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class EmfParsleyUtil {
    protected EmfParsleyUtil() {
    }

    public static Collection<Object> ensureCollection(Object contents) {
        if (contents == null) {
            return Collections.emptyList();
        }
        return EmfParsleyUtil.ensureCollectionInternal(contents);
    }

    private static Collection<Object> ensureCollectionInternal(Object contents) {
        if (contents instanceof Collection) {
            return (Collection)contents;
        }
        if (contents instanceof Iterable) {
            return Lists.newArrayList((Iterable)((Iterable)contents));
        }
        if (contents instanceof Iterator) {
            return Lists.newArrayList((Iterator)((Iterator)contents));
        }
        if (contents.getClass().isArray()) {
            return Arrays.asList((Object[])contents);
        }
        return Collections.singleton(contents);
    }

    public static int[] toIntArray(List<Integer> intList) {
        int[] result = new int[intList.size()];
        int i = 0;
        for (Integer e : intList) {
            result[i++] = e;
        }
        return result;
    }

    public static EObject getEObjectOrNull(Object o) {
        if (o instanceof EObject) {
            return (EObject)o;
        }
        return null;
    }

    public static int compareValues(Object value1, Object value2) {
        if (EmfParsleyUtil.comparables(value1, value2)) {
            return ((Comparable)value1).compareTo(value2);
        }
        if (value1 != null && value2 != null) {
            return value1.toString().compareTo(value2.toString());
        }
        if (value1 != null) {
            return 1;
        }
        if (value2 != null) {
            return -1;
        }
        return 0;
    }

    private static boolean comparables(Object value1, Object value2) {
        return value1 instanceof Comparable && value2 instanceof Comparable;
    }
}

