/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.MakePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.progress.IProgressService;

public class TargetBuild {
    public static final String LAST_TARGET = "lastTarget";
    public static final String LAST_TARGET_CONTAINER = "lastTargetContainer";

    static void saveAllResources(IMakeTarget[] targets) {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < targets.length) {
            IMakeTarget target = targets[i];
            projects.add(target.getProject());
            try {
                projects.addAll(Arrays.asList(target.getProject().getReferencedProjects()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i2 = 0;
        while (i2 < windows.length) {
            IWorkbenchPage[] pages = windows[i2].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] editorReferences = page.getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    IFile inputFile;
                    IEditorInput input;
                    IEditorPart editor = editorReferences[k].getEditor(false);
                    if (editor != null && editor.isDirty() && (input = editor.getEditorInput()) instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        page.saveEditor(editor, false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    private static void runWithProgressDialog(Shell shell, Job job) {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        service.showInDialog(shell, job);
    }

    public static void buildTargets(Shell shell, final IMakeTarget[] targets) {
        CUIPlugin.getDefault().startGlobalConsole();
        TargetBuild.saveAllResources(targets);
        Job targetJob = new Job(MakeUIPlugin.getResourceString("TargetBuild.backgroundTask.name")){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MakeUIPlugin.getResourceString("TargetBuild.monitor.beginTask"), (int)targets.length);
                try {
                    try {
                        int i = 0;
                        while (i < targets.length) {
                            final IMakeTarget target = targets[i];
                            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    target.build(monitor);
                                }
                            };
                            MakeUIPlugin.getWorkspace().run(runnable, null, 0, (IProgressMonitor)subMonitor.newChild(1));
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        targetJob.schedule();
        if (!MakePreferencePage.isBuildTargetInBackground()) {
            TargetBuild.runWithProgressDialog(shell, targetJob);
        }
    }
}

