/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.WritePrefReadWriteLockManager;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.nativerdf.ConcurrentCache;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.datastore.DataStore;
import org.eclipse.rdf4j.sail.nativerdf.datastore.RecoveredDataException;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptIRI;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptIRIOrBNode;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptLiteral;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptUnknownValue;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeBNode;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeIRI;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeLiteral;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeResource;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ValueStore
extends SimpleValueFactory {
    private static final Logger logger = LoggerFactory.getLogger(ValueStore.class);
    public static final int VALUE_CACHE_SIZE = 512;
    public static final int VALUE_ID_CACHE_SIZE = 128;
    public static final int NAMESPACE_CACHE_SIZE = 64;
    public static final int NAMESPACE_ID_CACHE_SIZE = 32;
    private static final String FILENAME_PREFIX = "values";
    private static final byte URI_VALUE = 1;
    private static final byte BNODE_VALUE = 2;
    private static final byte LITERAL_VALUE = 3;
    private final DataStore dataStore;
    private final ReadWriteLockManager lockManager = new WritePrefReadWriteLockManager();
    private volatile ValueStoreRevision revision;
    private final ConcurrentCache<Integer, NativeValue> valueCache;
    private final ConcurrentCache<NativeValue, Integer> valueIDCache;
    private final ConcurrentCache<Integer, String> namespaceCache;
    private final ConcurrentCache<String, Integer> namespaceIDCache;

    public ValueStore(File dataDir) throws IOException {
        this(dataDir, false);
    }

    public ValueStore(File dataDir, boolean forceSync) throws IOException {
        this(dataDir, forceSync, 512, 128, 64, 32);
    }

    public ValueStore(File dataDir, boolean forceSync, int valueCacheSize, int valueIDCacheSize, int namespaceCacheSize, int namespaceIDCacheSize) throws IOException {
        this.dataStore = new DataStore(dataDir, FILENAME_PREFIX, forceSync, this);
        this.valueCache = new ConcurrentCache(valueCacheSize);
        this.valueIDCache = new ConcurrentCache(valueIDCacheSize);
        this.namespaceCache = new ConcurrentCache(namespaceCacheSize);
        this.namespaceIDCache = new ConcurrentCache(namespaceIDCacheSize);
        this.setNewRevision();
    }

    private void setNewRevision() {
        this.revision = new ValueStoreRevision(this);
    }

    public ValueStoreRevision getRevision() {
        return this.revision;
    }

    public Lock getReadLock() throws InterruptedException {
        return this.lockManager.getReadLock();
    }

    public NativeValue getValue(int id) throws IOException {
        Integer cacheID = id;
        NativeValue resultValue = this.valueCache.get(cacheID);
        if (resultValue == null) {
            try {
                byte[] data = this.dataStore.getData(id);
                if (data != null && !((resultValue = this.data2value(id, data)) instanceof CorruptValue)) {
                    this.valueCache.put(cacheID, resultValue);
                }
            }
            catch (RecoveredDataException rde) {
                byte[] recovered = rde.getData();
                if (recovered != null && recovered.length > 0) {
                    byte t = recovered[0];
                    resultValue = t == 1 ? new CorruptIRI(this.revision, id, null, recovered) : (t == 2 ? new CorruptIRIOrBNode(this.revision, id, recovered) : (t == 3 ? new CorruptLiteral(this.revision, id, recovered) : new CorruptUnknownValue(this.revision, id, recovered)));
                }
                resultValue = new CorruptUnknownValue(this.revision, id, recovered);
            }
        }
        return resultValue;
    }

    public <T extends NativeValue & Resource> T getResource(int id) throws IOException {
        NativeValue resultValue = this.getValue(id);
        if (resultValue != null && !(resultValue instanceof Resource)) {
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES && resultValue instanceof CorruptValue) {
                return (T)new CorruptIRIOrBNode(this.revision, id, ((CorruptValue)resultValue).getData());
            }
            logger.warn("NativeStore is possibly corrupt. To attempt to repair or retrieve the data, read the documentation on http://rdf4j.org about the system property org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes");
        }
        return (T)resultValue;
    }

    public <T extends NativeValue & IRI> T getIRI(int id) throws IOException {
        NativeValue resultValue = this.getValue(id);
        if (resultValue != null && !(resultValue instanceof IRI)) {
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES && resultValue instanceof CorruptValue) {
                if (resultValue instanceof CorruptIRI) {
                    return (T)resultValue;
                }
                return (T)new CorruptIRI(this.revision, id, null, ((CorruptValue)resultValue).getData());
            }
            logger.warn("NativeStore is possibly corrupt. To attempt to repair or retrieve the data, read the documentation on http://rdf4j.org about the system property org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes");
        }
        return (T)resultValue;
    }

    public int getID(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue;
        if (logger.isDebugEnabled()) {
            logger.debug("getID start thread={} value={}", (Object)ValueStore.threadName(), (Object)ValueStore.describeValue(value));
        }
        if ((isOwnValue = this.isOwnValue(value)) && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug("getID returning cached internal id {} for value={} thread={}", new Object[]{id, ValueStore.describeValue(value), ValueStore.threadName()});
            }
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getID returning cache id {} for value={} thread={}", new Object[]{id, ValueStore.describeValue(value), ValueStore.threadName()});
            }
            return id;
        }
        byte[] data = this.value2data(value, false);
        if (data == null && value instanceof Literal) {
            data = this.literal2legacy((Literal)value);
        }
        if (data != null) {
            int id2;
            if (logger.isDebugEnabled()) {
                logger.debug("getID querying datastore for value={} thread={} dataSummary={}", new Object[]{ValueStore.describeValue(value), ValueStore.threadName(), ValueStore.summarize(data)});
            }
            if ((id2 = this.dataStore.getID(data)) == -1 && value instanceof Literal) {
                id2 = this.dataStore.getID(this.literal2legacy((Literal)value));
            }
            if (id2 != -1) {
                if (isOwnValue) {
                    ((NativeValue)value).setInternalID(id2, this.revision);
                } else {
                    NativeValue nv = this.getNativeValue(value);
                    nv.setInternalID(id2, this.revision);
                    this.valueIDCache.put(nv, id2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("getID resolved value={} id={} thread={}", new Object[]{ValueStore.describeValue(value), id2, ValueStore.threadName()});
                }
            }
            return id2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getID returning UNKNOWN for value={} thread={}", (Object)ValueStore.describeValue(value), (Object)ValueStore.threadName());
        }
        return -1;
    }

    private static String summarize(byte[] data) {
        if (data == null) {
            return "null";
        }
        return "len=" + data.length + ",hash=" + Arrays.hashCode(data);
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    private static String describeValue(Value value) {
        Object lexical;
        if (value == null) {
            return "null";
        }
        try {
            lexical = value.stringValue();
        }
        catch (Exception e) {
            lexical = String.valueOf(value);
        }
        if (((String)lexical).length() > 120) {
            lexical = ((String)lexical).substring(0, 117) + "...";
        }
        return value.getClass().getSimpleName() + "[" + (String)lexical + "]";
    }

    public synchronized int storeValue(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue;
        if (logger.isDebugEnabled()) {
            logger.debug("storeValue start thread={} value={}", (Object)ValueStore.threadName(), (Object)ValueStore.describeValue(value));
        }
        if ((isOwnValue = this.isOwnValue(value)) && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug("storeValue returning cached internal id {} for value={} thread={}", new Object[]{id, ValueStore.describeValue(value), ValueStore.threadName()});
            }
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("storeValue returning cached id {} for value={} thread={}", new Object[]{id, ValueStore.describeValue(value), ValueStore.threadName()});
            }
            return id;
        }
        byte[] valueData = this.value2data(value, true);
        if (valueData == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("storeValue computed no data for value={} thread={}", (Object)ValueStore.describeValue(value), (Object)ValueStore.threadName());
            }
            return -1;
        }
        int id2 = this.dataStore.storeData(valueData);
        NativeValue nv = isOwnValue ? (NativeValue)value : this.getNativeValue(value);
        nv.setInternalID(id2, this.revision);
        this.valueIDCache.put(nv, id2);
        if (logger.isDebugEnabled()) {
            logger.debug("storeValue stored value={} assigned id={} thread={} dataSummary={}", new Object[]{ValueStore.describeValue(nv), id2, ValueStore.threadName(), ValueStore.summarize(valueData)});
        }
        return id2;
    }

    public void clear() throws IOException {
        try {
            Lock writeLock = this.lockManager.getWriteLock();
            try {
                this.dataStore.clear();
                this.valueCache.clear();
                this.valueIDCache.clear();
                this.namespaceCache.clear();
                this.namespaceIDCache.clear();
                this.setNewRevision();
            }
            finally {
                writeLock.release();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to acquire write lock", e);
        }
    }

    public void sync() throws IOException {
        this.dataStore.sync();
    }

    public void close() throws IOException {
        this.dataStore.close();
    }

    public void checkConsistency() throws SailException, IOException {
        int maxID = this.dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            NativeValue value;
            try {
                byte[] data = this.dataStore.getData(id);
                if (data == null || data.length == 0) {
                    throw new SailException("Empty data array for value with id " + id);
                }
                if (this.isNamespaceData(data)) {
                    String namespace;
                    block7: {
                        namespace = this.data2namespace(data);
                        try {
                            if (id != this.getNamespaceID(namespace, false) || !URI.create(namespace + "part").isAbsolute()) break block7;
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    logger.error("Inconsistent namespace data for id {} (also id {}): {}", new Object[]{id, this.getNamespaceID(namespace, false), namespace});
                    throw new SailException("Store must be manually exported and imported to fix namespaces like " + namespace);
                }
                value = this.data2value(id, data);
                if (id == this.getID(this.copy(value))) continue;
                throw new SailException("Store must be manually exported and imported to merge values like " + String.valueOf(value));
            }
            catch (RecoveredDataException rde) {
                value = new CorruptUnknownValue(this.revision, id, rde.getData());
                if (id == this.getID(this.copy(value))) continue;
                throw new SailException("Store must be manually exported and imported to merge values like " + String.valueOf(value));
            }
        }
    }

    private Value copy(Value value) {
        if (value instanceof IRI) {
            return this.createIRI(value.stringValue());
        }
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (Literals.isLanguageLiteral((Literal)lit)) {
                return this.createLiteral(value.stringValue(), (String)lit.getLanguage().orElse(null));
            }
            return this.createLiteral(value.stringValue(), lit.getDatatype());
        }
        return this.createBNode(value.stringValue());
    }

    private boolean isOwnValue(Value value) {
        return value instanceof NativeValue && ((NativeValue)value).getValueStoreRevision().getValueStore() == this;
    }

    private boolean revisionIsCurrent(NativeValue value) {
        return this.revision.equals(value.getValueStoreRevision());
    }

    private byte[] value2data(Value value, boolean create) throws IOException {
        byte[] data;
        if (value instanceof IRI) {
            data = this.uri2data((IRI)value, create);
        } else if (value instanceof BNode) {
            data = this.bnode2data((BNode)value, create);
        } else if (value instanceof Literal) {
            data = this.literal2data((Literal)value, create);
        } else {
            throw new IllegalArgumentException("value parameter should be a URI, BNode or Literal");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("value2data thread={} value={} create={} summary={}", new Object[]{ValueStore.threadName(), ValueStore.describeValue(value), create, ValueStore.summarize(data)});
        }
        return data;
    }

    private byte[] uri2data(IRI uri, boolean create) throws IOException {
        int nsID = this.getNamespaceID(uri.getNamespace(), create);
        if (logger.isDebugEnabled()) {
            logger.debug("uri2data thread={} namespace='{}' nsId={} create={}", new Object[]{ValueStore.threadName(), uri.getNamespace(), nsID, create});
        }
        if (nsID == -1) {
            return null;
        }
        byte[] localNameData = uri.getLocalName().getBytes(StandardCharsets.UTF_8);
        byte[] uriData = new byte[5 + localNameData.length];
        uriData[0] = 1;
        ByteArrayUtil.putInt((int)nsID, (byte[])uriData, (int)1);
        ByteArrayUtil.put((byte[])localNameData, (byte[])uriData, (int)5);
        if (logger.isDebugEnabled()) {
            logger.debug("uri2data produced len={} summary={} thread={}", new Object[]{uriData.length, ValueStore.summarize(uriData), ValueStore.threadName()});
        }
        return uriData;
    }

    private byte[] bnode2data(BNode bNode, boolean create) {
        byte[] idData = bNode.getID().getBytes(StandardCharsets.UTF_8);
        byte[] bNodeData = new byte[1 + idData.length];
        bNodeData[0] = 2;
        ByteArrayUtil.put((byte[])idData, (byte[])bNodeData, (int)1);
        return bNodeData;
    }

    private byte[] literal2data(Literal literal, boolean create) throws IOException {
        return this.literal2data(literal.getLabel(), literal.getLanguage(), literal.getDatatype(), create);
    }

    private byte[] literal2legacy(Literal literal) throws IOException {
        IRI dt = literal.getDatatype();
        if (XSD.STRING.equals((Object)dt) || RDF.LANGSTRING.equals((Object)dt)) {
            return this.literal2data(literal.getLabel(), literal.getLanguage(), null, false);
        }
        return this.literal2data(literal.getLabel(), literal.getLanguage(), dt, false);
    }

    private byte[] literal2data(String label, Optional<String> lang, IRI dt, boolean create) throws IOException, UnsupportedEncodingException {
        int datatypeID = -1;
        if (create) {
            datatypeID = this.storeValue((Value)dt);
        } else if (dt != null && (datatypeID = this.getID((Value)dt)) == -1) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("literal2data thread={} valueLength={} langPresent={} datatype={} datatypeId={} create={}", new Object[]{ValueStore.threadName(), label.length(), lang.isPresent(), dt, datatypeID, create});
        }
        byte[] langData = null;
        int langDataLength = 0;
        if (lang.isPresent() && (langDataLength = (langData = lang.get().getBytes(StandardCharsets.UTF_8)).length) > 255) {
            throw new IllegalArgumentException("Language tag too long (length " + langDataLength + " > maximum 255): " + lang.get());
        }
        byte[] labelData = label.getBytes(StandardCharsets.UTF_8);
        byte[] literalData = new byte[6 + langDataLength + labelData.length];
        literalData[0] = 3;
        ByteArrayUtil.putInt((int)datatypeID, (byte[])literalData, (int)1);
        literalData[5] = (byte)(langDataLength & 0xFF);
        if (langData != null) {
            ByteArrayUtil.put((byte[])langData, (byte[])literalData, (int)6);
        }
        ByteArrayUtil.put((byte[])labelData, (byte[])literalData, (int)(6 + langDataLength));
        if (logger.isDebugEnabled()) {
            logger.debug("literal2data produced len={} summary={} thread={}", new Object[]{literalData.length, ValueStore.summarize(literalData), ValueStore.threadName()});
        }
        return literalData;
    }

    private boolean isNamespaceData(byte[] data) {
        return data[0] != 1 && data[0] != 2 && data[0] != 3;
    }

    @InternalUseOnly
    public NativeValue data2value(int id, byte[] data) throws IOException {
        if (data.length == 0) {
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES) {
                logger.error("Soft fail on corrupt data: Empty data array for value with id {}", (Object)id);
                return new CorruptUnknownValue(this.revision, id, data);
            }
            throw new SailException("Empty data array for value with id " + id + " consider setting the system property org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes to true");
        }
        switch (data[0]) {
            case 1: {
                return (NativeValue)this.data2uri(id, data);
            }
            case 2: {
                return this.data2bnode(id, data);
            }
            case 3: {
                return this.data2literal(id, data);
            }
        }
        if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES) {
            logger.error("Soft fail on corrupt data: Invalid type {} for value with id {}", (Object)data[0], (Object)id);
            return new CorruptUnknownValue(this.revision, id, data);
        }
        throw new SailException("Invalid type " + data[0] + " for value with id " + id + "  consider setting the system property org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes to true");
    }

    private <T extends IRI & NativeValue> T data2uri(int id, byte[] data) throws IOException {
        String namespace = null;
        try {
            int nsID = ByteArrayUtil.getInt((byte[])data, (int)1);
            namespace = this.getNamespace(nsID);
            String localName = new String(data, 5, data.length - 5, StandardCharsets.UTF_8);
            return (T)new NativeIRI(this.revision, namespace, localName, id);
        }
        catch (Throwable e) {
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES && (e instanceof Exception || e instanceof AssertionError)) {
                return (T)new CorruptIRI(this.revision, id, namespace, data);
            }
            logger.warn("NativeStore is possibly corrupt. To attempt to repair or retrieve the data, read the documentation on http://rdf4j.org about the system property org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes");
            throw e;
        }
    }

    private NativeBNode data2bnode(int id, byte[] data) {
        String nodeID = new String(data, 1, data.length - 1, StandardCharsets.UTF_8);
        return new NativeBNode(this.revision, nodeID, id);
    }

    private <T extends NativeValue & Literal> T data2literal(int id, byte[] data) throws IOException {
        try {
            int datatypeID = ByteArrayUtil.getInt((byte[])data, (int)1);
            IRI datatype = null;
            if (datatypeID != -1) {
                datatype = (IRI)this.getValue(datatypeID);
            }
            String lang = null;
            int langLength = data[5] & 0xFF;
            if (langLength > 0) {
                lang = new String(data, 6, langLength, StandardCharsets.UTF_8);
            }
            String label = new String(data, 6 + langLength, data.length - 6 - langLength, StandardCharsets.UTF_8);
            if (lang != null) {
                return (T)new NativeLiteral(this.revision, label, lang, id);
            }
            if (datatype != null) {
                return (T)new NativeLiteral(this.revision, label, datatype, id);
            }
            return (T)new NativeLiteral(this.revision, label, (CoreDatatype)CoreDatatype.XSD.STRING, id);
        }
        catch (Throwable e) {
            if (NativeStore.SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES && (e instanceof Exception || e instanceof AssertionError)) {
                return (T)new CorruptLiteral(this.revision, id, data);
            }
            throw e;
        }
    }

    private String data2namespace(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    private int getNamespaceID(String namespace, boolean create) throws IOException {
        Integer cacheID;
        if (logger.isDebugEnabled()) {
            logger.debug("getNamespaceID thread={} namespace='{}' create={}", new Object[]{ValueStore.threadName(), namespace, create});
        }
        if ((cacheID = this.namespaceIDCache.get(namespace)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNamespaceID cache hit namespace='{}' id={} thread={}", new Object[]{namespace, cacheID, ValueStore.threadName()});
            }
            return cacheID;
        }
        byte[] namespaceData = namespace.getBytes(StandardCharsets.UTF_8);
        int id = create ? this.dataStore.storeData(namespaceData) : this.dataStore.getID(namespaceData);
        if (id != -1) {
            this.namespaceIDCache.put(namespace, id);
            if (logger.isDebugEnabled()) {
                logger.debug("getNamespaceID resolved namespace='{}' id={} thread={}", new Object[]{namespace, id, ValueStore.threadName()});
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("getNamespaceID unresolved namespace='{}' thread={}", (Object)namespace, (Object)ValueStore.threadName());
        }
        return id;
    }

    private String getNamespace(int id) throws IOException {
        Integer cacheID = id;
        String namespace = this.namespaceCache.get(cacheID);
        if (namespace == null) {
            try {
                byte[] namespaceData = this.dataStore.getData(id);
                namespace = this.data2namespace(namespaceData);
            }
            catch (RecoveredDataException rde) {
                namespace = this.data2namespace(rde.getData());
            }
            this.namespaceCache.put(cacheID, namespace);
        }
        return namespace;
    }

    public NativeIRI createIRI(String uri) {
        return new NativeIRI(this.revision, uri);
    }

    public NativeIRI createIRI(String namespace, String localName) {
        return new NativeIRI(this.revision, namespace, localName);
    }

    public NativeBNode createBNode(String nodeID) {
        return new NativeBNode(this.revision, nodeID);
    }

    public NativeLiteral createLiteral(String value) {
        return new NativeLiteral(this.revision, value, (CoreDatatype)CoreDatatype.XSD.STRING);
    }

    public NativeLiteral createLiteral(String value, String language) {
        return new NativeLiteral(this.revision, value, language);
    }

    public NativeLiteral createLiteral(String value, IRI datatype) {
        return new NativeLiteral(this.revision, value, datatype);
    }

    public NativeValue getNativeValue(Value value) {
        if (value instanceof Resource) {
            return this.getNativeResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getNativeLiteral((Literal)value);
        }
        throw new IllegalArgumentException("Unknown value type: " + String.valueOf(value.getClass()));
    }

    public NativeResource getNativeResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getNativeURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getNativeBNode((BNode)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + String.valueOf(resource.getClass()));
    }

    public NativeIRI getNativeURI(IRI uri) {
        if (this.isOwnValue((Value)uri)) {
            return (NativeIRI)uri;
        }
        return new NativeIRI(this.revision, uri.toString());
    }

    public NativeBNode getNativeBNode(BNode bnode) {
        if (this.isOwnValue((Value)bnode)) {
            return (NativeBNode)bnode;
        }
        return new NativeBNode(this.revision, bnode.getID());
    }

    public NativeLiteral getNativeLiteral(Literal l) {
        if (this.isOwnValue((Value)l)) {
            return (NativeLiteral)l;
        }
        if (Literals.isLanguageLiteral((Literal)l)) {
            return new NativeLiteral(this.revision, l.getLabel(), (String)l.getLanguage().get());
        }
        NativeIRI datatype = this.getNativeURI(l.getDatatype());
        return new NativeLiteral(this.revision, l.getLabel(), (IRI)datatype);
    }

    public static void main(String[] args) throws Exception {
        File dataDir = new File(args[0]);
        ValueStore valueStore = new ValueStore(dataDir);
        int maxID = valueStore.dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            try {
                byte[] data = valueStore.dataStore.getData(id);
                if (valueStore.isNamespaceData(data)) {
                    String ns = valueStore.data2namespace(data);
                    System.out.println("[" + id + "] " + ns);
                    continue;
                }
                NativeValue value = valueStore.data2value(id, data);
                System.out.println("[" + id + "] " + value.toString());
                continue;
            }
            catch (RecoveredDataException rde) {
                System.out.println("[" + id + "] CorruptUnknownValue:" + String.valueOf(new CorruptUnknownValue(valueStore.revision, id, rde.getData())));
            }
        }
    }
}

