/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.toc.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;

public class TocTopic
extends TocObject {
    private static final long serialVersionUID = 1L;

    public TocTopic(TocModel model) {
        super(model, "topic");
    }

    public TocTopic(TocModel model, String tagName) {
        super(model, tagName);
    }

    public TocTopic(TocModel model, IFile file) {
        super(model, "topic");
        IPath path = file.getFullPath();
        if (file.getProject().equals((Object)this.getSharedModel().getUnderlyingResource().getProject())) {
            this.setFieldRef(path.removeFirstSegments(1).toString());
        } else {
            this.setFieldRef(".." + path.toString());
        }
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    @Override
    public String getName() {
        return this.getFieldLabel();
    }

    @Override
    public String getPath() {
        return this.getFieldRef();
    }

    @Override
    public int getType() {
        return 1;
    }

    public boolean isFirstChildObject(TocObject tocObject) {
        return super.isFirstChildNode((IDocumentElementNode)tocObject, TocObject.class);
    }

    public boolean isLastChildObject(TocObject tocObject) {
        return super.isLastChildNode((IDocumentElementNode)tocObject, TocObject.class);
    }

    public void addChild(TocObject child) {
        this.addChildNode((IDocumentElementNode)child, true);
    }

    public void addChild(TocObject child, TocObject sibling, boolean insertBefore) {
        int currentIndex = this.indexOf((IDocumentElementNode)sibling);
        if (!insertBefore) {
            ++currentIndex;
        }
        this.addChildNode((IDocumentElementNode)child, currentIndex, true);
    }

    public void moveChild(TocObject tocObject, int newRelativeIndex) {
        this.moveChildNode((IDocumentElementNode)tocObject, newRelativeIndex, true);
    }

    public void removeChild(TocObject tocObject) {
        this.removeChildNode((IDocumentElementNode)tocObject, true);
    }

    public String getFieldLabel() {
        return this.getXMLAttributeValue("label");
    }

    public void setFieldLabel(String name) {
        this.setXMLAttribute("label", name);
    }

    public String getFieldRef() {
        return this.getXMLAttributeValue("href");
    }

    public void setFieldRef(String value) {
        this.setXMLAttribute("href", value);
    }
}

