/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class Q7ImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public Q7ImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !Q7ImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        Q7ImageDescriptor other = (Q7ImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            RcpttPlugin.log((String)Messages.bind((String)"Image data not available: {0}", (Object)descriptor), null);
        }
        return data;
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.fFlags & 2) != 0) {
            this.addBottomLeftImage(Images.getImageDescriptor("icons/overlay/error_co.gif"), pos);
        }
        if ((this.fFlags & 1) != 0) {
            this.addBottomLeftImage(Images.getImageDescriptor("icons/overlay/warning_co.gif"), pos);
        }
    }
}

