/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.custom.StyledText;

public class GotoScriptLineAction
extends Action {
    private static final String ACTION_TEXT = "Go to Line...";
    private static final String DIALOG_INVALIG_RANGE = "Line number out of range";
    private static final String DIALOG_INVALIG_INPUT = "Not a number";
    private static final String DIALOG_TITLE = "Go to Line";
    private static final String DIALOG_MESSAGE = "Enter line number (1..{0}):";
    public static final String GOTOLINE_ACTION_ID = "org.eclipse.rcptt.ui.actions.goto.line";
    private int fLastLine;
    private TextViewer fTextViewer;

    public GotoScriptLineAction(TextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.setText(ACTION_TEXT);
    }

    protected TextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public void setTextViewer(TextViewer textViewer) {
        this.fTextViewer = textViewer;
    }

    private void gotoLine(int line) {
        TextViewer viewer = this.getTextViewer();
        IDocument document = viewer.getDocument();
        try {
            int start = document.getLineOffset(line);
            StyledText widget = viewer.getTextWidget();
            widget.setRedraw(false);
            viewer.revealRange(start, 0);
            viewer.setSelectedRange(start, 0);
            widget.setFocus();
            widget.setRedraw(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.getTextViewer() != null;
    }

    public void run() {
        InputDialog d;
        TextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        try {
            this.fLastLine = document.getLineOfOffset(document.getLength()) + 1;
        }
        catch (BadLocationException ex) {
            Status status = new Status(4, "org.eclipse.rcptt.ui", 0, "Go to Line failed", (Throwable)ex);
            Q7UIPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        String title = DIALOG_TITLE;
        String message = MessageFormat.format(DIALOG_MESSAGE, new Integer(this.fLastLine));
        String currentLineStr = "";
        StyledText textWidget = viewer.getTextWidget();
        int currentLine = textWidget.getLineAtOffset(textWidget.getCaretOffset());
        if (currentLine > -1) {
            currentLineStr = Integer.toString(currentLine + 1);
        }
        if ((d = new InputDialog(viewer.getTextWidget().getShell(), title, message, currentLineStr, (IInputValidator)new NumberValidator())).open() == 0) {
            try {
                int line = Integer.parseInt(d.getValue());
                this.gotoLine(line - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class NumberValidator
    implements IInputValidator {
        NumberValidator() {
        }

        public String isValid(String input) {
            if (input == null || input.length() == 0) {
                return " ";
            }
            try {
                int i = Integer.parseInt(input);
                if (i <= 0 || GotoScriptLineAction.this.fLastLine < i) {
                    return GotoScriptLineAction.DIALOG_INVALIG_RANGE;
                }
            }
            catch (NumberFormatException x) {
                return GotoScriptLineAction.DIALOG_INVALIG_INPUT;
            }
            return null;
        }
    }
}

