/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.internal.core.model.index.Index;

public class KeyQueryPattern
implements ISearchPattern {
    private String documentName;
    private String key;

    public KeyQueryPattern(IPath path, String key) {
        this.documentName = path.removeFirstSegments(1).toString();
        this.key = key;
    }

    @Override
    public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
        Map<String, List<String>> query = index.query(this.documentName);
        List<String> name = query.get(this.key);
        if (name != null) {
            for (String n : name) {
                requestor.acceptMatch(null, this.key, n);
            }
        }
    }
}

