/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.swt.widgets.Composite;

class AutoStartEditingSupport
extends EditingSupport {
    private final CachedCheckboxTreeViewer fViewer;
    private final CellEditor fCellEditor;
    private final String[] fItems;

    public AutoStartEditingSupport(CachedCheckboxTreeViewer viewer) {
        super((ColumnViewer)viewer);
        this.fViewer = viewer;
        this.fItems = new String[]{"default", Boolean.toString(true), Boolean.toString(false)};
        this.fCellEditor = new ComboBoxCellEditor((Composite)viewer.getTree(), this.fItems, 2056);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.fCellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.fViewer.isCheckedLeafElement(element) && element instanceof IHasAutoStart;
    }

    protected Object getValue(Object element) {
        String autoStart = ((IHasAutoStart)element).getAutoStart();
        int index = Arrays.asList(this.fItems).indexOf(autoStart);
        return index < 0 ? 0 : index;
    }

    protected void setValue(Object element, Object value) {
        int index = (Integer)value;
        if (index < 0) {
            index = 0;
        }
        ((IHasAutoStart)element).setAutoStart(this.fItems[index]);
        this.fViewer.update(element, null);
    }

    public static interface IHasAutoStart {
        public String getAutoStart();

        public void setAutoStart(String var1);
    }
}

