/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.base.io.PassageFileExtension;

final class AllLicensesFromFolder
implements Supplier<List<Path>> {
    private final Optional<String> folder;

    AllLicensesFromFolder(String folder) {
        this(Optional.ofNullable(folder));
    }

    AllLicensesFromFolder(Optional<String> folder) {
        this.folder = folder;
    }

    @Override
    public List<Path> get() {
        if (!this.folder.isPresent()) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.licenses()).map(File::toPath).collect(Collectors.toList());
    }

    private File[] licenses() {
        File host = new File(this.folder.get());
        if (!host.isDirectory()) {
            return new File[0];
        }
        return host.listFiles(this.licen());
    }

    private FileFilter licen() {
        return new FileFilter(){
            private final PassageFileExtension licen = new PassageFileExtension.LicenseEncrypted();

            @Override
            public boolean accept(File file) {
                return this.licen.ends(file);
            }
        };
    }
}

