/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.api.tools.annotations.NoExtend;

@NoExtend
public class StructuredSelection
implements IStructuredSelection {
    private final Object[] elements;
    private final IElementComparer comparer;
    public static final StructuredSelection EMPTY = new StructuredSelection();

    public StructuredSelection() {
        this.elements = null;
        this.comparer = null;
    }

    public StructuredSelection(Object[] elements) {
        Assert.isNotNull((Object)elements);
        this.elements = new Object[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
        this.comparer = null;
    }

    public StructuredSelection(Object element) {
        Assert.isNotNull((Object)element);
        this.elements = new Object[]{element};
        this.comparer = null;
    }

    public StructuredSelection(List elements) {
        this(elements, null);
    }

    public StructuredSelection(List elements, IElementComparer comparer) {
        Assert.isNotNull((Object)elements);
        this.elements = elements.toArray();
        this.comparer = comparer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void s2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)o;
        if (this.isEmpty()) {
            return s2.isEmpty();
        }
        if (s2.isEmpty()) {
            return false;
        }
        boolean useComparer = this.comparer != null && this.comparer == s2.comparer;
        int myLen = this.elements.length;
        if (myLen != s2.elements.length) {
            return false;
        }
        if (useComparer) {
            int i = 0;
            while (i < myLen) {
                if (!this.comparer.equals(this.elements[i], s2.elements[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            return Arrays.equals(this.elements, s2.elements);
        }
        return true;
    }

    public int hashCode() {
        int r;
        if (this.isEmpty()) {
            return 31 + Objects.hashCode(this.comparer);
        }
        if (this.comparer != null) {
            r = 31 + this.comparer.hashCode();
            Object[] objectArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                r = 31 * r + (e == null ? 0 : this.comparer.hashCode(e));
                ++n2;
            }
        } else {
            r = Arrays.hashCode(this.elements);
        }
        return r;
    }

    @Override
    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    @Override
    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    @Override
    public Iterator iterator() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements).iterator();
    }

    @Override
    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    @Override
    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (Object[])this.elements.clone();
    }

    @Override
    public List toList() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements);
    }

    @Override
    public Stream<Object> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Arrays.stream(this.elements);
    }

    public String toString() {
        return this.isEmpty() ? JFaceResources.getString("<empty_selection>") : Arrays.toString(this.elements);
    }
}

